/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report.pdf;

import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.PdfContent;
import at.grid.themis.ontology.report.PdfContentAnnualOverview;
import at.grid.themis.ontology.report.PdfContentContactList;
import at.grid.themis.ontology.report.PdfContentDocumentList;
import at.grid.themis.ontology.report.PdfContentEventList;
import at.grid.themis.ontology.report.PdfContentForm;
import at.grid.themis.ontology.report.PdfContentHeaderEvent;
import at.grid.themis.ontology.report.PdfContentHeaderProject;
import at.grid.themis.ontology.report.PdfContentHeaderReport;
import at.grid.themis.ontology.report.PdfContentHeading1;
import at.grid.themis.ontology.report.PdfContentHeading2;
import at.grid.themis.ontology.report.PdfContentPagebreak;
import at.grid.themis.ontology.report.PdfContentParagraph;
import at.grid.themis.ontology.report.PdfContentPicture;
import at.grid.themis.ontology.report.PdfContentSignature;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.PdfContentStandardTableOpen;
import at.grid.themis.ontology.report.PdfContentTable;
import at.grid.themis.ontology.report.PdfContentTitle;
import at.grid.themis.ontology.report.PdfContentTitlepage;
import at.grid.themis.ontology.report.pdf.PdfExportBase;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import java.util.ArrayList;
import java.util.List;

public class PdfLayoutExporter
extends PdfExportBase {
    boolean isEventFilter = false;

    public PdfLayoutExporter(CmsReport rep) {
        super(rep);
    }

    @Override
    public void createContent(CmsUser user) throws DocumentException {
        ArrayList<PdfContent> contents = this.rep.templatePdfLayout;
        int countTables = 0;
        for (PdfContent content : contents) {
            if (!(content instanceof PdfContentTable)) continue;
            ++countTables;
        }
        this.progress.progress("PDF wird erzeugt");
        this.progressCurrent = this.progressFrom;
        if (countTables == 0) {
            this.progressStep = (this.progressTo - this.progressFrom) / (double)contents.size();
        }
        for (PdfContent content : contents) {
            if (countTables == 0) {
                this.progressCurrent += this.progressStep;
                if (this.progress != null && this.progressCurrent < this.progressTo) {
                    this.progress.progress((int)this.progressCurrent);
                }
            }
            if (content instanceof PdfContentTitlepage) {
                this.createTitlepage((PdfContentTitlepage)content);
            } else if (content instanceof PdfContentPicture) {
                double w = ((PdfContentPicture)content).getWidth();
                this.createProjectImage(w);
                this.addToDocument((Element)this.createParagraph(" ", this.formatText));
            } else if (content instanceof PdfContentPagebreak) {
                this.document.newPage();
            } else if (content instanceof PdfContentHeading1) {
                String txt = this.ph.apply(((PdfContentHeading1)content).getText(), null, null, null, null);
                this.document.add((Element)this.createParagraph(txt, this.formatHeading1));
            } else if (content instanceof PdfContentHeading2) {
                String txt = this.ph.apply(((PdfContentHeading2)content).getText(), null, null, null, null);
                this.document.add((Element)this.createParagraph(txt, this.formatHeading2));
            } else if (content instanceof PdfContentParagraph) {
                String txt = this.ph.apply(((PdfContentParagraph)content).getText(), null, null, null, null);
                for (String t : txt.split("\n", -1)) {
                    this.document.add((Element)this.createParagraph(t, t.startsWith("-") ? this.formatBullet : this.formatText));
                }
                if (txt.endsWith("\n")) {
                    this.document.add((Element)this.createParagraph("", this.formatText));
                }
            } else if (content instanceof PdfContentTable) {
                CmsReport.ListPagebreak pagebreak = ((PdfContentTable)content).getPagebreak();
                this.createTable(((PdfContentTable)content).getLayoutName(), pagebreak);
            } else if (content instanceof PdfContentHeaderEvent) {
                this.createEventInfoTable();
                this.addToDocument((Element)this.createParagraph(" ", this.formatText));
            } else if (content instanceof PdfContentHeaderProject) {
                this.createProjectInfoTable();
                this.addToDocument((Element)this.createParagraph(" ", this.formatText));
            } else if (content instanceof PdfContentHeaderReport) {
                this.createReportEventInfoTable();
                this.addToDocument((Element)this.createParagraph(" ", this.formatText));
            } else if (content instanceof PdfContentSignature) {
                this.createSignature();
            } else if (content instanceof PdfContentTitle) {
                this.createTitle();
            } else if (content instanceof PdfContentAnnualOverview) {
                this.createAnnualControlTable("b.langtext1", this.rep.getPeriodYear());
            } else if (content instanceof PdfContentEventList) {
                ArrayList eventIds = null;
                switch (this.rep.contentType) {
                    case PERIOD: {
                        eventIds = this.project.getEventSearchResult(this.rep.getPeriodFromDate(), this.rep.getPeriodUntilDate()).getResultIds();
                        break;
                    }
                    case EVENT: {
                        eventIds = new ArrayList();
                        eventIds.add(this.rep.event.getId());
                        break;
                    }
                    case FILTER: 
                    case SELECTION: {
                        eventIds = this.project.getEventSearchResult().getResultIds();
                    }
                }
                this.createEventListTable(eventIds);
            } else if (content instanceof PdfContentStandardTable) {
                this.createStandardTable();
            } else if (content instanceof PdfContentStandardTableOpen) {
                this.createStandardTableOpen();
            } else if (content instanceof PdfContentDocumentList) {
                this.createDocumentList();
            } else if (content instanceof PdfContentContactList) {
                this.createContactList();
            } else if (content instanceof PdfContentForm) {
                String alias = ((PdfContentForm)content).getFormAlias();
                CmsFormular f = this.project.getFormByAlias(alias);
                if (f != null) {
                    this.createForm(f);
                } else {
                    this.document.add((Element)this.createParagraph("Kein Formular gefunden", this.formatText));
                }
            }
            if (!this.progress.isCancelled()) continue;
            return;
        }
    }

    public ArrayList<Long> getFilteredObservationIds(CmsReport.ListFilter filterType, ArrayList<Long> excludeIds) {
        if (excludeIds == null) {
            excludeIds = new ArrayList();
        }
        ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance(), false);
        filter.setTriggerEnabled(false);
        block0 : switch (filterType) {
            case DUEDATE: {
                filter.setDuedateFilter();
                break;
            }
            case MANGEL: {
                filter.setMangelFilter();
                break;
            }
            case TODO: {
                filter.setTodoFilter();
                break;
            }
            default: {
                switch (this.rep.contentType) {
                    case FILTER: {
                        filter.setFilter(this.app.getFilter());
                        break block0;
                    }
                    case EVENT: {
                        if (this.rep.event == null) break block0;
                        filter.getEventId().setItem(this.rep.event.getId(), this);
                        break block0;
                    }
                    case SELECTION: {
                        filter.setObservationIds(this.project.getSelectionManager().getSelectedObservationIds(), this);
                    }
                }
            }
        }
        String sort = this.rep.getSortSql();
        List<DataRecord> recs = filter.getFilteredObservations(sort, null);
        ArrayList<Long> observationIds = new ArrayList<Long>();
        for (DataRecord rec : recs) {
            long id = rec.getLong("observationid");
            if (id <= 0L || observationIds.contains(id) || excludeIds.contains(id)) continue;
            observationIds.add(id);
        }
        return observationIds;
    }

    protected void createTitlepage(PdfContentTitlepage content) {
        this.createTitlePage();
    }
}

