/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report.pdf;

import at.grid.cms.element.CmsUser;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.compat.MapCompat;
import at.grid.themis.ontology.report.pdf.PdfExportBase;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PdfStatisticsExporter
extends PdfExportBase {
    private HashMap<String, Object> statistics = new HashMap();
    private ArrayList<String> years = new ArrayList();
    private int countProjects;
    private List<ThemisFolder> projects;

    @Override
    public void createContent(CmsUser user) throws DocumentException {
        int row = 1;
        if (this.countProjects == 1) {
            this.addHeading(this.project.getResourceText("statistics.about.single") + ": " + this.projects.get(0).getProjectTitle(), row++, 2);
            this.addHeading(this.project.getResourceText("statistics.headerAbout"), row++, 2);
            this.addProjectProperty("access.first", row++);
            this.addProjectProperty("access.creator", row++);
            this.addProjectProperty("access.last", row++);
            this.addProjectProperty("access.last-user", row++);
            this.addProjectProperty("last.event", row++);
        } else {
            this.addHeading(this.project.getResourceText("statistics.headerProjects"), row++, 2);
            for (int i = 0; i < this.projects.size(); ++i) {
                this.addProjectTitle(this.projects.get(i));
            }
        }
        this.addHeading(this.project.getResourceText("statistics.headerQuantity"), row++, 2);
        this.addProjectProperty("count.events", row++);
        this.addProjectProperty("count.buildings", row++);
        this.addProjectProperty("count.plans", row++);
        this.addProjectProperty("count.locations", row++);
        this.addProjectProperty("count.opentasks", row++);
        for (String year : this.years) {
            this.document.newPage();
            this.addHeading(this.project.getResourceText("statistics.headerYear") + " - " + year, row++, 1);
            this.addHeading(this.project.getResourceText("statistics.headerOverview"), row++, 2);
            this.addProjectProperty("yearcount.events." + year, row++);
            this.addProjectProperty("yearcount.checks." + year, row++);
            this.addHeading(this.project.getResourceText("statistics.headerNewObs"), row++, 2);
            this.addProjectProperty("yearcount.newobservations." + year, row++);
            this.addProjectProperty("yearcount.newobservations.type1." + year, row++);
            this.addProjectProperty("yearcount.newobservations.type2." + year, row++);
            this.addProjectProperty("yearcount.newobservations.type3." + year, row++);
            this.addProjectProperty("yearcount.newobservations.type4." + year, row++);
            this.addHeading(this.project.getResourceText("statistics.headerTotalObs"), row++, 2);
            this.addProjectProperty("yearcount.observations." + year, row++);
            this.addProjectProperty("yearcount.observations.type1." + year, row++);
            this.addProjectProperty("yearcount.observations.type2." + year, row++);
            this.addProjectProperty("yearcount.observations.type3." + year, row++);
            this.addProjectProperty("yearcount.observations.type4." + year, row++);
        }
    }

    private void addProjectTitle(ThemisFolder f) {
        String title;
        if (f != null && (title = f.getProjectTitle()) != null && !title.isEmpty()) {
            this.addToDocument((Element)this.createParagraph(title, this.formatText));
        }
    }

    private void addHeading(String text, int row, int level) {
        this.addToDocument((Element)this.createParagraph(text, level == 1 ? this.formatHeading1 : this.formatHeading2));
    }

    private void addProjectProperty(String key, int row) {
        String labelkey = key;
        if (key.startsWith("yearcount.")) {
            labelkey = key.substring(4, key.length() - 5);
        }
        String lbl = this.project.getResourceText("projectstat." + labelkey);
        String val = MapCompat.getOrDefault(this.statistics, key, "-").toString();
        this.addToDocument((Element)this.createParagraph(lbl + "\t" + val, this.formatText));
    }

    public void setStatistics(HashMap<String, Object> statistics, List<ThemisFolder> projects) {
        this.statistics = statistics;
        this.projects = projects;
        if (this.projects == null) {
            this.projects = new ArrayList<ThemisFolder>();
        }
        this.countProjects = this.projects.size();
        this.projectElement = null;
        this.rep.protTitel = MessageFormat.format(this.countProjects == 1 ? this.project.getResourceText("statistics.about.single") + ": " + projects.get(0).getProjectTitle() : this.project.getResourceText("statistics.about.plural"), this.countProjects);
    }

    public void setYears(ArrayList<String> years) {
        this.years = years;
    }
}

