/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report.pdf;

import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.ReportGenerator;
import at.grid.themis.ontology.report.pdf.PdfExportBase;
import at.grid.themis.ontology.report.pdf.ReportDataRecord;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;

public class PdfSummaryExporter
extends PdfExportBase {
    ArrayList<ReportDataRecord> recordsMainTable = new ArrayList();
    ArrayList<ReportDataRecord> recordsOpenTaskTable = new ArrayList();

    public PdfSummaryExporter(CmsReport rep) {
        super(rep);
    }

    @Override
    public String getHeaderText() {
        return "Zusammenfassender Bericht";
    }

    public ArrayList<Long> addObservationsFromFilter() {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (this.project != null && this.project.isOpen()) {
            ThemisFilter filter = ThemisApplication.getInstance().getFilter();
            ThemisSettings settings = ThemisApplication.getInstance().getSettings();
            List<DataRecord> recs = filter.getFilteredObservations(this.rep.getSortSql(), null);
            ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
            ignoreAtts.add(this.app.getSettings().getObservationAttribute("donedate"));
            ignoreAtts.add(this.app.getSettings().getObservationAttribute("type"));
            int count = 0;
            for (DataRecord rec : recs) {
                ids.add(rec.getLong("observationid"));
                CmsObservation obs = (CmsObservation)this.project.loadElement(rec.getLong("observationid"), this.project.getUser());
                if (obs != null) {
                    this.recordsMainTable.add(new ReportDataRecord(this.project, obs, null, this.rep.exportWithHistories, this.rep.exportImages == CmsReport.ImageIntegration.ALL, settings.getImageForLocation(), settings.getImageForObservation(), ignoreAtts));
                } else {
                    CmsLocation loc = (CmsLocation)this.project.loadElement(rec.getLong("meta_id"), this.project.getUser());
                    if (loc != null) {
                        this.recordsMainTable.add(new ReportDataRecord(this.project, loc, null, settings.getImageForObservation()));
                    }
                }
                ++count;
            }
        }
        return ids;
    }

    public void addSingleObservation(long id) {
        if (this.project != null && this.project.isOpen()) {
            CmsObservation cmsObservation = (CmsObservation)this.project.loadElement(id, this.project.getUser());
        }
    }

    public void addOpenTasks(ArrayList<Long> excludeIds) {
        if (this.project != null && this.project.isOpen()) {
            ThemisFilter filter = ThemisApplication.getInstance().getFilter();
            ThemisSettings settings = ThemisApplication.getInstance().getSettings();
            filter.setTriggerEnabled(false);
            filter.setMangelFilter();
            List<DataRecord> recs = filter.getFilteredObservations(null, null);
            ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
            ignoreAtts.add(this.app.getSettings().getObservationAttribute("donedate"));
            ignoreAtts.add(this.app.getSettings().getObservationAttribute("type"));
            ArrayList observationIds = new ArrayList();
            for (DataRecord rec : recs) {
                CmsObservation obs;
                long id = rec.getLong("observationid");
                if (id <= 0L || observationIds.contains(id) || excludeIds.contains(id) || (obs = (CmsObservation)this.project.loadElement(rec.getLong("observationid"), this.project.getUser())) == null) continue;
                this.recordsOpenTaskTable.add(new ReportDataRecord(this.project, obs, null, this.rep.exportWithHistories, this.rep.exportImages == CmsReport.ImageIntegration.ALL, settings.getImageForLocation(), settings.getImageForObservation(), ignoreAtts));
            }
        }
    }

    @Override
    public void createContent(CmsUser u) throws DocumentException {
        try {
            this.createTitle();
            this.createReportInfoTable();
            this.document.add((Element)this.createParagraph(" ", this.formatText));
            this.createObservationTable(this.recordsMainTable);
            this.document.add((Element)this.createParagraph(" ", this.formatText));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createObservationTable(ArrayList<ReportDataRecord> records) throws DocumentException, IOException {
        int totalWidthObs = 128;
        int[] widths = new int[]{8, 55, 27, 25, 15};
        PdfPTable table = new PdfPTable(widths.length);
        table.setWidthPercentage(100.0f);
        table.setWidths(widths);
        table.setHeaderRows(1);
        table.setHorizontalAlignment(0);
        int[] colCm = new int[widths.length];
        float pageWidth = this.getPageWidth();
        for (int i = 0; i < widths.length; ++i) {
            colCm[i] = (int)(pageWidth / (float)totalWidthObs * (float)widths[i]);
        }
        table.addCell(this.createPdfCell("Pos", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        table.addCell(this.createPdfCell("Gegenstand/Plan, Beobachtung, Ma\u00dfnahme", this.formatTableHeader, 1.0f, 0, 2, Color.lightGray, 5.0f));
        table.addCell(this.createPdfCell("Datum", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        table.addCell(this.createPdfCell("Foto", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        table.addCell(this.createPdfCell("Status", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        table.completeRow();
        String statusText = "";
        for (ReportDataRecord record : records) {
            boolean hasPlan = record.hasPlan();
            boolean hasBuilding = record.hasBuilding();
            Properties loc = record.getLocation();
            Properties obs = record.getObservation();
            Properties plan = record.getPlan();
            String observationtypeStr = obs.getProperty("idtype");
            int observationtype = observationtypeStr == null ? -1 : Integer.parseInt(observationtypeStr);
            for (ReportDataRecord.ReportDataRecordHistory hist : record.getHistories()) {
                String dateAsString = Util.formatDate((Date)hist.getDate(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
                this.ph.clearCurrentUploadItems();
                for (ReportDataRecord.ReportDataRecordImage img : record.getImages()) {
                    this.ph.addToCurrentUploadItems(img.item);
                }
                table.addCell(this.createPdfCell(loc.getProperty("fullnumber") + "." + obs.getProperty("number"), true, this.formatTable, 1, 2));
                table.addCell(this.createPdfCell("Projekt: " + record.getProject() + "\n" + loc.getProperty("title") + (hasPlan ? " / " + (hasBuilding ? "[" + plan.getProperty("buildingtitle", "-") + "] " : "") + plan.getProperty("title", "") : "") + "\n" + obs.getProperty("fullstring"), true, this.formatTable, 0, 2));
                String dateText = "erstellt: " + obs.getProperty("creationdate") + "\nkontrolliert: " + hist.getProperties().getProperty("eventdate", "");
                if (!"".equals(hist.getProperties().getProperty("duedate", ""))) {
                    dateText = dateText + "\n" + ("2".equals(observationtype) ? "n\u00e4chste Kontrolle: " : "f\u00e4llig: ") + hist.getProperties().getProperty("duedate", "");
                }
                table.addCell(this.createPdfCell(dateText, true, this.formatTable, 2, 2));
                ArrayList<ReportDataRecord.ReportDataRecordImage> images = hist.getImages();
                images.addAll(record.getImages());
                if (images.isEmpty()) {
                    table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                } else {
                    this.createImageCell(null, images.get((int)0).drawings, images.get((int)0).f, colCm[3], dateAsString);
                    table.addCell(this.tableCell);
                }
                String obstype = "";
                switch (observationtype) {
                    case 2: {
                        obstype = this.rep.textObservationtypeKontrolle;
                        break;
                    }
                    case 1: {
                        obstype = this.rep.textObservationtypeMangel;
                        break;
                    }
                    case 3: {
                        obstype = this.rep.textObservationtypeInfo;
                        break;
                    }
                    case 4: {
                        obstype = this.rep.textObservationtypeAufgabe;
                    }
                }
                statusText = observationtype == 1 || observationtype == 4 ? obstype + ("".equals(obstype) ? "" : "\n") + ("x".equalsIgnoreCase(obs.getProperty("done")) ? this.rep.textStatusDone : this.rep.textStatusOpen) : "";
                table.addCell(this.createPdfCell(statusText, true, this.formatTable, 1, 2));
                table.completeRow();
                if (images.size() <= 1) continue;
                PdfPCell cell = new PdfPCell();
                Paragraph p = new Paragraph();
                for (int ii = 1; ii < images.size(); ++ii) {
                    float imageWidth;
                    if ((ii - 1) % 4 == 0) {
                        if (ii != 1) {
                            cell.addElement((Element)p);
                            table.addCell(cell);
                        }
                        cell = this.createPdfCell("", true, this.formatTable, 2, 2);
                        cell.setColspan(5);
                        p = new Paragraph();
                    }
                    int imageWidthPixel = (imageWidth = (float)colCm[3]) >= 50.0f ? (int)imageWidth : (int)ReportGenerator.cmToPixel(imageWidth);
                    Image image = this.createImage(images.get((int)ii).drawings, images.get((int)ii).f, imageWidthPixel, dateAsString);
                    p.setSpacingAfter(this.imageSpacing);
                    p.setSpacingBefore(this.imageSpacing);
                    if (image != null) {
                        p.add((Object)new Chunk(image, 0.0f, 0.0f, true));
                        p.add((Object)" ");
                        continue;
                    }
                    p.add((Object)(images.get((int)ii).f.getName() + " "));
                }
                cell.addElement((Element)p);
                table.addCell(cell);
            }
        }
        this.document.add((Element)table);
    }
}

