/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report.pdf;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class ReportDataRecord {
    Properties locationProps = new Properties();
    Properties observationProps = new Properties();
    Properties eventProps = new Properties();
    ArrayList<ReportDataRecordHistory> histories = new ArrayList();
    Properties planProps = new Properties();
    ArrayList<ReportDataRecordImage> images = new ArrayList();
    boolean event = false;
    boolean building = false;
    String project;
    File projectFolder;

    public ReportDataRecord(ThemisProject project, CmsObservation obs, CmsEvent event, boolean includeHistores, boolean includeAllImages, boolean imagesWithLocation, boolean imagesWithObservation, ArrayList<ThemisAttribute> ignoreAtts) {
        for (Object att : obs.getAttributes()) {
            this.observationProps.setProperty(att.getCode(), att.getValue());
        }
        this.observationProps.setProperty("idtype", Long.toString(obs.getKeyAttribute("type").getId()));
        this.observationProps.setProperty("fullstring", obs.toStringWithIgnore("", "\n", false, ignoreAtts));
        CmsLocation loc = obs.getLocation();
        for (CmsAttribute att : loc.getAttributes()) {
            this.locationProps.setProperty(att.getCode(), att.getValue());
        }
        boolean usePrefix = ThemisApplication.getInstance().getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = ThemisApplication.getInstance().getSettings().getLocationAttribute("suffix").isUsed();
        this.locationProps.setProperty("fullnumber", (usePrefix ? loc.getAttributeValue("prenumber") : "") + loc.getAttributeValue("number") + (useSuffix ? loc.getAttributeValue("postnumber") : ""));
        CmsPlan plan = loc.getPlan();
        if (plan != null) {
            for (CmsAttribute att : plan.getAttributes()) {
                this.planProps.setProperty(att.getCode(), att.getValue());
            }
            this.planProps.setProperty("buildingtitle", plan.getRelationAttribute("building").getFirstElementTitle());
            boolean bl = this.building = !plan.getRelationAttribute("building").isEmpty();
        }
        if (event != null) {
            for (CmsAttribute att : event.getAttributes()) {
                this.eventProps.setProperty(att.getCode(), att.getValue());
            }
        }
        if (includeHistores) {
            for (CmsElement hist : obs.getHistories()) {
                this.histories.add(new ReportDataRecordHistory(project, hist, imagesWithObservation));
            }
        } else {
            CmsHistory hist = event == null ? obs.getLatestHistory() : obs.getHistory(event);
            this.histories.add(new ReportDataRecordHistory(project, hist, imagesWithObservation && !includeAllImages));
            if (includeAllImages && imagesWithObservation) {
                for (UploadItem item : obs.getUploads(true)) {
                    if (item.getUploadDetail() == 2L) continue;
                    this.addImage(item, project.getDrawings(item.getId()));
                }
            }
        }
        this.event = event != null;
        this.project = project.getProjectElement().getTitle();
        this.projectFolder = new File(project.getProjectFolder().getAbsolutePath());
    }

    public ReportDataRecord(ThemisProject project, CmsLocation loc, CmsEvent event, boolean withImages) {
        for (CmsAttribute att : loc.getAttributes()) {
            this.locationProps.setProperty(att.getCode(), att.getValue());
        }
        boolean usePrefix = ThemisApplication.getInstance().getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = ThemisApplication.getInstance().getSettings().getLocationAttribute("suffix").isUsed();
        this.locationProps.setProperty("fullnumber", (usePrefix ? loc.getAttributeValue("prenumber") : "") + loc.getAttributeValue("number") + (useSuffix ? loc.getAttributeValue("postnumber") : ""));
        CmsPlan plan = loc.getPlan();
        if (plan != null) {
            for (CmsAttribute att : plan.getAttributes()) {
                this.planProps.setProperty(att.getCode(), att.getValue());
            }
            boolean bl = this.building = !plan.getRelationAttribute("building").isEmpty();
        }
        if (event != null) {
            for (CmsAttribute att : event.getAttributes()) {
                this.eventProps.setProperty(att.getCode(), att.getValue());
            }
        }
        boolean bl = this.event = event != null;
        if (withImages) {
            for (UploadItem item : loc.getImageUploadItems()) {
                if (item.getUploadDetail() == 2L) continue;
                this.addImage(item, project.getDrawings(item.getId()));
            }
        }
        this.project = project.getProjectElement().getTitle();
        this.projectFolder = new File(project.getProjectFolder().getAbsolutePath());
    }

    public ArrayList<ReportDataRecordHistory> getHistories() {
        return this.histories;
    }

    public Properties getObservation() {
        return this.observationProps;
    }

    public Properties getLocation() {
        return this.locationProps;
    }

    public boolean hasPlan() {
        return !this.planProps.isEmpty();
    }

    public boolean hasBuilding() {
        return this.building;
    }

    public Properties getPlan() {
        return this.planProps;
    }

    public boolean hasEvent() {
        return this.event;
    }

    public Properties getEvent() {
        return this.eventProps;
    }

    public String getProject() {
        return this.project;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public void addImage(UploadItem item, ArrayList<SimpleGeometry> drawings) {
        this.images.add(new ReportDataRecordImage(item, drawings));
    }

    public ArrayList<ReportDataRecordImage> getImages() {
        return this.images;
    }

    class ReportDataRecordImage {
        UploadItem item;
        File f;
        ArrayList<SimpleGeometry> drawings;

        public ReportDataRecordImage(UploadItem item, ArrayList<SimpleGeometry> drawings) {
            this.item = item;
            this.f = item.getFile();
            this.drawings = drawings;
        }
    }

    class ReportDataRecordHistory {
        Properties historyProps = new Properties();
        ArrayList<ReportDataRecordImage> images = new ArrayList();
        Date date;

        public ReportDataRecordHistory(ThemisProject project, CmsElement hist, boolean includeImages) {
            this.date = hist.getDateAttribute("eventdate").getDate();
            for (CmsAttribute att : hist.getAttributes()) {
                this.historyProps.setProperty(att.getCode(), att.getValue());
            }
            if (includeImages) {
                for (UploadItem item : ((CmsHistory)hist).getImageUploadItems()) {
                    if (item.getUploadDetail() == 2L) continue;
                    this.addImage(item, project.getDrawings(item.getId()));
                }
            }
        }

        public Date getDate() {
            return this.date;
        }

        public Properties getProperties() {
            return this.historyProps;
        }

        public final void addImage(UploadItem item, ArrayList<SimpleGeometry> drawings) {
            this.images.add(new ReportDataRecordImage(item, drawings));
        }

        public ArrayList<ReportDataRecordImage> getImages() {
            return this.images;
        }
    }
}

