/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.server;

import at.grid.cms.content.UploadItem;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import at.grid.util.XML;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.openide.util.Exceptions;

public class ThemisCloudProjectInfo {
    public static int VERISON = 1;
    private final String uuid;
    private String title;
    private BufferedImage projectImage;
    private Properties projectInfos;
    private String md5Template;
    private Date dateTemplate;
    private String md5Plan;
    private Date datePlan;
    private String md5Content;
    private Date dateContent;
    private ThemisCloudServer.Permission permission;
    private final ArrayList<ProjectUser> users;
    private final ArrayList<ServerAccess> access;
    private boolean projectTitleDiffers = false;

    public ThemisCloudProjectInfo(String uuid, String title, BufferedImage projectImage, Properties projectInfos, String md5Template, Date dateTemplate, String md5Plan, Date datePlan, String md5Content, Date dateContent, ThemisCloudServer.Permission permission, ArrayList<ProjectUser> users, ArrayList<ServerAccess> access) {
        this.uuid = uuid;
        this.title = title;
        this.projectImage = projectImage;
        this.projectInfos = projectInfos;
        this.md5Template = md5Template;
        this.dateTemplate = dateTemplate;
        this.md5Plan = md5Plan;
        this.datePlan = datePlan;
        this.md5Content = md5Content;
        this.dateContent = dateContent;
        this.permission = permission;
        this.users = users;
        this.access = access;
    }

    public ThemisCloudProjectInfo(String uuid, String title, BufferedImage projectImage, Properties projectInfos) {
        this(uuid, title, projectImage, projectInfos, null, null, null, null, null, null, ThemisCloudServer.Permission.OPEN, new ArrayList<ProjectUser>(), new ArrayList<ServerAccess>());
    }

    public static ThemisCloudProjectInfo createFromXml(String xml) throws IOException, JDOMException {
        ThemisCloudServer.Permission permission;
        Element info = Util.fromXml((String)xml);
        int version = Integer.parseInt(info.getAttribute("version").getValue());
        if (VERISON != version) {
            throw new IllegalArgumentException("invalid version (" + version + ")");
        }
        String uuid = XML.getXPathElementText((Element)info, (String)"/info/project/uuid", null);
        String title = XML.getXPathElementText((Element)info, (String)"/info/project/title", null);
        Properties projectInfos = new Properties();
        projectInfos.setProperty("projectlocation", XML.getXPathElementText((Element)info, (String)"/info/project/projectlocation", (String)""));
        projectInfos.setProperty("customer", XML.getXPathElementText((Element)info, (String)"/info/project/customer", (String)""));
        projectInfos.setProperty("projectnumber", XML.getXPathElementText((Element)info, (String)"/info/project/projectnumber", (String)""));
        projectInfos.setProperty("info", XML.getXPathElementText((Element)info, (String)"/info/project/info", (String)""));
        BufferedImage projectImage = null;
        String imageBase64 = XML.getXPathElementText((Element)info, (String)"/info/project/image", null);
        if (imageBase64 != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(imageBase64));
            projectImage = ImageIO.read(is);
        }
        String md5Plan = XML.getXPathElementText((Element)info, (String)"/info/md5/plans", null);
        String md5Template = XML.getXPathElementText((Element)info, (String)"/info/md5/templates", null);
        String md5Content = XML.getXPathElementText((Element)info, (String)"/info/md5/content", null);
        Date datePlan = Util.parseDate((String)XML.getXPathAttributeValue((Element)info, (String)"/info/md5/plans/@date"), (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
        Date dateTemplate = Util.parseDate((String)XML.getXPathAttributeValue((Element)info, (String)"/info/md5/templates/@date"), (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
        Date dateContent = Util.parseDate((String)XML.getXPathAttributeValue((Element)info, (String)"/info/md5/content/@date"), (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
        switch (XML.getXPathElementText((Element)info, (String)"/info/permission", (String)"open")) {
            case "user": {
                permission = ThemisCloudServer.Permission.OPEN;
                break;
            }
            default: {
                permission = ThemisCloudServer.Permission.OPEN;
            }
        }
        ArrayList<ProjectUser> usrs = new ArrayList<ProjectUser>();
        for (Element user : XML.getXPathElements((Element)info, (String)"/info/users")) {
            String username = user.getAttributeValue("username");
            String password = user.getAttributeValue("password");
            String role = user.getAttributeValue("role");
            usrs.add(new ProjectUser(username, password, role));
        }
        ArrayList<ServerAccess> acc = new ArrayList<ServerAccess>();
        for (Element a : XML.getXPathElements((Element)info, (String)"/info/accesscodes/accesscode")) {
            String code = a.getText();
            String validuntil = a.getAttributeValue("validuntil");
            acc.add(new ServerAccess(code, validuntil));
        }
        return new ThemisCloudProjectInfo(uuid, title, projectImage, projectInfos, md5Template, dateTemplate, md5Plan, datePlan, md5Content, dateContent, permission, usrs, acc);
    }

    public static ThemisCloudProjectInfo createFromProject(ThemisProject project) throws IllegalArgumentException {
        if (!project.isOpen()) {
            throw new IllegalArgumentException("Project not open");
        }
        String title = project.getProjectElement().getTitle();
        String uuid = project.getProjectElement().getUUIDasString();
        Properties projectInfos = new Properties();
        projectInfos.setProperty("projectlocation", project.getProjectElement().getAttributeValue("projectlocation"));
        projectInfos.setProperty("customer", project.getProjectElement().getAttributeValue("customer"));
        projectInfos.setProperty("projectnumber", project.getProjectElement().getAttributeValue("projectnumber"));
        projectInfos.setProperty("info", project.getProjectElement().getAttributeValue("info"));
        BufferedImage projectImage = null;
        UploadItem item = ThemisApplication.getInstance().getProject().getProjectElement().getUploadAttribute("projectimage").getFirstUploadItem();
        if (item != null) {
            try {
                projectImage = Util.resizeImage((BufferedImage)ImageHelper.loadImage((File)item.getFile()), (int)200);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ThemisCloudProjectInfo(uuid, title, projectImage, projectInfos);
    }

    public String toXml() {
        Element info = new Element("info");
        info.setAttribute("version", Integer.toString(VERISON));
        Element md5 = new Element("md5");
        md5.addContent((Content)new Element("templates").setText(this.md5Template).setAttribute("date", Util.formatDate((Date)this.dateTemplate, (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone())));
        md5.addContent((Content)new Element("plans").setText(this.md5Plan).setAttribute("date", Util.formatDate((Date)this.datePlan, (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone())));
        md5.addContent((Content)new Element("content").setText(this.md5Content).setAttribute("date", Util.formatDate((Date)this.dateContent, (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone())));
        info.addContent((Content)md5);
        Element perm = new Element("permission");
        switch (this.permission) {
            case USER: {
                perm.setText("user");
                break;
            }
            default: {
                perm.setText("open");
            }
        }
        info.addContent((Content)perm);
        Element usrs = new Element("users");
        for (ProjectUser projectUser : this.users) {
            if (projectUser.username == null) continue;
            usrs.addContent((Content)new Element("user").setAttribute("username", projectUser.username).setAttribute("password", projectUser.password).setAttribute("role", projectUser.role));
        }
        info.addContent((Content)usrs);
        Element accesscodes = new Element("accesscodes");
        for (ServerAccess serverAccess : this.access) {
            accesscodes.addContent((Content)new Element("accesscode").setAttribute("validuntil", serverAccess.getValidUntilAsString()).setText(serverAccess.code));
        }
        info.addContent((Content)accesscodes);
        Element element = new Element("project");
        element.addContent((Content)new Element("uuid").setText(this.uuid));
        element.addContent((Content)new Element("title").setText(this.title));
        if (this.projectInfos != null) {
            for (String prop : this.projectInfos.stringPropertyNames()) {
                element.addContent((Content)new Element(prop).setText(this.projectInfos.getProperty(prop)));
            }
        }
        if (this.projectImage != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.projectImage, "jpg", byteArrayOutputStream);
                String base64 = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
                element.addContent((Content)new Element("image").setText(base64));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        info.addContent((Content)element);
        String string = Util.toXml((Element)info);
        return string;
    }

    public ArrayList<String> getValidAccessCodes() {
        Date now = new Date();
        ArrayList<String> codes = new ArrayList<String>();
        for (ServerAccess a : this.access) {
            if ("".equals(a.getCode()) || a.validUntil != null && !a.validUntil.after(now)) continue;
            codes.add(a.getCode());
        }
        return codes;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getTitle() {
        return this.title;
    }

    public BufferedImage getProjectImage() {
        return this.projectImage;
    }

    public Properties getProjectInfos() {
        return this.projectInfos;
    }

    public String getMd5Template() {
        return this.md5Template;
    }

    public Date getDateTemplate() {
        return this.dateTemplate;
    }

    public String getMd5Plan() {
        return this.md5Plan;
    }

    public Date getDatePlan() {
        return this.datePlan;
    }

    public String getMd5Content() {
        return this.md5Content;
    }

    public Date getDateContent() {
        return this.dateContent;
    }

    public ThemisCloudServer.Permission getPermission() {
        return this.permission;
    }

    public ArrayList<ProjectUser> getUsers() {
        return this.users;
    }

    public ArrayList<ServerAccess> getAccessCodes() {
        return this.access;
    }

    public void updateMD5(String plan, String template, String content) {
        if (this.md5Plan == null || !this.md5Plan.equals(plan)) {
            this.md5Plan = plan;
            this.datePlan = new Date();
        }
        if (this.md5Template == null || !this.md5Template.equals(template)) {
            this.md5Template = template;
            this.dateTemplate = new Date();
        }
        if (this.md5Content == null || !this.md5Content.equals(content)) {
            this.md5Content = content;
            this.dateContent = new Date();
        }
    }

    public void updateProject(ThemisProject project) throws IOException {
        if (!this.uuid.equals(project.getProjectElement().getUUIDasString())) {
            throw new IOException("missmaching uuids");
        }
        this.title = project.getProjectElement().getTitle();
        this.projectInfos.setProperty("projectlocation", project.getProjectElement().getAttributeValue("projectlocation"));
        this.projectInfos.setProperty("customer", project.getProjectElement().getAttributeValue("customer"));
        this.projectInfos.setProperty("projectnumber", project.getProjectElement().getAttributeValue("projectnumber"));
        this.projectInfos.setProperty("info", project.getProjectElement().getAttributeValue("info"));
        BufferedImage img = null;
        UploadItem item = ThemisApplication.getInstance().getProject().getProjectElement().getUploadAttribute("projectimage").getFirstUploadItem();
        if (item != null) {
            try {
                img = Util.resizeImage((BufferedImage)ImageHelper.loadImage((File)item.getFile()), (int)200);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.projectImage = img;
        ThemisApplication.getLogger().info("server project info updated based on project");
    }

    public boolean isProjectTitleDiffers() {
        return this.projectTitleDiffers;
    }

    public void setProjectTitleDiffers(boolean projectTitleDiffers) {
        this.projectTitleDiffers = projectTitleDiffers;
    }

    public void addAccessCode(ServerAccess access) {
        this.access.add(access);
    }

    public void removeAccessCode(String access) {
        ServerAccess toRemove = null;
        for (ServerAccess a : this.access) {
            if (!a.getCode().equals(access)) continue;
            toRemove = a;
            break;
        }
        if (toRemove != null) {
            this.removeAccessCode(toRemove);
        }
    }

    public void removeAccessCode(ServerAccess access) {
        this.access.remove(access);
    }

    public void setPermission(ThemisCloudServer.Permission perm) {
        this.permission = perm;
    }

    public boolean hasAccessCode(String accessCode) {
        if (accessCode == null || accessCode.trim().isEmpty()) {
            return false;
        }
        return this.getAccessCodes().stream().anyMatch(a -> accessCode.equals(a.getCode()));
    }

    public static class ServerAccess {
        String code;
        Date validUntil;

        public ServerAccess(String code, Date validUntil) {
            this.code = code;
            this.validUntil = validUntil;
        }

        public ServerAccess(String code, String validUntil) {
            this.code = code;
            this.validUntil = validUntil == null ? null : Util.parseDate((String)validUntil, (String)Util.DATE_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null);
        }

        public String getValidUntilAsString() {
            return this.validUntil == null ? "" : Util.formatDate((Date)this.validUntil, (String)Util.DATE_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone());
        }

        public String getCode() {
            return this.code == null ? "" : this.code.trim();
        }

        public Date getValidUntil() {
            return this.validUntil;
        }

        public boolean isValid() {
            LocalDate today = LocalDate.now(ZoneId.systemDefault());
            LocalDate valid = this.validUntil != null ? this.validUntil.toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null;
            return !"".equals(this.getCode()) && (valid == null || valid.isEqual(today) || valid.isAfter(today));
        }
    }

    public static class ProjectUser {
        String username;
        String password;
        String role;

        public ProjectUser(String username, String password, String role) {
            this.username = username;
            this.password = password;
            this.role = role;
        }
    }
}

