/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.server;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisJob;
import at.grid.util.CryptoUtilites;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import at.grid.webdav.NextCloudWebDAV;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.JDOMException;
import org.json.JSONObject;

public class ThemisCloudServer {
    public static final String FOLDER_OPEN_JOBS = "jobs-open";
    public static final String FOLDER_WORKING_JOBS = "jobs-working";
    public static final String FOLDER_DONE_JOBS = "jobs-done";
    public static final String FOLDER_IMPORTED_JOBS = "jobs-imported";
    public static final String FOLDER_DELETED_JOBS = "jobs-deleted";
    public static final String FOLDER_DIFF = "project-diff";
    public static final String FOLDER_DATA = "data";
    private final NextCloudWebDAV webdav;
    private ThemisCloudProjectInfo info;
    private String servercode;

    public ThemisCloudServer(String shareUrl, String pwd) {
        this.webdav = NextCloudWebDAV.fromShareUrl((String)shareUrl, (String)pwd);
    }

    public ThemisCloudServer(String url, String user, String pwd) {
        this.webdav = new NextCloudWebDAV(url, user, pwd);
    }

    public static boolean checkServerCode(String code) {
        try {
            ThemisCloudServer s = ThemisCloudServer.fromCode(code);
            return s != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ThemisCloudServer fromCode(String code) {
        try {
            String user;
            if (code == null || "".equals(code)) {
                ThemisApplication.getInstance().getDialog().showErrorDialog("task.server.progress.setup-error");
                return null;
            }
            String server = CryptoUtilites.decryptAes((String)code);
            JSONObject o = new JSONObject(server);
            Type type = Type.NEXTCLOUD;
            if ("apache".equalsIgnoreCase(o.has("type") ? o.getString("type") : null)) {
                type = Type.APACHE;
            }
            String url = o.has("url") ? o.getString("url") : null;
            String pwd = o.has("pwd") ? o.getString("pwd") : null;
            String string = user = o.has("user") ? o.getString("user") : null;
            if (url == null || "".equals(url)) {
                throw new IllegalArgumentException("Invalid code");
            }
            switch (type) {
                case APACHE: {
                    ThemisApplication.getLogger().info("created server of type APACHE/IIS");
                    ThemisCloudServer s = new ThemisCloudServer(url, user, pwd);
                    s.servercode = code;
                    return s;
                }
            }
            ThemisApplication.getLogger().info("created server of type NEXTCLOUD");
            ThemisCloudServer s = new ThemisCloudServer(url, pwd);
            s.servercode = code;
            return s;
        }
        catch (Exception ex) {
            ThemisApplication.getLogger().severe("Invalid server code: " + code);
            ThemisApplication.getInstance().getSettings().setThemisServerCode("");
            ThemisApplication.getInstance().getDialog().showErrorDialog("task.server.progress.setup-error", ex);
            return null;
        }
    }

    public String getServerCode() {
        return this.servercode;
    }

    public ThemisCloudProjectInfo uploadProjectInfo(ThemisProject project, boolean checkProjectTitle) throws IOException, JDOMException {
        ThemisCloudProjectInfo i;
        if (!this.isServerAvailable()) {
            ThemisApplication.getLogger().severe("Server not availalbe, no connection");
        }
        String rootFolder = "projects";
        String projectUuid = project.getProjectElement().getUUIDasString();
        ThemisApplication.getLogger().info("uploading project info with project UUID " + projectUuid);
        String projectFolder = rootFolder + "/" + projectUuid;
        if (this.webdav.hasFile(projectFolder, "config.xml")) {
            i = this.readProjectInfo(projectUuid);
            String serverProjectTitle = i.getTitle();
            String localProjectTitle = project.getProjectElement().getTitle();
            if (checkProjectTitle && !localProjectTitle.equals(serverProjectTitle)) {
                i.setProjectTitleDiffers(true);
                return i;
            }
            i.updateProject(project);
        } else {
            i = ThemisCloudProjectInfo.createFromProject(project);
        }
        this.webdav.createFolder(new String[]{rootFolder, projectFolder, projectFolder + "/" + FOLDER_OPEN_JOBS, projectFolder + "/" + FOLDER_WORKING_JOBS, projectFolder + "/" + FOLDER_DONE_JOBS, projectFolder + "/" + FOLDER_IMPORTED_JOBS, projectFolder + "/" + FOLDER_DELETED_JOBS, projectFolder + "/" + FOLDER_DIFF, projectFolder + "/" + FOLDER_DATA});
        ThemisApplication.getLogger().info("project folders created");
        this.updateProjectInfo(i);
        return i;
    }

    public void updateProjectInfo(ThemisCloudProjectInfo info) throws IOException, JDOMException {
        if (!this.isServerAvailable()) {
            throw new IOException("server not available");
        }
        String rootFolder = "projects";
        String projectFolder = rootFolder + "/" + info.getUuid();
        ThemisApplication.getLogger().info("writing project info to server at " + projectFolder);
        this.webdav.putString(info.toXml(), projectFolder, "config.xml");
        this.info = info;
    }

    public void deleteProject(String projectUuid) throws IOException {
        if (!this.isServerAvailable()) {
            throw new IOException("server not available");
        }
        String projectFolder = "projects/" + projectUuid;
        if (this.webdav.hasFolder(projectFolder)) {
            this.webdav.deleteFolder("projects", projectUuid);
        }
    }

    public ThemisCloudProjectInfo readProjectInfo(String projectUuid) throws IOException, JDOMException {
        if (this.info == null) {
            if (!this.isServerAvailable()) {
                throw new IOException("server not available");
            }
            String folder = "projects/" + projectUuid;
            if (!this.webdav.hasFile(folder, "config.xml")) {
                throw new IOException("Project missing on server");
            }
            String config = this.webdav.getString(folder, "config.xml");
            this.info = ThemisCloudProjectInfo.createFromXml(config);
            ThemisApplication.getLogger().info("project info read from server with project UUID " + projectUuid);
        }
        return this.info;
    }

    public void uploadProject(ThemisProject project, ProgressHandler ph) throws IOException, JDOMException {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        if (!this.isServerAvailable()) {
            throw new IOException("server not available");
        }
        project.getLogger().info("reading project UUID ...");
        String projectUuid = project.getProjectElement().getUUIDasString();
        String projectFolder = "projects/" + projectUuid;
        ph.progress("progress.server.update-project-info", 1);
        if (ph.isCancelled()) {
            return;
        }
        project.getLogger().info("uploading project info ...");
        ThemisCloudProjectInfo i = this.uploadProjectInfo(project, false);
        if (ph.isCancelled()) {
            return;
        }
        String md5Plan = i.getMd5Plan();
        String md5Template = i.getMd5Template();
        String md5Content = i.getMd5Content();
        boolean changed = false;
        project.getLogger().info("checking plans ...");
        boolean plansChanged = this.didPlansChange(project, i);
        if (plansChanged) {
            ph.progress("progress.server.upload-plans", 2);
            project.getLogger().info("uploading plans ...");
            ThemisFile plans = this.preparePlans(project);
            plans.saveToServer(this.webdav, "plans.themis", true);
            md5Plan = plans.getMd5();
            changed = true;
        } else {
            project.getLogger().info("plans not changed!");
        }
        if (ph.isCancelled()) {
            return;
        }
        project.getLogger().info("checking templates ...");
        boolean templatesChanged = this.didTemplatesChange(project, i);
        if (templatesChanged) {
            ph.progress("progress.server.upload-templates", 3);
            project.getLogger().info("uploading templates ...");
            ThemisFile templates = this.prepareTemplates();
            templates.saveToServer(this.webdav, "templates.themis", true);
            md5Template = templates.getMd5();
            changed = true;
        } else {
            project.getLogger().info("templates not changed!");
        }
        if (ph.isCancelled()) {
            return;
        }
        ph.progress("progress.server.upload-project", 4);
        project.getLogger().info("preparing project content ...");
        ThemisFile content = this.prepareContentProject();
        content.setProgressHandler(ph);
        if (ph.isCancelled()) {
            return;
        }
        project.getLogger().info("uploading project content ...");
        content.saveToServer(this.webdav, "project.themis", true);
        if (ph.isCancelled()) {
            return;
        }
        if (i.getMd5Content() == null || !i.getMd5Content().equals(content.getMd5())) {
            md5Content = content.getMd5();
            changed = true;
        }
        ph.progress("progress.server.cleanup", 5);
        String diffFolder = projectFolder + "/" + FOLDER_DIFF;
        project.getLogger().info("checking DIFF folder (" + diffFolder + ")");
        if (this.webdav.hasFolder(diffFolder)) {
            project.getLogger().info("deleting DIFF folder (" + diffFolder + ")");
            this.webdav.deleteFolder(projectFolder, FOLDER_DIFF);
        }
        project.getLogger().info("recreating DIFF folder (" + diffFolder + ")");
        this.webdav.createFolder(new String[]{diffFolder});
        if (changed) {
            ph.progress("progress.server.update-project-info", 6);
            project.getLogger().info("updating project info ...");
            i.updateMD5(md5Plan, md5Template, md5Content);
            this.updateProjectInfo(i);
        }
        project.getLogger().info("... project upload DONE");
    }

    private boolean didPlansChange(ThemisProject project, ThemisCloudProjectInfo info) {
        boolean result = true;
        if (info.getDatePlan() != null) {
            Date date = info.getDatePlan();
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)project, project.getUser(), "plan");
            s.addSelectMeta();
            s.addWhere("el.metalastedit", ">", Util.toSqlString((Date)date, (TimeZone)project.getTimeZone()));
            s.setIgnoreTrash();
            boolean bl = result = !s.search().getResult().isEmpty();
            if (!result) {
                CmsElement loc = project.getDefaultElement("location");
                s = new CmsBasicSearch((CmsApplication)project, project.getUser(), "location");
                s.addSelectMeta();
                s.addSelectAttribute(loc.getAttribute("building"));
                s.addWhereBoolean("ele.building", true);
                s.addWhere("el.metalastedit", ">", Util.toSqlString((Date)date, (TimeZone)project.getTimeZone()));
                s.setIgnoreTrash();
                result = !s.search().getResult().isEmpty();
            }
        }
        return result;
    }

    private boolean didTemplatesChange(ThemisProject project, ThemisCloudProjectInfo info) {
        boolean result = true;
        if (info.getDateTemplate() != null) {
            Date date = info.getDateTemplate();
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)project, project.getUser(), new String[]{"locationgroup", "locationtemplate", "observationtemplate", "measuretemplate", "icon"});
            s.addSelectMeta();
            s.addWhere("el.metalastedit", ">", Util.toSqlString((Date)date, (TimeZone)project.getTimeZone()));
            result = !s.search().getResult().isEmpty();
        }
        return result;
    }

    private ThemisFile preparePlans(ThemisProject project) {
        ThemisFile tf = new ThemisFile();
        ArrayList<CmsElementSummary> buildings = project.getBuildings();
        for (CmsElementSummary ele : buildings) {
            tf.addContent(ele.getId());
        }
        ArrayList<CmsElementSummary> plans = project.getPlans();
        for (CmsElementSummary ele : plans) {
            tf.addPlan(ele.getId());
        }
        return tf;
    }

    private ThemisFile prepareTemplates() {
        return new ThemisFile().setContentType(ThemisFile.ContentType.TEMPLATE);
    }

    private ThemisFile prepareContentProject() {
        ThemisFile tf = new ThemisFile();
        tf.setWithAllImages();
        tf.setWithKeytables();
        ThemisFilter filter = ThemisApplication.getInstance().getFilter().getCopy();
        filter.setTriggerEnabled(false);
        filter.clearAll(false, this);
        tf.addContent(filter.getFilteredElementIds());
        return tf;
    }

    protected ThemisFile prepareContentJob(ThemisProject project, ThemisJob job) {
        ThemisFile tf = new ThemisFile();
        tf.setWithAllImages();
        if (job.getContent() == ThemisJob.Content.Filter) {
            ThemisFilter filter = ThemisApplication.getInstance().getFilter().getCopy();
            tf.addContent(filter.getFilteredObservationIds());
        } else {
            tf.addContent(project.getSelectionManager().getSelectedObservationIds());
        }
        return tf;
    }

    public void deleteJob(String projectUuid, ThemisJob job) throws IOException {
        String fnData = job.uuid + ".themis";
        String fnJob = job.uuid + ".job";
        String subfolder = job.status.getServerFolder();
        String folder = "projects/" + projectUuid;
        this.webdav.moveFile(folder + "/" + FOLDER_DATA, fnData, folder + "/" + FOLDER_DELETED_JOBS);
        this.webdav.moveFile(folder + "/" + subfolder, fnJob, folder + "/" + FOLDER_DELETED_JOBS);
    }

    public ArrayList<ThemisJob> getDoneJobs(String projectUuid) throws IOException {
        return this.getJobsFromFolder(projectUuid, FOLDER_DONE_JOBS);
    }

    public ArrayList<ThemisJob> getOpenJobs(String projectUuid) throws IOException {
        return this.getJobsFromFolder(projectUuid, FOLDER_OPEN_JOBS);
    }

    public ArrayList<ThemisJob> getWorkingJobs(String projectUuid) throws IOException {
        return this.getJobsFromFolder(projectUuid, FOLDER_WORKING_JOBS);
    }

    public ArrayList<ThemisJob> getDeletedJobs(String projectUuid) throws IOException {
        return this.getJobsFromFolder(projectUuid, FOLDER_DELETED_JOBS);
    }

    public ArrayList<ThemisJob> getJobsFromFolder(String projectUuid, String subfolder) throws IOException {
        ArrayList<ThemisJob> jobs = new ArrayList<ThemisJob>();
        ArrayList filenamesJob = new ArrayList();
        ArrayList filenamesData = new ArrayList();
        String baseurl = "projects/" + projectUuid + "/" + subfolder;
        filenamesJob.addAll(this.webdav.getFilenames(baseurl, null));
        filenamesData.addAll(this.webdav.getFilenames("projects/" + projectUuid + "/" + FOLDER_DATA, null));
        for (String fn : filenamesJob) {
            if (!fn.toLowerCase().endsWith(".job")) continue;
            try {
                String jobUUID = fn.contains("_") ? fn.substring(0, fn.indexOf("_")) : fn.substring(0, fn.indexOf("."));
                if (!filenamesData.contains(jobUUID + ".themis")) continue;
                String xml = this.webdav.getString(baseurl, fn);
                ThemisJob job = new ThemisJob(jobUUID);
                job.fromXml(xml);
                jobs.add(job);
            }
            catch (IOException | JDOMException ex) {
                ThemisUtil.showError("Fehler beim Auslesen des Jobs", (Exception)ex);
            }
        }
        return jobs;
    }

    public ThemisFile importJob(ThemisProject project, ThemisJob job) throws IOException, JDOMException {
        String fnData = job.getUuid() + ".themis";
        String projectUuid = project.getProjectElement().getUUIDasString();
        String folder = "projects/" + projectUuid;
        File fld = project.getTempfileLocation();
        File targetFile = new File(fld, fnData);
        this.webdav.getFile(folder + "/" + FOLDER_DATA, fnData, targetFile);
        ThemisFile tf = new ThemisFile();
        tf.loadFromFile(targetFile, false);
        targetFile.delete();
        return tf;
    }

    public void moveJobFromDoneToImported(ThemisProject project, ThemisJob job) throws IOException {
        String projectUuid = project.getProjectElement().getUUIDasString();
        String folder = "projects/" + projectUuid;
        this.webdav.moveFile(folder + "/" + FOLDER_DONE_JOBS, job.getFilename(), folder + "/" + FOLDER_IMPORTED_JOBS);
    }

    public void uploadJob(ThemisProject project, ThemisJob job) throws IOException, JDOMException {
        boolean templatesChanged;
        String projectUuid = project.getProjectElement().getUUIDasString();
        String projectFolder = "projects/" + projectUuid;
        ThemisCloudProjectInfo i = this.readProjectInfo(projectUuid);
        String md5Plan = i.getMd5Content();
        String md5Template = i.getMd5Template();
        boolean changed = false;
        boolean plansChanged = this.didPlansChange(project, i);
        if (plansChanged) {
            ThemisFile plans = this.preparePlans(project);
            File plansFile = plans.saveToTempFile("plans.themis");
            if (i.getMd5Plan() == null || !i.getMd5Plan().equals(plans.getMd5())) {
                this.webdav.putFile(projectFolder, plansFile);
                md5Plan = plans.getMd5();
                changed = true;
            }
        }
        if (templatesChanged = this.didTemplatesChange(project, i)) {
            ThemisFile templates = this.prepareTemplates();
            File templatesFile = templates.saveToTempFile("templates.themis");
            if (i.getMd5Template() == null || !i.getMd5Template().equals(templates.getMd5())) {
                this.webdav.putFile(projectFolder, templatesFile);
                md5Template = templates.getMd5();
                changed = true;
            }
        }
        if (changed) {
            i.updateMD5(md5Plan, md5Template, i.getMd5Content());
            this.updateProjectInfo(i);
        }
        ThemisFile content = this.prepareContentJob(project, job);
        File jobFile = content.saveToTempFile(job.getUuid() + ".themis");
        this.webdav.putFile(projectFolder + "/" + FOLDER_DATA, jobFile);
        this.webdav.putString(job.toXml(), projectFolder + "/" + FOLDER_OPEN_JOBS, job.getUuid() + ".job");
    }

    public void updateJobInfo(ThemisProject project, ThemisJob job) throws IOException {
        String projectUuid = project.getProjectElement().getUUIDasString();
        String projectFolder = "projects/" + projectUuid;
        this.webdav.putString(job.toXml(), projectFolder + "/" + FOLDER_OPEN_JOBS, job.getUuid() + ".job");
    }

    public void deleteJobData(ThemisProject project, ThemisJob job) {
    }

    public boolean isServerAvailable() {
        return this.webdav.checkServerConnection();
    }

    public String getUrl() {
        String url = this.webdav.getShareUrl();
        return url == null ? this.webdav.getUrl() : url;
    }

    public String getUser() {
        return this.webdav.getUser();
    }

    public String getPassword() {
        return this.webdav.getPwd();
    }

    public String getTypeAsString() {
        return this.webdav.getType();
    }

    public static enum Type {
        NEXTCLOUD,
        APACHE;

    }

    public static enum Permission {
        OPEN,
        USER;

    }
}

