/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.server;

import at.grid.themis.ontology.ThemisFolder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import org.h2.tools.Server;
import org.openide.util.Exceptions;

public class ThemisDatabaseServer {
    static ThemisDatabaseServer instance;
    HashMap<String, ThemisFolder> serverProjects = new HashMap();
    String port;
    String host;
    Server h2 = null;

    public static ThemisDatabaseServer getInstance() {
        if (instance == null) {
            instance = new ThemisDatabaseServer();
        }
        return instance;
    }

    public String startServer(String host, String port) throws SQLException {
        if (this.h2 != null) {
            return "server-already-started";
        }
        this.h2 = Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-tcpAllowOthers"});
        this.port = port;
        this.host = host;
        this.h2.start();
        return null;
    }

    public String stopServer() throws SQLException {
        if (this.h2 == null) {
            return "no-server-running";
        }
        String error = null;
        this.h2.stop();
        this.h2.shutdown();
        int count = 0;
        while (this.h2.isRunning(true) && count < 50) {
            try {
                ++count;
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.h2 = null;
        this.host = null;
        this.port = null;
        for (ThemisFolder tf : this.serverProjects.values()) {
            this.removeProject(tf);
        }
        return error;
    }

    public void addProject(ThemisFolder tf) {
        tf.createServerConfig(this.host, this.port, tf.getProjectFolder().getAbsolutePath());
        this.serverProjects.put(tf.getProjectFolder().getAbsolutePath(), tf);
    }

    public void removeProject(ThemisFolder tf) {
        tf.deleteServerConfig();
        this.serverProjects.remove(tf.getProjectFolder().getAbsolutePath());
    }

    public Collection<ThemisFolder> getServerProjects() {
        return this.serverProjects.values();
    }

    public boolean isRunning() {
        return this.h2 != null && this.h2.isRunning(true);
    }

    public String getPort() {
        return this.port;
    }
}

