/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.server;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ThemisJob {
    Content content = Content.Filter;
    String title;
    String username;
    String accesscode;
    Date duedate;
    String responsible;
    long responsibleId;
    Status status;
    ArrayList<JobHistory> histories = new ArrayList();
    String uuid = UUID.randomUUID().toString();
    boolean done;

    public ThemisJob() {
    }

    public ThemisJob(String uuid) {
        this();
        this.setUUID(uuid);
    }

    public void updateJob(ThemisJob j) {
        this.title = j.getTitle();
        this.duedate = j.getDuedate();
        this.username = j.getUsername();
        this.responsible = j.getResponsible();
        this.responsibleId = j.getResponsibleId();
    }

    public boolean isDone() {
        return this.status == Status.done || this.status == Status.restored;
    }

    public void setContent(Content c) {
        this.content = c;
    }

    public Content getContent() {
        return this.content;
    }

    public void setUUID(String s) {
        this.uuid = s;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public String getAccessCode() {
        return this.accesscode;
    }

    public void setAccessCode(String code) {
        this.accesscode = code;
    }

    public String getDuedateAsString() {
        return Util.formatDate((Date)this.duedate, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone());
    }

    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public long getResponsibleId() {
        return this.responsibleId;
    }

    public void setResponsible(String responsible, long id) {
        this.responsible = responsible;
        this.responsibleId = id;
    }

    public boolean hasResponsible() {
        return this.responsible != null && !"".equals(this.responsible);
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = Status.open;
        }
        return this.status;
    }

    public String getStatusAsString() {
        return this.getStatus().toString();
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatus(String status) {
        this.status = Status.fromString(status);
    }

    public ArrayList<JobHistory> getHistories() {
        return this.histories;
    }

    public void addHistory(JobHistory h) {
        this.histories.add(h);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void createNewUuid() {
        this.uuid = UUID.randomUUID().toString();
    }

    public String getFilename() {
        String fn = this.uuid + (this.hasResponsible() ? "_" + this.getUsername() : "") + ".job";
        return fn;
    }

    public String toXml() {
        Element root = new Element("themisjob");
        root.setAttribute("version", "1");
        root.addContent((org.jdom.Content)new Element("title").setText(this.title));
        root.addContent((org.jdom.Content)new Element("duedate").setText(Util.formatDate((Date)this.duedate, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone())));
        root.addContent((org.jdom.Content)new Element("status").setText(this.status.toString()));
        root.addContent((org.jdom.Content)new Element("username").setText(this.username));
        root.addContent((org.jdom.Content)new Element("accesscode").setText(this.accesscode));
        if (this.responsible != null) {
            root.addContent((org.jdom.Content)new Element("responsible").setAttribute("username", this.responsible).setAttribute("userid", Long.toString(this.responsibleId)).setText(this.responsible));
        }
        Element hists = new Element("histories");
        for (JobHistory h : this.histories) {
            Element hist = new Element("history");
            hist.setAttribute("datetime", Util.formatDate((Date)new Date(), (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
            hist.setAttribute("status", h.status);
            hist.setAttribute("username", h.username != null ? h.username : "");
            hist.setText(h.infotext);
            hists.addContent((org.jdom.Content)hist);
        }
        root.addContent((org.jdom.Content)hists);
        return Util.toXml((Element)root);
    }

    public void fromXml(String xml) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xml));
        Element e = doc.getRootElement();
        int version = Util.parseInt((String)e.getAttributeValue("version"), (int)1);
        this.title = e.getChildText("title");
        this.username = e.getChildText("username");
        this.accesscode = e.getChildText("accesscode");
        try {
            this.duedate = Util.parseDate((String)e.getChildText("duedate"), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone());
        }
        catch (ParseException ex) {
            this.duedate = null;
        }
        Element responsibleElement = e.getChild("responsible");
        if (responsibleElement != null) {
            this.responsible = responsibleElement.getAttributeValue("username");
            this.responsibleId = Util.parseLong((String)responsibleElement.getAttributeValue("userid"), (long)-1L);
        }
        this.status = Status.fromString(e.getChildText("status"));
        Element hists = e.getChild("histories");
        if (hists != null) {
            for (Object hist : hists.getChildren()) {
                if (!(hist instanceof Element)) continue;
                this.histories.add(new JobHistory((Element)hist));
            }
        }
    }

    public void addHistoryUpload(String username, String status) {
        this.histories.add(new JobHistory(username, status));
        this.setStatus(status);
    }

    public String toString() {
        return this.title + (this.responsible == null || "".equals(this.responsible) ? "" : " <" + this.responsible + ">");
    }

    public class JobHistory {
        Date dt;
        String username;
        String status;
        String infotext;

        public JobHistory(Element e) {
            try {
                String dtStr = e.getAttributeValue("datetime");
                if (dtStr != null) {
                    if (!dtStr.contains(".")) {
                        dtStr = dtStr + ".000";
                    }
                    this.dt = Util.parseDate((String)dtStr, (String)Util.DATETIME_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone());
                }
            }
            catch (ParseException ex) {
                this.dt = null;
            }
            this.username = e.getAttributeValue("username");
            this.status = e.getAttributeValue("status");
            this.infotext = e.getText();
        }

        public JobHistory(String username, String status) {
            this.dt = new Date();
            this.username = username;
            this.status = status;
        }

        public String toString() {
            return Util.formatDate((Date)this.dt, (String)Util.DATETIME_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()) + " -> " + this.status + (this.username == null || "".equals(this.username) ? "" : " [" + this.username + "] ") + (this.infotext == null || "".equals(this.infotext) ? "" : " " + this.infotext.trim());
        }
    }

    public static enum Status {
        open("open"),
        cancelled("cancelled"),
        deleted("deleted"),
        accepted("accepted"),
        working("working"),
        done("done"),
        restored("restored");

        String code;

        private Status(String c) {
            this.code = c;
        }

        public String toString() {
            return this.code;
        }

        public static Status fromString(String s) {
            if (s == null) {
                return open;
            }
            switch (s) {
                case "open": {
                    return open;
                }
                case "cancelled": {
                    return cancelled;
                }
                case "accepted": {
                    return accepted;
                }
                case "working": {
                    return working;
                }
                case "done": {
                    return done;
                }
                case "restored": {
                    return restored;
                }
            }
            return open;
        }

        public boolean isDone() {
            return this == done || this == restored;
        }

        public boolean isOpen() {
            return this == open || this == cancelled;
        }

        public boolean isProgress() {
            return this == accepted || this == working;
        }

        public String getServerFolder() {
            switch (this.code) {
                case "open": 
                case "accepted": 
                case "cancelled": {
                    return "jobs-open";
                }
                case "working": {
                    return "jobs-working";
                }
                case "done": 
                case "restored": {
                    return "jobs-done";
                }
            }
            return "jobs-open";
        }
    }

    public static enum Content {
        Filter,
        Selection;

    }
}

