/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.settings;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.gui.Point;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColor;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.attribute.ThemisBooleanAttribute;
import at.grid.themis.ontology.attribute.ThemisComplexAttribute;
import at.grid.themis.ontology.attribute.ThemisDateAttribute;
import at.grid.themis.ontology.attribute.ThemisListAttribute;
import at.grid.themis.ontology.attribute.ThemisLongtextAttribute;
import at.grid.themis.ontology.attribute.ThemisNumberAttribute;
import at.grid.themis.ontology.attribute.ThemisRelationAttribute;
import at.grid.themis.ontology.attribute.ThemisTextAttribute;
import at.grid.themis.ontology.attribute.manager.ThemisAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisContactAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisEventAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisGroupAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisLocationAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisMeasureAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisObservationAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisObservationHistoryAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisObservationTemplateAttributeManager;
import at.grid.themis.ontology.attribute.manager.ThemisProjectAttributeManager;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.settings.ThemisSettingsFileElement;
import at.grid.themis.ontology.util.EmailSendThread;
import at.grid.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileSystemView;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class ThemisSettings {
    public static final int DISPLAY_COLOR_SETTING_NONE = 0;
    public static final int DISPLAY_COLOR_SETTING_URGENCY = 1;
    public static final int DISPLAY_HIDE_DONE_NO = 0;
    public static final int DISPLAY_HIDE_DONE_ALWAYS = 1;
    public static final int DISPLAY_HIDE_DONE_ALWAYS_EXCEPT_EVENT = 2;
    public static final String ATT_LOC_BARCODE = "barcode";
    public static final String ATT_LOC_BOOLEAN1 = "boolean1";
    public static final String ATT_LOC_BOOLEAN2 = "boolean2";
    public static final String ATT_LOC_BOOLEAN3 = "boolean3";
    public static final String ATT_LOC_BOOLEAN4 = "boolean4";
    public static final String ATT_LOC_DATE1 = "date1";
    public static final String ATT_LOC_DATE2 = "date2";
    public static final String ATT_LOC_DATE3 = "date3";
    public static final String ATT_LOC_DATE4 = "date4";
    public static final String ATT_LOC_DESCRIPTION = "description";
    public static final String ATT_LOC_DOCUMENTS = "documents";
    public static final String ATT_LOC_GPS = "gps";
    public static final String ATT_LOC_GROUP = "group";
    public static final String ATT_LOC_HASAUDIO = "hasaudio";
    public static final String ATT_LOC_HASIMAGE = "hasimage";
    public static final String ATT_LOC_ICON = "icon";
    public static final String ATT_LOC_LIST1 = "list1";
    public static final String ATT_LOC_LIST2 = "list2";
    public static final String ATT_LOC_LIST3 = "list3";
    public static final String ATT_LOC_LIST4 = "list4";
    public static final String ATT_LOC_LONGTEXT1 = "longtext1";
    public static final String ATT_LOC_LONGTEXT2 = "longtext2";
    public static final String ATT_LOC_LONGTEXT3 = "longtext3";
    public static final String ATT_LOC_LONGTEXT4 = "longtext4";
    public static final String ATT_LOC_NUMBER = "number";
    public static final String ATT_LOC_PLAN = "plan";
    public static final String ATT_LOC_POSITION = "position";
    public static final String ATT_LOC_PREFIXSUFFIX = "prefixsuffix";
    public static final String ATT_LOC_SUFFIX = "suffix";
    public static final String ATT_LOC_QUANTITY = "quantity";
    public static final String ATT_LOC_SHOWALWAYS = "showalways";
    public static final String ATT_LOC_SIZE = "size";
    public static final String ATT_LOC_TEXT1 = "text1";
    public static final String ATT_LOC_TEXT2 = "text2";
    public static final String ATT_LOC_TEXT3 = "text3";
    public static final String ATT_LOC_TEXT4 = "text4";
    public static final String ATT_LOC_TITLE = "title";
    public static final String ATT_OBS_ASSESSMENT = "assessment";
    public static final String ATT_OBS_CONTROLDATE = "controldate";
    public static final String ATT_OBS_CONTROL = "control";
    public static final String ATT_OBS_CREATIONDATE = "creationdate";
    public static final String ATT_OBS_DESCRIPTION = "description";
    public static final String ATT_OBS_DOCUMENTS = "documents";
    public static final String ATT_OBS_DONE = "done";
    public static final String ATT_OBS_DONEDATE = "donedate";
    public static final String ATT_OBS_DUEDATE = "duedate";
    public static final String ATT_OBS_REPEAT = "repeat";
    public static final String ATT_OBS_REPEATUNIT = "repeatunit";
    public static final String ATT_OBS_EDITOR = "editor";
    public static final String ATT_OBS_HASAUDIO = "hasaudio";
    public static final String ATT_OBS_HASIMAGE = "hasimage";
    public static final String ATT_OBS_LIST1 = "list1";
    public static final String ATT_OBS_LIST2 = "list2";
    public static final String ATT_OBS_LIST3 = "list3";
    public static final String ATT_OBS_LONGTEXT1 = "longtext1";
    public static final String ATT_OBS_LONGTEXT2 = "longtext2";
    public static final String ATT_OBS_FLOAT1 = "float1";
    public static final String ATT_OBS_FLOAT2 = "float2";
    public static final String ATT_OBS_FLOAT3 = "float3";
    public static final String ATT_OBS_FLOAT4 = "float4";
    public static final String ATT_OBS_MEASURE = "measure";
    public static final String ATT_OBS_NUMBER = "number";
    public static final String ATT_OBS_FULLNUMBER = "fullnumber";
    public static final String ATT_OBS_QUANTITY = "quantity";
    public static final String ATT_OBS_RESPONSIBLE = "responsible";
    public static final String ATT_OBS_TEXT1 = "text1";
    public static final String ATT_OBS_TEXT2 = "text2";
    public static final String ATT_OBS_TEXT3 = "text3";
    public static final String ATT_OBS_TEXT4 = "text4";
    public static final String ATT_OBS_TITLE = "title";
    public static final String ATT_OBS_TYPE = "type";
    Document settings = new Document();
    ThemisApplication app;
    ThemisProject project;
    private HashMap<String, ThemisAttribute> locationAttributeMap = new HashMap();
    private ArrayList<ThemisAttribute> locationAttributes = new ArrayList();
    private ArrayList<ThemisAttribute> locationAttributesUsed = new ArrayList();
    private ArrayList<ThemisAttribute> locationAttributesFixed = new ArrayList();
    private HashMap<String, ThemisAttribute> observationAttributeMap = new HashMap();
    private ArrayList<ThemisAttribute> observationAttributes = new ArrayList();
    private ArrayList<ThemisAttribute> observationAttributesUsed = new ArrayList();
    private ArrayList<ThemisAttribute> observationAttributesFixed = new ArrayList();
    private ArrayList<ThemisAttribute> eventAttributes = new ArrayList();
    private ArrayList<ThemisAttribute> projectAttributes = new ArrayList();
    ThemisAttributeManager locationAttributeManager = new ThemisLocationAttributeManager();
    ThemisAttributeManager observationAttributeManager = new ThemisObservationAttributeManager();
    ThemisAttributeManager observationTemplateAttributeManager = new ThemisObservationTemplateAttributeManager(this.observationAttributeManager);
    ThemisAttributeManager observationHistoryAttributeManager = new ThemisObservationHistoryAttributeManager(this.observationAttributeManager);
    ThemisAttributeManager projectAttributeManager = new ThemisProjectAttributeManager();
    ThemisAttributeManager eventAttributeManager = new ThemisEventAttributeManager();
    ThemisAttributeManager contactAttributeManager = new ThemisContactAttributeManager();
    ThemisAttributeManager groupAttributeManager = new ThemisGroupAttributeManager();
    ThemisAttributeManager measureAttributeManager = new ThemisMeasureAttributeManager();
    ThemisSettingsFileElement folderReportTemplate = new ThemisSettingsFileElement(this, "/themis/project/reportspec/export/templatefile");
    ThemisSettingsFileElement folderReportOutput = new ThemisSettingsFileElement(this, "/themis/project/reportspec/export/output", FileSystemView.getFileSystemView().getDefaultDirectory().getAbsoluteFile());
    ThemisSettingsFileElement folderOpenProject = new ThemisSettingsFileElement(this, "/themis/system/files/openproject");
    ThemisSettingsFileElement folderProjectRoot = new ThemisSettingsFileElement(this, "/themis/system/files/projectroot", FileSystemView.getFileSystemView().getDefaultDirectory().getAbsoluteFile().getAbsolutePath());
    ThemisSettingsFileElement folderDemoUnpack = new ThemisSettingsFileElement(this, "/themis/system/files/demounpack");
    ThemisSettingsFileElement folderProjectTemplate = new ThemisSettingsFileElement(this, "/themis/system/files/projecttemplate");
    ThemisSettingsFileElement folderThemisIO = new ThemisSettingsFileElement(this, "/themis/system/files/themisio");
    ThemisSettingsFileElement folderImageObserver = new ThemisSettingsFileElement(this, "/themis/system/files/imageobserver", ThemisSettings.getFolderImageObserverDefault());
    ThemisSettingsFileElement folderPlanImport = new ThemisSettingsFileElement(this, "/themis/system/files/planimport");
    ThemisSettingsFileElement fileExportTemplate = new ThemisSettingsFileElement(this, "/themis/project/export/templatefile");
    ThemisSettingsFileElement folderExport = new ThemisSettingsFileElement(this, "/themis/project/export/folder");
    ThemisSettingsFileElement folderAutoImport = new ThemisSettingsFileElement(this, "/themis/project/autoexecute/importfolder");
    ThemisSettingsFileElement folderAutoExport = new ThemisSettingsFileElement(this, "/themis/project/autoexecute/exportfolder");

    public ThemisSettings(ThemisApplication app, ThemisProject project) {
        this.app = app;
        this.project = project;
        if (!this.settings.hasRootElement()) {
            this.settings.addContent((Content)new Element("themis"));
        }
    }

    public File getSettingsFile() {
        File f1;
        File f = new File(this.app.getApplicationDataConfigFolder(), "settings52.xml");
        if (!f.isFile() && (f1 = new File(this.app.getApplicationDataConfigFolder(), "settings.xml")).isFile()) {
            this.project.getFileAccess().copy(f1, f);
        }
        if (!f.isFile()) {
            File f0 = new File("etc/themis_settings.xml");
            if (!f0.isFile()) {
                f0 = new File(System.getProperty("user.home", "") + "/.themis/themis_settings.xml");
            }
            if (f0.isFile()) {
                this.app.getProject().getFileAccess().copy(f0, f);
            }
        }
        return f;
    }

    public void copySettings() {
        File f1 = this.getSettingsFile();
        File f2 = new File(f1.getParentFile(), "themis_settings_" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone()));
        try {
            Util.copy((File)f1, (File)f2);
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisSettings.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getProjectSettingsAsString() {
        return this.getXmlAsString();
    }

    public String getProjectSettingsMD5() {
        String s = Util.toXml((Element)this.settings.getRootElement().getChild("project"));
        return Util.md5((String)s);
    }

    public String getSystemSettingsAsString() {
        return this.getXmlAsString();
    }

    public String getXmlAsString() {
        this.updateXmlBeforeSave();
        return Util.toXml((Document)this.settings);
    }

    public Document getSettingsAsCopy() {
        this.updateXmlBeforeSave();
        return (Document)this.settings.clone();
    }

    public Document getProjectSettingsAsCopy() {
        Document doc = this.getSettingsAsCopy();
        doc.getRootElement().removeChild("system");
        return doc;
    }

    public void loadFromFile() throws JDOMException, IOException {
        File f = this.getSettingsFile();
        if (f.isFile()) {
            SAXBuilder builder = new SAXBuilder();
            this.settings = builder.build(f);
            if (this.settings.getRootElement() == null) {
                this.settings.addContent((Content)new Element("themis"));
            }
            this.readXmlAfterLoad();
        } else {
            this.settings = new Document(new Element("themis").setAttribute("version", "0"));
        }
    }

    private void readXmlAfterLoad() {
        ThemisAttribute ta;
        List atts;
        this.initialiseAttributes(this.app);
        Element e = this.getXmlElement("/themis/project/attributes/locationattributes", false);
        if (e != null) {
            atts = e.getChildren("locationattribute");
            for (Element a : atts) {
                ta = this.getLocationAttribute(a.getAttributeValue("id"));
                if (ta == null) continue;
                if (ta.isUserdefined()) {
                    ta.setLabel(a.getAttributeValue("label"));
                }
                ta.setWriteprotected("true".equalsIgnoreCase(a.getAttributeValue("writeprotected")));
                if (!"true".equalsIgnoreCase(a.getAttributeValue("use"))) continue;
                ta.setUsed(true);
            }
        }
        if ((e = this.getXmlElement("/themis/project/attributes/observationattributes", false)) != null) {
            atts = e.getChildren("observationattribute");
            for (Element a : atts) {
                ta = this.getObservationAttribute(a.getAttributeValue("id"));
                if (ta == null) continue;
                if (ta.isUserdefined()) {
                    ta.setLabel(a.getAttributeValue("label"));
                }
                ta.setWriteprotected("true".equalsIgnoreCase(a.getAttributeValue("writeprotected")));
                ta.setChecklistedit("true".equalsIgnoreCase(a.getAttributeValue("checklist")));
                if (ta.isAlwaysUsed() || "true".equalsIgnoreCase(a.getAttributeValue("use"))) {
                    ta.setUsed(true);
                }
                ta.setShow(a.getAttributeValue("show", "mkia"));
            }
        }
        if (ThemisApplication.getInstance().getProject().isOpen()) {
            this.eventAttributes.clear();
            e = this.getXmlElement("/themis/project/attributes/eventattributes", false);
            if (e != null) {
                atts = e.getChildren("eventattribute");
                for (Element a : atts) {
                    ThemisAttribute.create(a);
                }
            }
            this.projectAttributes.clear();
            e = this.getXmlElement("/themis/project/attributes/projectattributes", false);
            if (e != null) {
                atts = e.getChildren("projectattribute");
                for (Element a : atts) {
                    ThemisAttribute.create(a);
                }
            }
        }
        this.project.getCache().setEnabled(this.useElementCache());
    }

    public void applyProjectDefaultSettings() {
        if (this.project.isOpen()) {
            this.settings.getRootElement().removeChild("project");
            this.initialiseAttributes(this.app);
            this.setLocationAttributeUsage("title", ATT_LOC_GROUP, "description", ATT_LOC_PLAN);
            this.setObservationAttributeUsage("title", "description", ATT_OBS_DONE, ATT_OBS_DUEDATE);
            this.clearObservationTableAttributes();
            this.addObservationTableAttributes(this.getObservationAttribute(ATT_OBS_FULLNUMBER));
            this.addObservationTableAttributes(this.getLocationAttribute(ATT_LOC_PLAN));
            this.addObservationTableAttributes(this.getLocationAttribute("title"));
            this.addObservationTableAttributes(this.getObservationAttribute("title"));
            this.addObservationTableAttributes(this.getObservationAttribute(ATT_OBS_DUEDATE));
            this.addObservationTableAttributes(this.getObservationAttribute("hasimage"));
            this.setImageForObservation(true);
        }
    }

    public void applyProjectSettings() {
        if (this.project.isOpen()) {
            String xml = this.project.getProjectElement().getAttributeValue("settings");
            if (xml == null || "".equals(xml)) {
                this.applyProjectDefaultSettings();
            } else {
                this.applyProjectSettings(xml);
            }
        }
    }

    protected void applyProjectSettings(String xml) {
        try {
            int projectXmlVersion = 0;
            if (xml != null && !"".equals(xml)) {
                SAXBuilder saxbuilder = new SAXBuilder();
                Document projectsettings = saxbuilder.build((Reader)new StringReader(xml));
                projectXmlVersion = this.applyProjectSettings(projectsettings);
            }
            this.readXmlAfterLoad();
            ThemisApplication.getInstance().getFilter().updateObservationListAttributes();
        }
        catch (JDOMException ex) {
            Logger.getLogger(ThemisSettings.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisSettings.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int applyProjectSettings(Document projectsettings) {
        int projectXmlVersion = 0;
        if (projectsettings != null) {
            int systemVersion = Integer.parseInt(projectsettings.getRootElement().getAttributeValue("version", "0"));
            Content projectElement = projectsettings.getRootElement().getChild("project").detach();
            if (projectElement != null) {
                projectXmlVersion = Integer.parseInt(((Element)projectElement).getAttributeValue("version", "0"));
                this.settings.getRootElement().removeChild("project");
                this.settings.getRootElement().addContent(projectElement);
            }
            if (projectXmlVersion == 0) {
                projectXmlVersion = systemVersion;
            }
        }
        this.readXmlAfterLoad();
        return projectXmlVersion;
    }

    public void applySettings(String xml) {
        try {
            SAXBuilder saxbuilder = new SAXBuilder();
            this.settings = saxbuilder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException ex) {
            Logger.getLogger(ThemisSettings.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisSettings.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String saveToFile() {
        this.updateXmlBeforeSave();
        return this.saveToFile(this.settings, this.getSettingsFile());
    }

    private String saveToFile(Document doc, File dest) {
        if (dest == null) {
            return "File is NULL";
        }
        this.project.getLogger().info("saving settings to file");
        XMLOutputter output = new XMLOutputter(Format.getPrettyFormat().setEncoding("UTF-8").setTextMode(Format.TextMode.PRESERVE));
        try {
            output.output(doc, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(dest), StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
        this.project.getFileAccess().setWritePermission(dest);
        return null;
    }

    public void saveToProject() {
        if (this.project.isOpen()) {
            String xml = this.getXmlAsString();
            this.project.getLogger().info("saving settings to project");
            CmsProject p = this.project.getProjectElement();
            if (p != null) {
                this.project.getProjectElement().setAttributeValue("settings", xml);
                this.project.getProjectElement().save();
            }
        }
    }

    public String save() {
        this.saveToProject();
        return this.saveToFile();
    }

    private void updateXmlBeforeSave() {
        if (!this.project.isOpen()) {
            return;
        }
        Element e = this.getXmlElement("/themis/project/attributes/locationattributes", true);
        e.removeChildren("locationattribute");
        for (ThemisAttribute ta : this.getLocationAttributesUsed()) {
            e.addContent((Content)this.getThemisAttributeAsElement(ta));
        }
        for (ThemisAttribute ta : this.getLocationAttributes()) {
            if (this.getLocationAttributesUsed().contains(ta)) continue;
            e.addContent((Content)this.getThemisAttributeAsElement(ta));
        }
        e = this.getXmlElement("/themis/project/attributes/observationattributes", true);
        e.removeChildren("observationattribute");
        for (ThemisAttribute ta : this.getObservationAttributesUsed()) {
            e.addContent((Content)this.getThemisAttributeAsElement(ta));
        }
        for (ThemisAttribute ta : this.getObservationAttributes()) {
            if (this.getObservationAttributesUsed().contains(ta)) continue;
            e.addContent((Content)this.getThemisAttributeAsElement(ta));
        }
        e = this.getXmlElement("/themis/project/attributes/eventattributes", true);
        e.removeChildren("eventattribute");
        for (ThemisAttribute ta : this.getAttributes("event")) {
            if (!ta.isUserdefined()) continue;
            e.addContent((Content)this.getThemisAttributeAsElement(ta));
        }
        e = this.getXmlElement("/themis/project/attributes/projectattributes", true);
        e.removeChildren("projectattribute");
        for (ThemisAttribute ta : this.getAttributes("project")) {
            if (!ta.isUserdefined()) continue;
            e.addContent((Content)this.getThemisAttributeAsElement(ta));
        }
    }

    private Element getThemisAttributeAsElement(ThemisAttribute ta) {
        String xmlTitle;
        CmsElement ref;
        switch (ta.getTarget()) {
            case LOCATION: {
                ref = this.project.getDefaultElement("location");
                xmlTitle = "locationattribute";
                break;
            }
            case OBSERVATION: {
                ref = this.project.getDefaultElement("observation");
                xmlTitle = "observationattribute";
                break;
            }
            case EVENT: {
                ref = this.project.getDefaultElement("event");
                xmlTitle = "eventattribute";
                break;
            }
            case PROJECT: {
                ref = this.project.getDefaultElement("project");
                xmlTitle = "projectattribute";
                break;
            }
            default: {
                ref = null;
                xmlTitle = "unknown";
            }
        }
        if (ref == null) {
            return null;
        }
        Element xmlElement = new Element(xmlTitle);
        xmlElement.setAttribute("id", ta.getId()).setAttribute("code", ta.getCmsCode()).setAttribute(ATT_OBS_TYPE, ta.getTypeForXml()).setAttribute("label", ta.getLabel()).setAttribute("writeprotected", ta.isWriteprotected() ? "true" : "false").setAttribute("checklist", ta.isChecklistedit() ? "true" : "false").setAttribute("show", ta.getShow()).setAttribute("use", ta.isUsed() ? "true" : "false");
        CmsAttribute att = ref.getAttribute(ta.getCmsCode());
        if (ta.getTypeId() != null) {
            switch (ta.getTypeId()) {
                case LIST: {
                    if (!(att instanceof KeyAttribute)) break;
                    xmlElement.setAttribute("keytable", ((KeyAttribute)att).getTableCode());
                    break;
                }
                case RELATION: {
                    if (!(att instanceof RelationAttribute)) break;
                    xmlElement.setAttribute("relation", String.join((CharSequence)",", ((RelationAttribute)att).getElementtypes()));
                }
            }
        }
        return xmlElement;
    }

    public String getProperty(String key, String defaultValue) {
        try {
            return this.getXmlElementText("/themis/system/properties/" + key, defaultValue);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public void setProperty(String key, String val) {
        Element xmlElement = this.getXmlElement("/themis/system/properties/" + key, true);
        if (xmlElement != null) {
            try {
                xmlElement.setText(val == null ? "" : val);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void removeProperty(String key) {
        this.getXmlElement("/themis/system/properties", true).removeChild(key);
    }

    public Element getXmlElement(String path, boolean create) {
        try {
            return Util.getXmlElement((Element)this.settings.getRootElement(), (String)path, (boolean)create);
        }
        catch (JDOMException ex) {
            this.project.getLogger().severe("Error accessing settings using path '" + path + "'");
            return null;
        }
    }

    public String getXmlElementText(String path, String defaultvalue) {
        Element e = this.getXmlElement(path, false);
        return e == null ? defaultvalue : e.getText();
    }

    public String getXmlAttribute(String path, String defaultvalue) {
        try {
            return Util.getXmlAttribute((Element)this.settings.getRootElement(), (String)path, (String)defaultvalue);
        }
        catch (JDOMException ex) {
            this.project.getLogger().severe("Error accessing settings using path '" + path + "'");
            return defaultvalue;
        }
    }

    public int getXmlVersion() {
        return Integer.parseInt(this.getXmlElement("/themis", true).getAttributeValue("version", "0"));
    }

    public void setXmlVersion(int v) {
        this.getXmlElement("/themis", true).setAttribute("version", Integer.toString(v));
    }

    protected int getXmlProjectVersion() {
        return Integer.parseInt(this.getXmlElement("/themis/project", true).getAttributeValue("version", "0"));
    }

    protected void setXmlProjectVersion(int v) {
        this.getXmlElement("/themis/project", true).setAttribute("version", Integer.toString(v));
    }

    public ArrayList<String> getProjectLists() {
        String path = "/themis/system/projectlists/projectlist/@title";
        ArrayList<String> result = new ArrayList<String>();
        try {
            List attributes = XPath.selectNodes((Object)this.settings.getRootElement(), (String)path);
            if (attributes != null) {
                for (Attribute a : attributes) {
                    result.add(a.getValue());
                }
            }
        }
        catch (JDOMException ex) {
            this.project.getLogger().severe("Error accessing settings using path '" + path + "'");
        }
        return result;
    }

    public boolean hasProjectList(String listtitle) {
        return this.getProjectListElement(listtitle) != null;
    }

    public void addProjectList(String listtitle) {
        if (!this.hasProjectList(listtitle)) {
            Element e = this.getXmlElement("/themis/system/projectlists", true);
            e.addContent((Content)new Element("projectlist").setAttribute("title", listtitle));
        }
    }

    public boolean renameProjectList(String oldtitle, String newtitle) {
        Element e = this.getProjectListElement(oldtitle);
        if (e != null && !this.hasProjectList(newtitle)) {
            e.setAttribute("title", newtitle);
            return true;
        }
        return false;
    }

    public void removeProjectList(String listtitle) {
        if (this.hasProjectList(listtitle)) {
            Element projectlist = this.getXmlElement("/themis/system/projectlists", true);
            List lists = projectlist.getChildren("projectlist");
            for (Element list : lists) {
                if (!list.getAttributeValue("title", "").equals(listtitle)) continue;
                projectlist.removeContent((Content)list);
                return;
            }
        }
    }

    public ArrayList<ThemisFolder> getProjectsForList(String projectlist) {
        ArrayList<ThemisFolder> result = new ArrayList<ThemisFolder>();
        Element e = this.getProjectListElement(projectlist);
        if (e != null) {
            List projects = e.getChildren();
            for (Element p : projects) {
                if (p.getAttributeValue("file") == null) continue;
                result.add(new ThemisFolder(new File(p.getAttributeValue("file")), p.getAttributeValue("title")));
            }
        }
        return result;
    }

    public void addProjectToList(String listtitle, ThemisFolder f) {
        Element e = this.getProjectListElement(listtitle);
        if (e != null) {
            e.addContent((Content)new Element("project").setAttribute("title", f.getProjectFolder().getName()).setAttribute("file", f.getProjectFolder().getAbsolutePath()));
        }
    }

    public void removeProjectFromList(String listtitle, ThemisFolder f) {
        Element e = this.getProjectListElement(listtitle);
        Element eChild = this.getXmlElement("/themis/system/projectlists/projectlist[@title='" + listtitle + "']/project[@file='" + f.getProjectFolder().getAbsolutePath() + "']", false);
        if (e != null && eChild != null) {
            e.removeContent((Content)eChild);
        }
    }

    public Element getProjectListElement(String listtitle) {
        String path = "/themis/system/projectlists/projectlist[@title='" + listtitle + "']";
        try {
            return (Element)XPath.selectSingleNode((Object)this.settings.getRootElement(), (String)path);
        }
        catch (JDOMException ex) {
            this.project.getLogger().severe("Error accessing settings using path '" + path + "'");
            return null;
        }
    }

    public String getTemplateDownloadURL() {
        return "https://update.themis-software.at/vorlagen/";
    }

    public File getTemplateFile() {
        Element element = this.getXmlElement("/themis/project/template/file", false);
        if (element != null) {
            return new File(element.getText());
        }
        return null;
    }

    public void setTemplateFile(File f) {
        this.getXmlElement("/themis/project/template/file", true).setText(f == null ? null : f.getAbsolutePath());
    }

    public boolean getTemplateUseIcons() {
        return this.getTemplateSetting("usesection", "icons", true);
    }

    public void setInternalTemplateFile(File f) {
        this.getXmlElement("/themis/project/internaltemplate/file", true).setText(f == null ? null : f.getAbsolutePath());
    }

    public File getInternalTemplateFile() {
        Element element = this.getXmlElement("/themis/project/internaltemplate/file", false);
        if (element != null) {
            String content = element.getText();
            if (content != null && !content.isEmpty()) {
                return new File(content);
            }
            return null;
        }
        return null;
    }

    public void setTemplateUseTexts(boolean flag) {
        this.setTemplateSetting("usesection", "texts", flag);
    }

    public boolean getTemplateUseTexts() {
        return this.getTemplateSetting("usesection", "texts", true);
    }

    public void setTemplateUseLists(boolean flag) {
        this.setTemplateSetting("usesection", "lists", flag);
    }

    public boolean getTemplateUseLists() {
        return this.getTemplateSetting("usesection", "lists", true);
    }

    public void setTemplateUseDocuments(boolean flag) {
        this.setTemplateSetting("usesection", "documents", flag);
    }

    public boolean getTemplateUseDocuments() {
        return this.getTemplateSetting("usesection", "documents", true);
    }

    public void setTemplateUseContacts(boolean flag) {
        this.setTemplateSetting("usesection", "contacts", flag);
    }

    public boolean getTemplateUseContacts() {
        return this.getTemplateSetting("usesection", "contacts", true);
    }

    public void setTemplateUseSettings(boolean flag) {
        this.setTemplateSetting("usesection", "settings", flag);
    }

    public boolean getTemplateUseSettings() {
        return this.getTemplateSetting("usesection", "settings", true);
    }

    public boolean getTemplateUseForms() {
        return this.getTemplateSetting("usesection", "forms", true);
    }

    public void setTemplateUseForms(boolean flag) {
        this.setTemplateSetting("usesection", "forms", flag);
    }

    public boolean getTemplateUseReportTemplates() {
        return this.getTemplateSetting("usesection", "reporttemplates", true);
    }

    public void setTemplateUseReportTemplates(boolean flag) {
        this.setTemplateSetting("usesection", "reporttemplates", flag);
    }

    public void setTemplateUseIcons(boolean flag) {
        this.setTemplateSetting("usesection", "icons", flag);
    }

    public boolean getTemplateDeleteMissingItems() {
        return this.getTemplateSetting("settings", "deletemissing", true);
    }

    public void setTemplateDeleteMissingItems(boolean flag) {
        this.setTemplateSetting("settings", "deletemissing", flag);
    }

    public boolean getTemplateAutoUpdate() {
        return this.getTemplateSetting("settings", "autoupdate", true);
    }

    public void setTemplateAutoUpdate(boolean flag) {
        this.setTemplateSetting("settings", "autoupdate", flag);
    }

    public boolean getTemplateMatchByTitle() {
        return this.getTemplateSetting("settings", "matchtitle", false);
    }

    public void setTemplateMatchByTitle(boolean flag) {
        this.setTemplateSetting("settings", "matchtitle", flag);
    }

    private boolean getTemplateSetting(String setting, String section, boolean defaultIsTrue) {
        String val = this.getXmlAttribute("/themis/project/template/" + setting + "/@" + section, defaultIsTrue ? "true" : "false");
        return "true".equalsIgnoreCase(val);
    }

    private void setTemplateSetting(String setting, String section, boolean flag) {
        Element e = this.getXmlElement("/themis/project/template/" + setting, true);
        e.setAttribute(section, flag ? "true" : "false");
    }

    public ArrayList<Long> getTemplateFavourites() {
        String val = this.getXmlElementText("/themis/project/template/favourites", "");
        ArrayList<Long> result = new ArrayList<Long>();
        for (String v : val.split(",")) {
            try {
                result.add(Long.parseLong(v));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public ArrayList<String> getTemplateFavouritesAsStringList() {
        String val = this.getXmlElementText("/themis/project/template/favourites", "");
        ArrayList<String> result = new ArrayList<String>();
        for (String v : val.split(",")) {
            result.add(v);
        }
        return result;
    }

    public void setTemplateFavourite(ArrayList<Long> ids) {
        ArrayList<String> idsStr = new ArrayList<String>();
        for (long id : ids) {
            idsStr.add(Long.toString(id));
        }
        this.getXmlElement("/themis/project/template/favourites", true).setText(String.join((CharSequence)",", idsStr));
    }

    public void addTemplateFavourite(long id) {
        String idStr = Long.toString(id);
        ArrayList<String> val = this.getTemplateFavouritesAsStringList();
        if (!val.contains(idStr)) {
            val.add(idStr);
        }
        this.getXmlElement("/themis/project/template/favourites", true).setText(String.join((CharSequence)",", val));
    }

    public void removeTemplateFavourite(long id) {
        String idStr = Long.toString(id);
        ArrayList<String> val = this.getTemplateFavouritesAsStringList();
        val.remove(idStr);
        this.getXmlElement("/themis/project/template/favourites", true).setText(String.join((CharSequence)",", val));
    }

    public String getPermissionEditTemplates() {
        return this.getXmlElementText("/themis/project/permission/edittemplates", "*");
    }

    public void setPermissionEditTemplates(String setting) {
        Element e = this.getXmlElement("/themis/project/permission/edittemplates", true);
        e.setText(setting == null || "".equals(setting) ? "*" : setting);
    }

    public void addPermissionEditTemplates(String newuser) {
        String permission = this.getPermissionEditTemplates();
        String[] usernames = permission.split(",");
        boolean found = false;
        for (String username : usernames) {
            if (!username.trim().equals(newuser)) continue;
            found = true;
            break;
        }
        if (!found) {
            permission = permission + "," + newuser;
        }
        this.setPermissionEditTemplates(permission);
    }

    public String getPermissionEditAttributes() {
        return this.getXmlElementText("/themis/project/permission/edittemplates", "*");
    }

    public void setPermissionEditAttributes(String setting) {
        Element e = this.getXmlElement("/themis/project/permission/edittemplates", true);
        e.setText(setting == null || "".equals(setting) ? "*" : setting);
    }

    public int getImageUploadSize() {
        return Integer.parseInt(this.getXmlElementText("/themis/project/image/size", "2000"));
    }

    public void setImageUploadSize(int size) {
        this.getXmlElement("/themis/project/image/size", true).setText(Integer.toString(size));
    }

    public float getImageUploadQuality() {
        return Float.parseFloat(this.getXmlElementText("/themis/project/image/quality", "0.8"));
    }

    public void setImageUploadQuality(float quality) {
        this.getXmlElement("/themis/project/image/quality", true).setText(Float.toString(quality));
    }

    public boolean getImageForObservation() {
        return this.getXmlElementText("/themis/project/image/target", "obs").toLowerCase().contains("obs");
    }

    public void setImageForObservation(boolean flagObs) {
        boolean flagLoc = this.getImageForLocation();
        String target = (flagLoc ? "loc" : "") + (flagObs ? "obs" : "");
        this.getXmlElement("/themis/project/image/target", true).setText(target);
    }

    public boolean getImageForLocation() {
        return this.getXmlElementText("/themis/project/image/target", "obs").toLowerCase().contains("loc");
    }

    public void setImageForLocation(boolean flagLoc) {
        boolean flagObs = this.getImageForObservation();
        String target = (flagLoc ? "loc" : "") + (flagObs ? "obs" : "");
        this.getXmlElement("/themis/project/image/target", true).setText(target);
    }

    public boolean getImageKeepOriginal() {
        return "true".equalsIgnoreCase(this.getXmlElementText("/themis/project/images/keeporiginal", "false"));
    }

    public void setImageKeepOriginal(boolean setting) {
        Element e = this.getXmlElement("/themis/project/images/keeporiginal", true);
        e.setText(setting ? "true" : "false");
    }

    public int getImagePlansnippetSize() {
        return Integer.parseInt(this.getXmlElementText("/themis/project/image/plansnippetsize", "30"));
    }

    public void setImagePlansnippetSize(int size) {
        this.getXmlElement("/themis/project/image/plansnippetsize", true).setText(Integer.toString(size));
    }

    public boolean getShowBuildingsInLocList() {
        return "true".equalsIgnoreCase(this.getXmlElementText("/themis/project/loclist/showbuildings", "false"));
    }

    public void setShowBuildingsInLocList(boolean setting) {
        Element e = this.getXmlElement("/themis/project/loclist/showbuildings", true);
        e.setText(setting ? "true" : "false");
    }

    public boolean useLargePlanBuffer() {
        return false;
    }

    public void setLargePlanBuffer(boolean setting) {
        Element e = this.getXmlElement("/themis/project/plan/largebuffer", true);
        e.setText(setting ? "true" : "false");
    }

    public boolean getDisplayMoveIconWithLabel() {
        return "true".equalsIgnoreCase(this.getXmlElementText("/themis/project/display/moveicons", "false"));
    }

    public void setDisplayMoveIconWithLabel(boolean setting) {
        Element e = this.getXmlElement("/themis/project/display/moveicons", true);
        e.setText(setting ? "true" : "false");
    }

    public boolean getLocNumberIndividual() {
        return "true".equalsIgnoreCase(this.getXmlElementText("/themis/project/other/locnumberindividual", "false"));
    }

    public void setLocNumberIndividual(boolean setting) {
        Element e = this.getXmlElement("/themis/project/other/locnumberindividual", true);
        e.setText(setting ? "true" : "false");
    }

    public int getDisplayIconSize() {
        return Integer.parseInt(this.getXmlElementText("/themis/project/display/iconsize", "30"));
    }

    public void setDisplayIconSize(int setting) {
        Element e = this.getXmlElement("/themis/project/display/iconsize", true);
        e.setText(Integer.toString(setting));
    }

    public int getDisplayPointSize() {
        return Integer.parseInt(this.getXmlElementText("/themis/project/display/pointsize", "15"));
    }

    public void setDisplayPointSize(int setting) {
        Element e = this.getXmlElement("/themis/project/display/pointsize", true);
        e.setText(Integer.toString(setting));
    }

    public int getDisplayLineSize() {
        return Integer.parseInt(this.getXmlElementText("/themis/project/display/linesize", "6"));
    }

    public void setDisplayLineSize(int setting) {
        Element e = this.getXmlElement("/themis/project/display/linesize", true);
        e.setText(Integer.toString(setting));
    }

    public int getDisplayFontSize() {
        return Integer.parseInt(this.getXmlElementText("/themis/project/display/fontsize", "14"));
    }

    public void setDisplayFontSize(int setting) {
        Element e = this.getXmlElement("/themis/project/display/fontsize", true);
        e.setText(Integer.toString(setting));
    }

    public int getDisplayColorSetting() {
        return Integer.parseInt(this.getXmlElementText("/themis/project/display/colorsetting", "0"));
    }

    public void setDisplayColorSetting(int setting) {
        Element e = this.getXmlElement("/themis/project/display/colorsetting", true);
        e.setText(Integer.toString(setting));
    }

    public ColorOption getDisplayColorOption() {
        String co = this.getXmlElementText("/themis/project/display/coloroption", "static:-13525505:-1#-13525505#-1");
        return ColorOption.fromString(co);
    }

    public void setDisplayColorOption(ColorOption co) {
        Element e = this.getXmlElement("/themis/project/display/coloroption", true);
        e.setText(co.toStringDefinition());
    }

    public String getDisplayColorPoint() {
        return this.getXmlAttribute("/themis/project/display/color/point/@standard", "242,142,4");
    }

    public void setDisplayColorPoint(String c) {
        Element e = this.getXmlElement("/themis/project/display/color/point", true);
        e.setAttribute("standard", c);
    }

    public String getDisplayColorPointSelected() {
        return this.getXmlAttribute("/themis/project/display/color/point/@selected", "4,30,100");
    }

    public void setDisplayColorPointSelected(String c) {
        Element e = this.getXmlElement("/themis/project/display/color/point", true);
        e.setAttribute("selected", c);
    }

    public String getDisplayDrawingColor() {
        return this.getXmlAttribute("/themis/project/display/drawing/@color", "255,0,0");
    }

    public void setDisplayDrawingColor(String c) {
        Element e = this.getXmlElement("/themis/project/display/drawing", true);
        e.setAttribute("color", c);
    }

    public int getDisplayDrawingTool() {
        return Util.parseInt((String)this.getXmlAttribute("/themis/project/display/drawing/@tool", "0"), (int)0);
    }

    public void setDisplayDrawingTool(int idx) {
        Element e = this.getXmlElement("/themis/project/display/drawing", true);
        e.setAttribute("tool", Integer.toString(idx));
    }

    public Point getDisplayLabelOffset() {
        Element e = this.getXmlElement("/themis/project/display/labeloffset", false);
        if (e == null) {
            return null;
        }
        try {
            if (e.getAttribute("dx") == null) {
                return null;
            }
            double dx = e.getAttribute("dx").getDoubleValue();
            double dy = e.getAttribute("dy").getDoubleValue();
            return new Point(dx, dy);
        }
        catch (DataConversionException ex) {
            this.project.getLogger().severe("Error parsing label offset: " + ex.getMessage());
            return null;
        }
    }

    public void setDisplayLabelOffset(Point p) {
        Element e = this.getXmlElement("/themis/project/display/labeloffset", true);
        if (p == null) {
            e.removeAttribute("dx");
            e.removeAttribute("dy");
        } else {
            e.setAttribute("dx", Double.toString(p.getX()));
            e.setAttribute("dy", Double.toString(p.getY()));
        }
    }

    public String getDisplayLabelAttribute() {
        String result = this.getXmlAttribute("/themis/project/display/color/label/@att", "title");
        return "".equals(result) ? null : result;
    }

    public void setDisplayLabelAttribute(String att) {
        Element e = this.getXmlElement("/themis/project/display/color/label", true);
        e.setAttribute("att", att == null ? "" : att);
    }

    public boolean getDisplayLabelNumber() {
        String result = this.getXmlAttribute("/themis/project/display/color/label/@number", "");
        return "true".equals(result);
    }

    public void setDisplayLabelNumber(boolean sel) {
        Element e = this.getXmlElement("/themis/project/display/color/label", true);
        e.setAttribute("number", sel ? "true" : "false");
    }

    public int getDisplayHideDoneTask() {
        String result = this.getXmlElementText("/themis/project/display/hidedonetask", "2");
        return Integer.parseInt(result);
    }

    public void setDisplayHideDoneTask(int option) {
        if (option < 0 || option > 2) {
            option = 0;
        }
        Element e = this.getXmlElement("/themis/project/display/hidedonetask", true);
        e.setText(Integer.toString(option));
    }

    public String getEmailRecipient() {
        String result = this.getXmlAttribute("/themis/project/email/send/@recipient", "");
        return result;
    }

    public void setEmailRecipient(String recipient) {
        Element e = this.getXmlElement("/themis/project/email/send", true);
        e.setAttribute("recipient", recipient == null ? "" : recipient);
    }

    public EmailSendThread getEmailSender() {
        String smtp = this.getXmlElementText("/themis/system/email/smtp", "");
        int port = Util.parseInt((String)this.getXmlElementText("/themis/system/email/port", ""), (int)587);
        int encrypt = Util.parseInt((String)this.getXmlElementText("/themis/system/email/encrypt", ""), (int)1);
        String emailfrom = this.getXmlElementText("/themis/system/email/from", "");
        String emailbcc = this.getXmlElementText("/themis/system/email/bcc", "");
        return new EmailSendThread().setServer(smtp, port, encrypt).setBcc(emailbcc).setFrom(emailfrom);
    }

    public void setEmailSender(EmailSendThread email) {
        Element e = this.getXmlElement("/themis/system/email", true);
        e.removeContent();
        e.addContent((Content)new Element("smtp").setText(email.getSmtp()));
        e.addContent((Content)new Element("port").setText(Integer.toString(email.getPort())));
        e.addContent((Content)new Element("encrypt").setText(Integer.toString(email.getEncryption())));
        e.addContent((Content)new Element("from").setText(email.getFrom()));
        e.addContent((Content)new Element("bcc").setText(email.getBcc()));
    }

    public void setEmail(String smtp, String port, int encrypt, String from, String bcc) {
        Element e = this.getXmlElement("/themis/system/email", true);
        e.removeContent();
        e.addContent((Content)new Element("smtp").setText(smtp));
        e.addContent((Content)new Element("port").setText(port));
        e.addContent((Content)new Element("encrypt").setText(Integer.toString(encrypt)));
        e.addContent((Content)new Element("from").setText(from));
        e.addContent((Content)new Element("bcc").setText(bcc));
    }

    public int getEmailPort() {
        return Util.parseInt((String)this.getXmlElementText("/themis/system/email/port", ""), (int)587);
    }

    public String getEmailSmtp() {
        return this.getXmlElementText("/themis/system/email/smtp", "");
    }

    public int getEmailEncrypt() {
        return Util.parseInt((String)this.getXmlElementText("/themis/system/email/encrypt", ""), (int)1);
    }

    public String getEmailFrom() {
        return this.getXmlElementText("/themis/system/email/from", "");
    }

    public String getEmailBcc() {
        return this.getXmlElementText("/themis/system/email/bcc", "");
    }

    public ThemisSettingsFileElement getFolderReportTemplate() {
        return this.folderReportTemplate;
    }

    public ThemisSettingsFileElement getFolderReportOutput() {
        return this.folderReportOutput;
    }

    public boolean getReportOutputWithSubfolder() {
        return this.getXmlElementText("/themis/project/reportspec/export/withsubfolder", "false").equals("true");
    }

    public void setReportOutputWithSubfolder(boolean flg) {
        Element e = this.getXmlElement("/themis/project/reportspec/export/withsubfolder", true);
        e.setText(flg ? "true" : "false");
    }

    public ThemisSettingsFileElement getFolderOpenProject() {
        return this.folderOpenProject;
    }

    public ThemisSettingsFileElement getFolderProjectRoot() {
        return this.folderProjectRoot;
    }

    public ThemisSettingsFileElement getFolderDemoUnpack() {
        return this.folderDemoUnpack;
    }

    public ThemisSettingsFileElement getFolderProjectTemplate() {
        return this.folderProjectTemplate;
    }

    public ThemisSettingsFileElement getFolderThemisIO() {
        return this.folderThemisIO;
    }

    public ThemisSettingsFileElement getFolderImageObserver() {
        return this.folderImageObserver;
    }

    public static String getFolderImageObserverDefault() {
        String[] options;
        for (String option : options = new String[]{"c:\\Users\\%user%\\OneDrive\\Bilder\\Eigene Aufnahmen", "c:\\Users\\%user%\\OneDrive\\Pictures\\Camera Roll", "c:\\Users\\%user%\\Pictures\\Camera Roll"}) {
            String fn = option.replaceAll("%user%", System.getProperty("user.name"));
            File f = new File(fn);
            if (!f.exists()) continue;
            return option;
        }
        return "c:\\Users\\%user%\\Pictures\\Camera Roll";
    }

    public ThemisSettingsFileElement getFolderPlanImport() {
        return this.folderPlanImport;
    }

    public File getFileStatisticsPdf() {
        Element element = this.getXmlElement("/themis/project/files/statisticspdf", false);
        if (element != null) {
            return new File(element.getText());
        }
        return null;
    }

    public void setFileStatisticsPdf(File f) {
        this.getXmlElement("/themis/project/files/statisticspdf", true).setText(f == null ? null : f.getAbsolutePath());
    }

    public ArrayList<ThemisAttributeManager> getAttributeManager() {
        ArrayList<ThemisAttributeManager> result = new ArrayList<ThemisAttributeManager>();
        result.add(this.getObservationTemplateAttributeManager());
        result.add(this.getObservationHistoryAttributeManager());
        result.add(this.getObservationAttributeManager());
        result.add(this.getLocationAttributeManager());
        result.add(this.getProjectAttributeManager());
        result.add(this.getEventAttributeManager());
        result.add(this.getContactAttributeManager());
        result.add(this.getGroupAttributeManager());
        result.add(this.getMeasureAttributeManager());
        return result;
    }

    public ThemisAttributeManager getAttributeManager(String elementtype) {
        switch (elementtype) {
            case "observationtemplate": {
                return this.getObservationTemplateAttributeManager();
            }
            case "history": {
                return this.getObservationHistoryAttributeManager();
            }
            case "observation": {
                return this.getObservationAttributeManager();
            }
            case "locationtemplate": 
            case "location": {
                return this.getLocationAttributeManager();
            }
            case "project": {
                return this.getProjectAttributeManager();
            }
            case "event": {
                return this.getEventAttributeManager();
            }
            case "company": {
                return this.getContactAttributeManager();
            }
            case "locationgroup": {
                return this.getGroupAttributeManager();
            }
            case "measuretemplate": {
                return this.getMeasureAttributeManager();
            }
        }
        return null;
    }

    public ThemisAttributeManager getLocationAttributeManager() {
        return this.locationAttributeManager;
    }

    public ThemisAttributeManager getObservationAttributeManager() {
        return this.observationAttributeManager;
    }

    public ThemisAttributeManager getObservationTemplateAttributeManager() {
        return this.observationTemplateAttributeManager;
    }

    public ThemisAttributeManager getObservationHistoryAttributeManager() {
        return this.observationHistoryAttributeManager;
    }

    public ThemisAttributeManager getProjectAttributeManager() {
        return this.projectAttributeManager;
    }

    public ThemisAttributeManager getEventAttributeManager() {
        return this.eventAttributeManager;
    }

    public ThemisAttributeManager getContactAttributeManager() {
        return this.contactAttributeManager;
    }

    public ThemisAttributeManager getGroupAttributeManager() {
        return this.groupAttributeManager;
    }

    public ThemisAttributeManager getMeasureAttributeManager() {
        return this.measureAttributeManager;
    }

    public void initialiseAttributes(ThemisApplication app) {
        this.initialiseLocationAttributes(app);
        this.initialiseObservationAttributes(app);
    }

    private void initialiseLocationAttributes(ThemisApplication app) {
        if (this.locationAttributeMap == null) {
            this.locationAttributeMap = new HashMap();
        }
        this.locationAttributes.clear();
        if (this.locationAttributes == null) {
            this.locationAttributes = new ArrayList();
        }
        this.locationAttributes.clear();
        this.locationAttributesUsed.clear();
        this.addLocationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_GROUP, "locationgroup", "locationgroup", this.project.getResourceText("attribute.location.locationgroup"), ThemisAttribute.Edit.DIALOG_ONLY, false, 80), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_PREFIXSUFFIX, "", null, this.project.getResourceText("attribute.location.prefix"), ThemisAttribute.Edit.DIALOG_ONLY, false, 0).setObsListAllowed(false), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_SUFFIX, "", null, this.project.getResourceText("attribute.location.suffix"), ThemisAttribute.Edit.DIALOG_ONLY, false, 0), false);
        this.addLocationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.LOCATION, "number", "number", "locnumber", this.project.getResourceText("attribute.location.number"), ThemisAttribute.Edit.DIALOG_ONLY, false, 40).setAlwaysUsed(), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, "title", "title", "location", this.project.getResourceText("attribute.location.title"), ThemisAttribute.Edit.DIALOG_ONLY, false, 125).setAlwaysUsed(), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_BARCODE, ATT_LOC_BARCODE, ATT_LOC_BARCODE, this.project.getResourceText("attribute.location.barcode"), ThemisAttribute.Edit.DIALOG_ONLY, false, 75), false);
        this.addLocationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_ICON, ATT_LOC_ICON, null, this.project.getResourceText("attribute.location.icon"), ThemisAttribute.Edit.DIALOG_ONLY, false, 0), false);
        this.addLocationAttribute(new ThemisComplexAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_SIZE, "", null, this.project.getResourceText("attribute.location.measurement"), ThemisAttribute.Edit.DIALOG_ONLY, false, 50), false);
        this.addLocationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.LOCATION, "quantity", "quantity", "locquantity", this.project.getResourceText("attribute.location.quantity"), ThemisAttribute.Edit.DIALOG_ONLY, false, 60), false);
        this.addLocationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.LOCATION, "description", "description", "description", this.project.getResourceText("attribute.location.description"), ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addLocationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.LOCATION, "longtext1", "longtext1", "loclongtext1", this.project.getResourceText("attribute.location.longtext") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addLocationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.LOCATION, "longtext2", "longtext2", "loclongtext2", this.project.getResourceText("attribute.location.longtext") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addLocationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_LONGTEXT3, ATT_LOC_LONGTEXT3, "loclongtext3", this.project.getResourceText("attribute.location.longtext") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addLocationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_LONGTEXT4, ATT_LOC_LONGTEXT4, "loclongtext4", this.project.getResourceText("attribute.location.longtext") + " 4", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, "text1", "code", "loccode", this.project.getResourceText("attribute.location.text") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, "text2", "code2", "code2", this.project.getResourceText("attribute.location.text") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, "text3", "text3", "loctext3", this.project.getResourceText("attribute.location.text") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.LOCATION, "text4", "text4", "loctext4", this.project.getResourceText("attribute.location.text") + " 4", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.LOCATION, "list1", "list1", "list1", this.project.getResourceText("attribute.location.list") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.LOCATION, "list2", "list2", "list2", this.project.getResourceText("attribute.location.list") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.LOCATION, "list3", "list3", "loclist3", this.project.getResourceText("attribute.location.list") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_LIST4, ATT_LOC_LIST4, "loclist4", this.project.getResourceText("attribute.location.list") + " 4", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addLocationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_DATE1, ATT_LOC_DATE1, "locdate1", this.project.getResourceText("attribute.location.date") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 75), false);
        this.addLocationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_DATE2, ATT_LOC_DATE2, "locdate2", this.project.getResourceText("attribute.location.date") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 75), false);
        this.addLocationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_DATE3, ATT_LOC_DATE3, "locdate2", this.project.getResourceText("attribute.location.date") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 75), false);
        this.addLocationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_DATE4, ATT_LOC_DATE4, "locdate2", this.project.getResourceText("attribute.location.date") + " 4", ThemisAttribute.Edit.DIALOG_ONLY, true, 75), false);
        this.addLocationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_BOOLEAN1, ATT_LOC_BOOLEAN1, "locboolean1", this.project.getResourceText("attribute.location.flag") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 55), false);
        this.addLocationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_BOOLEAN2, ATT_LOC_BOOLEAN2, "locboolean2", this.project.getResourceText("attribute.location.flag") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 55), false);
        this.addLocationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_BOOLEAN3, ATT_LOC_BOOLEAN3, "locboolean3", this.project.getResourceText("attribute.location.flag") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 55), false);
        this.addLocationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_BOOLEAN4, ATT_LOC_BOOLEAN4, "locboolean4", this.project.getResourceText("attribute.location.flag") + " 4", ThemisAttribute.Edit.DIALOG_ONLY, true, 55), false);
        this.addLocationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_PLAN, "", "plantitle", this.project.getResourceText("attribute.location.plan"), ThemisAttribute.Edit.DIALOG_ONLY, false, 100).setVirtual(true), false);
        this.addLocationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_POSITION, ATT_LOC_POSITION, ATT_LOC_POSITION, this.project.getResourceText("attribute.location.position"), ThemisAttribute.Edit.DIALOG_ONLY, false, 50).setVirtual(true).setObsListAllowed(false), false);
        this.addLocationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.LOCATION, ATT_LOC_SHOWALWAYS, ATT_LOC_SHOWALWAYS, null, this.project.getResourceText("attribute.location.showalways"), ThemisAttribute.Edit.DIALOG_ONLY, false, 15).setVirtual(true).setObsListAllowed(false), false);
        this.addLocationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.LOCATION, "hasimage", "", null, this.project.getResourceText("attribute.location.hasimage"), ThemisAttribute.Edit.DIALOG_ONLY, false, 15).setVirtual(true), false);
        this.addLocationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.LOCATION, "hasaudio", "", null, this.project.getResourceText("attribute.location.hasaudio"), ThemisAttribute.Edit.DIALOG_ONLY, false, 15).setVirtual(true), false);
        this.addLocationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.LOCATION, "documents", "infos", null, this.project.getResourceText("attribute.location.documents"), ThemisAttribute.Edit.DIALOG_ONLY, false, 15), false);
    }

    private void addLocationAttribute(ThemisAttribute a, boolean fixed) {
        this.locationAttributeMap.put(a.getId(), a);
        this.locationAttributes.add(a);
        if (fixed) {
            this.locationAttributesFixed.add(a);
        }
    }

    private void initialiseObservationAttributes(ThemisApplication app) {
        if (this.observationAttributeMap == null) {
            this.observationAttributeMap = new HashMap();
        }
        this.observationAttributes.clear();
        if (this.observationAttributes == null) {
            this.observationAttributes = new ArrayList();
        }
        this.observationAttributes.clear();
        this.observationAttributesUsed.clear();
        this.addObservationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_TYPE, ATT_OBS_TYPE, ATT_OBS_TYPE, this.project.getResourceText("attribute.observation.type"), ThemisAttribute.Edit.DIALOG_ONLY, false, 100).setAlwaysUsed().setVirtual(true), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, "title", "title", "observationtitle", this.project.getResourceText("attribute.observation.title"), ThemisAttribute.Edit.DIALOG_ONLY, false, 135).setAlwaysUsed(), false);
        this.addObservationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.OBSERVATION, "description", "description", "observationdescription", this.project.getResourceText("attribute.observation.description"), ThemisAttribute.Edit.DIALOG_ONLY, false, 120).setAlwaysUsed(), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_EDITOR, ATT_OBS_EDITOR, ATT_OBS_EDITOR, this.project.getResourceText("attribute.observation.editor"), ThemisAttribute.Edit.DIALOG_ONLY, false, 50).setVirtual(true), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, "quantity", "quantity", "quantity", this.project.getResourceText("attribute.observation.quantity"), ThemisAttribute.Edit.DIALOG_ONLY, true, 60), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, "text1", "code", "code", this.project.getResourceText("attribute.observation.text") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, "text2", "freetext1", "freetext1", this.project.getResourceText("attribute.observation.text") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, "text3", "freetext2", "freetext2", this.project.getResourceText("attribute.observation.text") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, "text4", "freetext3", "freetext3", this.project.getResourceText("attribute.observation.text") + " 4", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addObservationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.OBSERVATION, "longtext1", "langtext1", "langtext1", this.project.getResourceText("attribute.observation.longtext") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addObservationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.OBSERVATION, "longtext2", "langtext2", "langtext2", this.project.getResourceText("attribute.observation.longtext") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addObservationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_FLOAT1, ATT_OBS_FLOAT1, ATT_OBS_FLOAT1, this.project.getResourceText("attribute.observation.float") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addObservationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_FLOAT2, ATT_OBS_FLOAT2, ATT_OBS_FLOAT2, this.project.getResourceText("attribute.observation.float") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addObservationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_FLOAT3, ATT_OBS_FLOAT3, ATT_OBS_FLOAT3, this.project.getResourceText("attribute.observation.float") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addObservationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_FLOAT4, ATT_OBS_FLOAT4, ATT_OBS_FLOAT4, this.project.getResourceText("attribute.observation.float") + " 4", ThemisAttribute.Edit.DIALOG_ONLY, true, 120), false);
        this.addObservationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.OBSERVATION, "list1", "topic", "topic", this.project.getResourceText("attribute.observation.list") + " 1", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addObservationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.OBSERVATION, "list2", "observationtype", "observationtype", this.project.getResourceText("attribute.observation.list") + " 2", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addObservationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.OBSERVATION, "list3", "priority", "priority", this.project.getResourceText("attribute.observation.list") + " 3", ThemisAttribute.Edit.DIALOG_ONLY, true, 80), false);
        this.addObservationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_ASSESSMENT, "risk", "risk", this.project.getResourceText("attribute.observation.risk"), ThemisAttribute.Edit.DIALOG_ONLY, false, 65), false);
        this.addObservationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_RESPONSIBLE, ATT_OBS_RESPONSIBLE, "contactname", this.project.getResourceText("attribute.observation.responsible"), ThemisAttribute.Edit.DIALOG_ONLY, false, 90), false);
        this.addObservationAttribute(new ThemisLongtextAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_MEASURE, ATT_OBS_MEASURE, ATT_OBS_MEASURE, this.project.getResourceText("attribute.observation.measure"), ThemisAttribute.Edit.DIALOG_ONLY, false, 120), false);
        this.addObservationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_DUEDATE, ATT_OBS_DUEDATE, ATT_OBS_DUEDATE, this.project.getResourceText("attribute.observation.duedate"), ThemisAttribute.Edit.DIALOG_ONLY, false, 125).setChecklistAllowed(false), false);
        this.addObservationAttribute(new ThemisNumberAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_REPEAT, "repeatcount", "repeatcount", this.project.getResourceText("attribute.observation.repeat"), ThemisAttribute.Edit.DIALOG_ONLY, false, 125).setVirtual(true).setObsListAllowed(false), false);
        this.addObservationAttribute(new ThemisListAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_REPEATUNIT, ATT_OBS_REPEAT, ATT_OBS_REPEAT, this.project.getResourceText("attribute.observation.repeatunit"), ThemisAttribute.Edit.DIALOG_ONLY, false, 125).setVirtual(true).setObsListAllowed(false), false);
        this.addObservationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_DONE, ATT_OBS_DONE, ATT_OBS_DONE, this.project.getResourceText("attribute.observation.done"), ThemisAttribute.Edit.DIALOG_ONLY, false, 65), false);
        this.addObservationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_DONEDATE, ATT_OBS_DONEDATE, ATT_OBS_DONEDATE, this.project.getResourceText("attribute.observation.donedate"), ThemisAttribute.Edit.DIALOG_ONLY, false, 15).setVirtual(true), false);
        this.addObservationAttribute(new ThemisBooleanAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_CONTROL, ATT_OBS_CONTROL, ATT_OBS_CONTROL, this.project.getResourceText("attribute.observation.control"), ThemisAttribute.Edit.DIALOG_ONLY, false, 15).setVirtual(true), false);
        this.addObservationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_CONTROLDATE, "referencedate", "referencedate", this.project.getResourceText("attribute.observation.referencedate"), ThemisAttribute.Edit.DIALOG_ONLY, false, 125).setVirtual(true), false);
        this.addObservationAttribute(new ThemisDateAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_CREATIONDATE, ATT_OBS_CREATIONDATE, "", this.project.getResourceText("attribute.observation.creationdate"), ThemisAttribute.Edit.DIALOG_ONLY, false, 50).setVirtual(true).setObsListAllowed(false), false);
        this.addObservationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.OBSERVATION, "documents", "infos", null, this.project.getResourceText("attribute.observation.documents"), ThemisAttribute.Edit.DIALOG_ONLY, false, 15).setChecklistAllowed(false), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, ATT_OBS_FULLNUMBER, "", ATT_OBS_FULLNUMBER, this.project.getResourceText("attribute.observation.fullnumber"), ThemisAttribute.Edit.DIALOG_ONLY, false, 3).setVirtual(true), false);
        this.addObservationAttribute(new ThemisTextAttribute(app, ThemisAttribute.Target.OBSERVATION, "number", "number", "observationnumber", this.project.getResourceText("attribute.observation.observationnumber"), ThemisAttribute.Edit.DIALOG_ONLY, false, 30).setVirtual(true).setObsListAllowed(false), false);
        this.addObservationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.OBSERVATION, "hasimage", "", "hasimage", this.project.getResourceText("attribute.observation.hasimage"), ThemisAttribute.Edit.DIALOG_ONLY, false, 60).setVirtual(true), false);
        this.addObservationAttribute(new ThemisRelationAttribute(app, ThemisAttribute.Target.OBSERVATION, "hasaudio", "", "hasaudio", this.project.getResourceText("attribute.observation.hasaudio"), ThemisAttribute.Edit.DIALOG_ONLY, false, 60).setVirtual(true), false);
        this.getObservationAttribute(ATT_OBS_DONEDATE).setInherit(this.getObservationAttribute(ATT_OBS_DONE));
        this.getObservationAttribute(ATT_OBS_REPEAT).setInherit(this.getObservationAttribute(ATT_OBS_DUEDATE));
        this.getObservationAttribute(ATT_OBS_REPEATUNIT).setInherit(this.getObservationAttribute(ATT_OBS_DUEDATE));
    }

    private void addObservationAttribute(ThemisAttribute a, boolean fixed) {
        this.observationAttributeMap.put(a.getId(), a);
        this.observationAttributes.add(a);
        if (fixed) {
            this.observationAttributesFixed.add(a);
        }
    }

    public ArrayList<ThemisAttribute> getAttributes(String elementtype) {
        switch (elementtype) {
            case "location": {
                return this.getLocationAttributesUsed();
            }
            case "observation": {
                return this.getObservationAttributesUsed();
            }
            case "event": {
                ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
                atts.add(new ThemisTextAttribute(this.app, ThemisAttribute.Target.EVENT, "title", "title", "title", "Titel", ThemisAttribute.Edit.DIALOG_ONLY, false, 100).setAlwaysUsed());
                atts.add(new ThemisDateAttribute(this.app, ThemisAttribute.Target.EVENT, "date", "date", "date", "Datum", ThemisAttribute.Edit.DIALOG_ONLY, false, 100).setAlwaysUsed());
                atts.add(new ThemisTextAttribute(this.app, ThemisAttribute.Target.EVENT, "time", "time", "time", "Zeit", ThemisAttribute.Edit.DIALOG_ONLY, false, 100).setAlwaysUsed());
                atts.addAll(this.eventAttributes);
                return atts;
            }
            case "project": {
                return this.projectAttributes;
            }
        }
        return new ArrayList<ThemisAttribute>();
    }

    public void addAttribute(String elementtype, ThemisAttribute ta) {
        ArrayList<ThemisAttribute> atts = null;
        switch (elementtype) {
            case "location": 
            case "observation": {
                return;
            }
            case "event": {
                atts = this.eventAttributes;
                break;
            }
            case "project": {
                atts = this.projectAttributes;
            }
        }
        if (atts != null) {
            atts.add(ta);
            ta.createDatabase();
        }
    }

    public void removeAttribute(ThemisAttribute ta) {
        switch (ta.getTarget()) {
            case LOCATION: 
            case OBSERVATION: {
                ta.setUsed(false);
                break;
            }
            case PROJECT: {
                this.projectAttributes.remove(ta);
                break;
            }
            case EVENT: {
                this.eventAttributes.remove(ta);
            }
        }
    }

    public void moveAttribute(ThemisAttribute ta, int dir) {
        switch (ta.getTarget()) {
            case OBSERVATION: {
                this.moveAttribute(this.observationAttributesUsed, ta, dir);
                break;
            }
            case LOCATION: {
                this.moveAttribute(this.locationAttributesUsed, ta, dir);
                break;
            }
            case PROJECT: {
                this.moveAttribute(this.projectAttributes, ta, dir);
                break;
            }
            case EVENT: {
                this.moveAttribute(this.eventAttributes, ta, dir);
            }
        }
    }

    public String getNextAttributeId(String elementtype, ThemisAttribute.Type t) {
        ArrayList<ThemisAttribute> tas = this.getAttributes(elementtype);
        int counter = 1;
        for (ThemisAttribute ta : tas) {
            if (!ta.isUserdefined() || !ta.getTypeId().equals((Object)t)) continue;
            ++counter;
        }
        return t.getCode() + counter;
    }

    public ThemisAttribute getLocationAttribute(String id) {
        return this.locationAttributeMap.get(id);
    }

    public ArrayList<ThemisAttribute> getLocationAttributes() {
        return this.locationAttributes;
    }

    public ArrayList<ThemisAttribute> getLocationAttributesUsed() {
        return this.locationAttributesUsed;
    }

    public ArrayList<ThemisAttribute> getLocationAttributesFixed() {
        return this.locationAttributesFixed;
    }

    public void moveLocationAttribute(ThemisAttribute ta, int dir) {
        this.moveAttribute(this.locationAttributesUsed, ta, dir);
    }

    public void setLocationAttributeUsage(ThemisAttribute ta, boolean isUsed) {
        this.setAttributeUsage(this.locationAttributesUsed, ta, isUsed);
    }

    public void setLocationAttributeUsage(String ... atts) {
        this.locationAttributesUsed.clear();
        for (ThemisAttribute ta : this.getLocationAttributes()) {
            ta.setUsed(false);
        }
        if (atts == null) {
            return;
        }
        for (String att : atts) {
            ThemisAttribute ta = this.getLocationAttribute(att);
            if (ta == null) continue;
            ta.setUsed(true);
        }
    }

    public ThemisAttribute getObservationAttribute(String id) {
        return this.observationAttributeMap.get(id);
    }

    public ArrayList<ThemisAttribute> getObservationAttributes() {
        return this.observationAttributes;
    }

    public ArrayList<ThemisAttribute> getObservationAttributesUsed() {
        return this.observationAttributesUsed;
    }

    public ArrayList<ThemisAttribute> getObservationAttributesFixed() {
        return this.observationAttributesFixed;
    }

    public void moveObservationAttribute(ThemisAttribute ta, int dir) {
        this.moveAttribute(this.observationAttributesUsed, ta, dir);
    }

    public void setObservationAttributeUsage(ThemisAttribute ta, boolean isUsed) {
        this.setAttributeUsage(this.observationAttributesUsed, ta, isUsed);
    }

    public void setObservationAttributeUsage(String ... atts) {
        this.observationAttributesUsed.clear();
        for (ThemisAttribute ta : this.getObservationAttributes()) {
            ta.setUsed(false);
        }
        if (atts == null) {
            return;
        }
        for (String att : atts) {
            ThemisAttribute ta = this.getObservationAttribute(att);
            if (ta == null) continue;
            ta.setUsed(true);
        }
    }

    public void moveAttribute(ArrayList<ThemisAttribute> attributesUsed, ThemisAttribute ta, int dir) {
        int idx = attributesUsed.indexOf(ta);
        if (idx < 0) {
            return;
        }
        if (dir < 0) {
            if (idx == 0) {
                return;
            }
            attributesUsed.remove(idx);
            attributesUsed.add(idx - 1, ta);
        } else {
            if (idx >= attributesUsed.size()) {
                return;
            }
            attributesUsed.remove(idx);
            attributesUsed.add(idx + 1, ta);
        }
    }

    private void setAttributeUsage(ArrayList<ThemisAttribute> attributesUsed, ThemisAttribute ta, boolean isUsed) {
        if (!ta.isUserdefined()) {
            return;
        }
        if (!isUsed) {
            attributesUsed.remove(ta);
            ArrayList<ThemisAttribute> toBeRemoved = new ArrayList<ThemisAttribute>();
            for (ThemisAttribute ta2 : attributesUsed) {
                if (!ta.getId().equals(ta2.getId())) continue;
                toBeRemoved.add(ta2);
            }
            for (ThemisAttribute ta2 : toBeRemoved) {
                attributesUsed.remove(ta2);
            }
        } else {
            for (ThemisAttribute ta2 : attributesUsed) {
                if (!ta.getId().equals(ta2.getId())) continue;
                return;
            }
            attributesUsed.add(ta);
        }
    }

    public ThemisAttribute getAttribute(String attributeCode) {
        String[] attcode = attributeCode.split("\\.");
        if (attcode.length == 2) {
            return this.getAttribute(attcode[0], attcode[1]);
        }
        return null;
    }

    public ThemisAttribute getAttribute(String elementtype, String code) {
        switch (elementtype) {
            case "observation": {
                switch (code) {
                    case "topic": {
                        return this.getObservationAttribute("list1");
                    }
                    case "observationtype": {
                        return this.getObservationAttribute("list2");
                    }
                    case "priority": {
                        return this.getObservationAttribute("list3");
                    }
                }
                return this.getObservationAttribute(code);
            }
            case "location": {
                switch (code) {
                    case "code": {
                        return this.getLocationAttribute("text1");
                    }
                    case "code2": {
                        return this.getLocationAttribute("text2");
                    }
                }
                return this.getLocationAttribute(code);
            }
        }
        return null;
    }

    public String getLocationListSortAttribute() {
        return this.getXmlElementText("/themis/project/attributes/locationlist/sort", "number");
    }

    public void setLocationListSortAttribute(String setting) {
        Element e = this.getXmlElement("/themis/project/attributes/locationlist/sort", true);
        e.setText(setting == null || "".equals(setting) ? "*" : setting);
    }

    public String getLocationListContentLeft() {
        return this.getXmlElementText("/themis/project/attributes/locationlist/contentleft", "#!#G.Plan#!#");
    }

    public String getLocationListTitleLeft() {
        return this.getXmlAttribute("/themis/project/attributes/locationlist/contentleft/@title", "Plan");
    }

    public void setLocationListContentLeft(String title, String setting) {
        Element e = this.getXmlElement("/themis/project/attributes/locationlist/contentleft", true);
        e.setText(setting == null || "".equals(setting) ? "*" : setting);
        e.setAttribute("title", title);
    }

    public String getLocationListContentRight() {
        return this.getXmlElementText("/themis/project/attributes/locationlist/contentright", "#!#G.Gruppe#!#");
    }

    public String getLocationListTitleRight() {
        return this.getXmlAttribute("/themis/project/attributes/locationlist/contentright/@title", "Gruppe");
    }

    public void setLocationListContentRight(String title, String setting) {
        Element e = this.getXmlElement("/themis/project/attributes/locationlist/contentright", true);
        e.setText(setting == null || "".equals(setting) ? "*" : setting);
        e.setAttribute("title", title);
    }

    public ArrayList<ThemisAttribute> getObservationTableAttributes() {
        Element e = this.getXmlElement("/themis/project/attributes/observationtable", true);
        String attsStr = e.getChildText("columns");
        String[] atts = attsStr == null ? new String[]{} : attsStr.split(" ");
        ArrayList<String> attsList = new ArrayList<String>();
        for (String att : atts) {
            if (attsList.contains(att)) continue;
            attsList.add(att);
        }
        List columns = e.getChildren("column");
        ThemisAttribute ta = null;
        HashMap<String, ThemisAttribute> map = new HashMap<String, ThemisAttribute>();
        for (Element column : columns) {
            try {
                String type = column.getAttributeValue(ATT_OBS_TYPE);
                String id = column.getAttributeValue("id");
                if ("location".equalsIgnoreCase(type)) {
                    ta = this.getLocationAttribute(id);
                } else if ("observation".equalsIgnoreCase(type)) {
                    ta = this.getObservationAttribute(id);
                }
                if (ta == null || ta.getSqlCode() == null) continue;
                ta.setWidthInTable(column.getAttribute("width").getIntValue());
                map.put(ta.getTargetLetter(true) + ta.getId(), ta);
            }
            catch (DataConversionException ex) {
                Logger.getLogger(ThemisSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ArrayList<ThemisAttribute> result = new ArrayList<ThemisAttribute>();
        for (String id : attsList) {
            ThemisAttribute taResult = (ThemisAttribute)map.get(id);
            if (taResult == null) continue;
            result.add(taResult);
        }
        return result;
    }

    public void clearObservationTableAttributes() {
        Element e = this.getXmlElement("/themis/project/attributes/observationtable", true);
        e.removeChildren("column");
        e.removeChildren("columns");
        ThemisApplication.getInstance().getFilter().updateObservationListAttributes();
    }

    public void setObservationTableAttributes(ArrayList<ThemisAttribute> attributes) {
        Element e = this.getXmlElement("/themis/project/attributes/observationtable", true);
        e.removeChildren("column");
        e.removeChildren("columns");
        StringBuilder atts = new StringBuilder();
        for (ThemisAttribute ta : attributes) {
            if (ta == null) continue;
            e.addContent((Content)new Element("column").setAttribute(ATT_OBS_TYPE, ta.getTargetCode()).setAttribute("id", ta.getId()).setAttribute("width", Integer.toString(ta.getWidthInTable())));
            atts.append(ta.getTargetLetter(true)).append(ta.getId()).append(" ");
        }
        e.addContent((Content)new Element("columns").setText(atts.toString()));
        ThemisApplication.getInstance().getFilter().updateObservationListAttributes();
    }

    public void addObservationTableAttributes(String type, String id) {
        ThemisAttribute ta = null;
        if ("location".equalsIgnoreCase(type)) {
            ta = this.getLocationAttribute(id);
        } else if ("observation".equalsIgnoreCase(type)) {
            ta = this.getObservationAttribute(id);
        }
        this.addObservationTableAttributes(ta);
        ThemisApplication.getInstance().getFilter().updateObservationListAttributes();
    }

    public void addObservationTableAttributes(ThemisAttribute ta) {
        if (ta != null) {
            Element e = this.getXmlElement("/themis/project/attributes/observationtable", true);
            String atts = e.getChildText("columns");
            if (atts == null) {
                atts = "";
            }
            ArrayList<String> attsList = new ArrayList<String>();
            for (String att : atts.split(" ")) {
                attsList.add(att);
            }
            e.addContent((Content)new Element("column").setAttribute(ATT_OBS_TYPE, ta.getTargetCode()).setAttribute("id", ta.getId()).setAttribute("width", Integer.toString(ta.getWidthInTable())));
            String attCode = ta.getTargetLetter(true) + ta.getId();
            if (!attsList.contains(attCode)) {
                atts = atts + attCode + " ";
            }
            e.removeChildren("columns");
            e.addContent((Content)new Element("columns").setText(atts.toString()));
        }
        ThemisApplication.getInstance().getFilter().updateObservationListAttributes();
    }

    public void moveObservationTableAttributes(ThemisAttribute ta, int toindex) {
        ArrayList<ThemisAttribute> attributes = this.getObservationTableAttributes();
        int idx = attributes.indexOf(ta);
        if (--toindex > idx) {
            --toindex;
        }
        attributes.remove(ta);
        if (toindex < 0 || toindex > attributes.size()) {
            return;
        }
        if (toindex == attributes.size()) {
            attributes.add(ta);
        } else {
            attributes.add(toindex, ta);
        }
        this.setObservationTableAttributes(attributes);
        this.save();
    }

    public void setObservationTableColumnWidth(ThemisAttribute ta, int newwidth) {
        String path = "/themis/project/attributes/observationtable/column[@type='" + ta.getTargetCode() + "' and @id='" + ta.getId() + "']";
        Element e = null;
        try {
            e = (Element)XPath.selectSingleNode((Object)this.settings.getRootElement(), (String)path);
        }
        catch (JDOMException ex) {
            this.project.getLogger().severe("Error accessing settings using path '" + path + "'");
        }
        if (e != null) {
            e.setAttribute("width", Integer.toString(newwidth));
            ta.setWidthInTable(newwidth);
        }
    }

    public ThemisColor getObservationColorSelect() {
        String background = this.getXmlAttribute("/themis/system/observationtable/color/select/@background", "0,0,255");
        String foreground = this.getXmlAttribute("/themis/system/observationtable/color/select/@text", "255,255,255");
        return new ThemisColor(background, foreground);
    }

    public void setObservationColorSelect(ThemisColor c) {
        Element e = this.getXmlElement("/themis/system/observationtable/color/select", true);
        e.setAttribute("background", c.getBackgroundAsString());
        e.setAttribute("text", c.getForegroundAsString());
    }

    public ThemisColor getObservationColorChecked() {
        String background = this.getXmlAttribute("/themis/system/observationtable/color/checked/@background", "85,219,108");
        String foreground = this.getXmlAttribute("/themis/system/observationtable/color/checked/@text", "255,255,255");
        return new ThemisColor(background, foreground);
    }

    public void setObservationColorChecked(ThemisColor c) {
        Element e = this.getXmlElement("/themis/system/observationtable/color/checked", true);
        e.setAttribute("background", c.getBackgroundAsString());
        e.setAttribute("text", c.getForegroundAsString());
    }

    public boolean getDoCreateNewObservationWithLocation() {
        return "true".equals(this.getXmlElementText("/themis/project/edit/createemptyobservation", "false"));
    }

    public void setDoCreateNewObservationWithLocation(boolean f) {
        Element e = this.getXmlElement("/themis/project/edit/createemptyobservation", true);
        e.setText(f ? "true" : "false");
    }

    public boolean getDoFilterSelectedLocation() {
        return "true".equals(this.getXmlElementText("/themis/project/observationtable/locationasfilter", "false"));
    }

    public void setDoFilterSelectedLocation(boolean f) {
        Element e = this.getXmlElement("/themis/project/observationtable/locationasfilter", true);
        e.setText(f ? "true" : "false");
    }

    public void setDefaultReportLayout(Element reportspec) {
        this.getXmlElement("/themis/project/report/default", true).removeContent();
        this.getXmlElement("/themis/project/report/default", true).addContent((Content)reportspec);
    }

    public Element getDefaultReportLayout() {
        List children = this.getXmlElement("/themis/project/report/default", true).getChildren();
        return children.isEmpty() ? null : (Element)((Element)children.get(0)).detach();
    }

    public long getLastReportLayoutId() {
        long id = Util.parseLong((String)this.getXmlElementText("/themis/project/report/lastid", "-1"), (long)-1L);
        return id == 0L ? -1L : id;
    }

    public void setLastReportLayoutId(long id) {
        Element e = this.getXmlElement("/themis/project/report/lastid", true);
        e.setText(Long.toString(id));
    }

    public boolean getDoAutoGenerateEvent() {
        return "true".equals(this.getXmlElementText("/themis/project/event/autogenerate", "false"));
    }

    public void setDoAutoGenerateEvent(boolean f) {
        Element e = this.getXmlElement("/themis/project/event/autogenerate", true);
        e.setText(f ? "true" : "false");
    }

    public boolean getNotificationNoEventInfo() {
        return "true".equals(this.getXmlElementText("/themis/system/notification/noeventinfo", "true"));
    }

    public void setNotificationNoEventInfo(boolean f) {
        Element e = this.getXmlElement("/themis/system/notification/noeventinfo", true);
        e.setText(f ? "true" : "false");
    }

    public boolean getNotificationShowStartScreen() {
        return "true".equals(this.getXmlElementText("/themis/system/notification/showstartscreen", "true"));
    }

    public void setNotificationShowStartScreen(boolean f) {
        Element e = this.getXmlElement("/themis/system/notification/showstartscreen", true);
        e.setText(f ? "true" : "false");
    }

    public boolean getNotificationDueTasks() {
        return "true".equals(this.getXmlElementText("/themis/system/notification/duetasks", "true"));
    }

    public void setNotificationDueTasks(boolean f) {
        Element e = this.getXmlElement("/themis/system/notification/duetasks", true);
        e.setText(f ? "true" : "false");
    }

    public boolean getNotificationNetworkDrive() {
        return "true".equals(this.getXmlElementText("/themis/system/notification/networkdrive", "true"));
    }

    public void setNotificationNetworkDrive(boolean f) {
        Element e = this.getXmlElement("/themis/system/notification/networkdrive", true);
        e.setText(f ? "true" : "false");
    }

    public boolean getWindowPhotoViewerMinimised() {
        return "true".equals(this.getXmlElementText("/themis/system/window/photoviewerminimised", "false"));
    }

    public void setWindowPhotoViewerMinimised(boolean b) {
        Element e = this.getXmlElement("/themis/system/window/photoviewerminimised", true);
        e.setText(b ? "true" : "false");
    }

    public boolean getDoMonthlyDatabaseBackup() {
        return "true".equals(this.getXmlElementText("/themis/system/backup/database", "false"));
    }

    public void setDoMonthlyDatabaseBackup(boolean f) {
        Element e = this.getXmlElement("/themis/system/backup/database", true);
        e.setText(f ? "true" : "false");
    }

    public int getDisplayTextareaSize() {
        return Util.parseInt((String)this.getXmlAttribute("/themis/system/display/textarea/@rows", "7"), (int)7);
    }

    public void setDisplayTextareaSize(int rows) {
        if (rows < 1) {
            rows = 7;
        }
        if (rows > 15) {
            rows = 15;
        }
        Element e = this.getXmlElement("/themis/system/display/textarea", true);
        e.setAttribute("rows", Integer.toString(rows));
    }

    public int getCurrentCamera() {
        return Util.parseInt((String)this.getXmlElementText("/themis/system/camera", "0"), (int)0);
    }

    public void setCurrentCamera(int cam) {
        Element e = this.getXmlElement("/themis/system/camera", true);
        e.setText(Integer.toString(cam));
    }

    public void setExportThemis(Element reportspec) {
        this.getXmlElement("/themis/project/export", true).removeChildren(reportspec.getName());
        this.getXmlElement("/themis/project/export", true).addContent((Content)reportspec);
    }

    public Element getExportThemis() {
        return this.getXmlElement("/themis/project/export/themis", true);
    }

    public void setImportMapping(HashMap<Integer, AttributeReference> mapping) {
        Element e = this.getXmlElement("/themis/project/import", true);
        e.removeChildren("mapping");
        for (int idx : mapping.keySet()) {
            String k = Integer.toString(idx);
            String att = mapping.get(idx).getCode();
            e.addContent((Content)new Element("mapping").setAttribute("key", k).setAttribute("attribute", att));
        }
    }

    public HashMap<Integer, AttributeReference> getImportMapping() {
        HashMap<Integer, AttributeReference> result = new HashMap<Integer, AttributeReference>();
        List mappings = this.getXmlElement("/themis/project/import", true).getChildren("mapping");
        for (Element mapping : mappings) {
            int key = Util.parseInt((String)mapping.getAttributeValue("key"), (int)-1);
            String val = mapping.getAttributeValue("attribute");
            AttributeReference ar = null;
            switch (val) {
                case "observation.uuid": {
                    ar = new AttributeReference("observation", "uuid", "UUID");
                    break;
                }
                case "location.uuid": {
                    ar = new AttributeReference("location", "uuid", "UUID");
                    break;
                }
                case "observation.type": {
                    ar = new AttributeReference("observation", ATT_OBS_TYPE, "Beobachtungstyp");
                    break;
                }
                default: {
                    ThemisAttribute att = this.getAttribute(val);
                    if (key < 0 || att == null) break;
                    ar = new AttributeReference(att);
                }
            }
            if (ar == null) continue;
            result.put(key, ar);
        }
        return result;
    }

    public String getImportRowHeader() {
        return this.getXmlElementText("/themis/project/import/rowheader", "1");
    }

    public void setImportRowHeader(String row) {
        Element e = this.getXmlElement("/themis/project/import/rowheader", true);
        e.setText(row);
    }

    public String getImportRowData() {
        return this.getXmlElementText("/themis/project/import/rowdata", "2");
    }

    public void setImportRowData(String row) {
        Element e = this.getXmlElement("/themis/project/import/rowdata", true);
        e.setText(row);
    }

    public String getExportRowData() {
        return this.getXmlElementText("/themis/project/export/rowdata", "1");
    }

    public void setExportRowData(String row) {
        Element e = this.getXmlElement("/themis/project/export/rowdata", true);
        e.setText(row);
    }

    public void setExportAttributes(ArrayList<String> fieldsGroup, ArrayList<String> fieldsUsed, Properties groupFunction) {
        Element e = this.getXmlElement("/themis/project/export/placeholders", true);
        e.removeChildren("placeholder");
        boolean withGroups = !fieldsGroup.isEmpty();
        for (String ta : fieldsGroup) {
            e.addContent((Content)new Element("placeholder").setText(ta).setAttribute(ATT_LOC_GROUP, "G"));
        }
        for (String ta : fieldsUsed) {
            e.addContent((Content)new Element("placeholder").setText(ta).setAttribute(ATT_LOC_GROUP, groupFunction.getProperty(ta, "1")));
        }
    }

    public void clearExportAttributes() {
        Element e = this.getXmlElement("/themis/project/export/placeholders", true);
        e.removeChildren("placeholder");
    }

    public ArrayList<String> getExportAttributesGroup() {
        Element e = this.getXmlElement("/themis/project/export/placeholders", true);
        ArrayList<String> placeholders = new ArrayList<String>();
        List phs = e.getChildren("placeholder");
        for (Element ph : phs) {
            if (!"G".equals(ph.getAttributeValue(ATT_LOC_GROUP))) continue;
            placeholders.add(ph.getText());
        }
        return placeholders;
    }

    public ArrayList<String> getExportAttributesUsed() {
        Element e = this.getXmlElement("/themis/project/export/placeholders", true);
        ArrayList<String> placeholders = new ArrayList<String>();
        List phs = e.getChildren("placeholder");
        for (Element ph : phs) {
            if ("G".equals(ph.getAttributeValue(ATT_LOC_GROUP))) continue;
            placeholders.add(ph.getText());
        }
        return placeholders;
    }

    public Properties getExportAttributesGroupFunction() {
        Element e = this.getXmlElement("/themis/project/export/placeholders", true);
        Properties props = new Properties();
        List phs = e.getChildren("placeholder");
        for (Element ph : phs) {
            String gf = ph.getAttributeValue(ATT_LOC_GROUP, "");
            switch (gf.toLowerCase()) {
                case "g": {
                    break;
                }
                case "s": 
                case "n": {
                    props.setProperty(ph.getText(), gf);
                }
            }
        }
        return props;
    }

    public String getCsvSeparator() {
        return this.getXmlElementText("/themis/project/export/csv/separator", ";");
    }

    public void setCsvSeparator(String separator) {
        Element e = this.getXmlElement("/themis/project/export/csv/separator", true);
        e.setText(separator);
    }

    public ThemisSettingsFileElement getExportTemplateFile() {
        return this.fileExportTemplate;
    }

    public ThemisSettingsFileElement getExportFolder() {
        return this.folderExport;
    }

    public void setUpdatePauseUntil(int days) {
        Element e = this.getXmlElement("/themis/system/update", true);
        e.removeChild("pauseuntil");
        if (days > 0) {
            Date dt = new Date();
            dt.setTime(dt.getTime() + (long)days * 86400000L);
            e.addContent((Content)new Element("pauseuntil").setText(Util.formatDate((Date)dt, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone())));
        }
    }

    public Date getUpdatePauseUntil() {
        String txt = this.getXmlElementText("/themis/system/update/pauseuntil", null);
        return txt == null ? null : Util.parseDate((String)txt, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone(), null);
    }

    public UpdateMethod getUpdateMethod() {
        String txt;
        switch (txt = this.getXmlElementText("/themis/system/update/method", "installer")) {
            case "installer": {
                return UpdateMethod.INSTALLER;
            }
            case "module": {
                return UpdateMethod.MODULE;
            }
            case "zip": {
                return UpdateMethod.ZIP;
            }
        }
        return UpdateMethod.INSTALLER;
    }

    public void setUpdateMethod(UpdateMethod m) {
        switch (m) {
            case INSTALLER: {
                this.getXmlElement("/themis/system/update/method", true).setText("installer");
                break;
            }
            case MODULE: {
                this.getXmlElement("/themis/system/update/method", true).setText("module");
                break;
            }
            case ZIP: {
                this.getXmlElement("/themis/system/update/method", true).setText("zip");
            }
        }
    }

    public boolean useElementCache() {
        return this.getXmlElementText("/themis/project/other/cache", "false").equals("true");
    }

    public void setElementCache(boolean flg) {
        Element e = this.getXmlElement("/themis/project/other/cache", true);
        e.setText(flg ? "true" : "false");
    }

    public String getTerm(Term t) {
        return this.getXmlElementText("/themis/project/terms/" + this.getTermCode(t), this.getTermDefault(t));
    }

    public void setTerm(Term t, String v) {
        Element e = this.getXmlElement("/themis/project/terms/" + this.getTermCode(t), true);
        e.setText(v);
    }

    private String getTermDefault(Term t) {
        switch (t) {
            case StatusErledigt: {
                return this.project.getResourceText("text.status-erledigt-default");
            }
            case StatusOffen: {
                return this.project.getResourceText("text.status-offen-default");
            }
            case TextNoContent: {
                return "-";
            }
            case TextNoEvent: {
                return this.project.getResourceText("text.filter-noevent.info");
            }
            case TextNoImage: {
                return this.project.getResourceText("text.no-image");
            }
            case TypAufgabe: {
                return this.project.getResourceText("text.observationtype.aufgabe-default");
            }
            case TypInformation: {
                return this.project.getResourceText("text.observationtype.info-default");
            }
            case TypMangel: {
                return this.project.getResourceText("text.observationtype.mangel-default");
            }
            case TypKontrolle: {
                return this.project.getResourceText("text.observationtype.kontrolle-default");
            }
            case NewEventTitle: {
                return this.project.getResourceText("text.new-event.title");
            }
        }
        return "";
    }

    private String getTermCode(Term t) {
        switch (t) {
            case StatusErledigt: {
                return "statuserledigt";
            }
            case StatusOffen: {
                return "statusoffen";
            }
            case TextNoContent: {
                return "textnocontent";
            }
            case TextNoEvent: {
                return "textnoevent";
            }
            case TextNoImage: {
                return "textnoimage";
            }
            case TypAufgabe: {
                return "typaufgabe";
            }
            case TypInformation: {
                return "typinformation";
            }
            case TypMangel: {
                return "typmangel";
            }
            case TypKontrolle: {
                return "typkontrolle";
            }
            case NewEventTitle: {
                return "neweventtitle";
            }
        }
        return "";
    }

    public long getLastEventId() {
        return this.project.isOpen() ? Util.parseLong((String)this.getXmlElementText("/themis/project/event/lastid", "-1"), (long)-1L) : -1L;
    }

    public void setLastEventId(long id) {
        Element e = this.getXmlElement("/themis/project/event/lastid", true);
        e.setText(Long.toString(id));
    }

    public void setWelcomeScreenSplitMain(double v) {
        Element e = this.getXmlElement("/themis/system/welcomescreen/split", true);
        e.setAttribute("main", Double.toString(v));
    }

    public double getWelcomeScreenSplitMain() {
        Element e = this.getXmlElement("/themis/system/welcomescreen/split", true);
        double v = Util.parseDouble((String)e.getAttributeValue("main"), (double)0.25);
        return v;
    }

    public void setWelcomeScreenSplitLeft(double v) {
        Element e = this.getXmlElement("/themis/system/welcomescreen/split", true);
        e.setAttribute("left", Double.toString(v));
    }

    public double getWelcomeScreenSplitLeft() {
        Element e = this.getXmlElement("/themis/system/welcomescreen/split", true);
        double v = Util.parseDouble((String)e.getAttributeValue("left"), (double)0.75);
        return v;
    }

    public boolean hasDefaultThemisServerCode() {
        return !"".equals(this.getDefaultThemisServerCode());
    }

    public String getDefaultThemisServerCode() {
        return this.getXmlElementText("/themis/system/server/code", "");
    }

    public void setDefaultThemisServerCode(String c) {
        Element e = this.getXmlElement("/themis/system/server/code", true);
        e.setText(c);
    }

    public boolean hasThemisServerCode() {
        String c = this.getThemisServerCode();
        return c != null && !"".equals(c);
    }

    public void setThemisServerCode(String code) {
        Element e = this.getXmlElement("/themis/project/server/code", true);
        e.setText(code);
    }

    public String getThemisServerCode() {
        return this.project.isOpen() ? this.getXmlElementText("/themis/project/server/code", "") : "";
    }

    public ThemisSettingsFileElement getAutoImportFolder() {
        return this.folderAutoImport;
    }

    public boolean getAutoImportFromServer() {
        return this.getXmlElementText("/themis/project/autoexecute/importfromserver", "true").equals("true");
    }

    public void setAutoImportFromServer(boolean flg) {
        Element e = this.getXmlElement("/themis/project/autoexecute/importfromserver", true);
        e.setText(flg ? "true" : "false");
    }

    public ThemisSettingsFileElement getAutoExportFolder() {
        return this.folderAutoExport;
    }

    public boolean getAutoExportWithSubfolder() {
        return this.getXmlElementText("/themis/project/autoexecute/exportwithsubfolder", "false").equals("true");
    }

    public void setAutoExportWithSubfolder(boolean flg) {
        Element e = this.getXmlElement("/themis/project/autoexecute/exportwithsubfolder", true);
        e.setText(flg ? "true" : "false");
    }

    public boolean getAutoExportToServer() {
        return this.getXmlElementText("/themis/project/autoexecute/exporttoserver", "false").equals("true");
    }

    public void setAutoExportToServer(boolean flg) {
        Element e = this.getXmlElement("/themis/project/autoexecute/exporttoserver", true);
        e.setText(flg ? "true" : "false");
    }

    public boolean getAutoExportFullProject() {
        return this.getXmlElementText("/themis/project/autoexecute/exportfullproject", "true").equals("true");
    }

    public void setAutoExportFullProject(boolean flg) {
        Element e = this.getXmlElement("/themis/project/autoexecute/exportfullproject", true);
        e.setText(flg ? "true" : "false");
    }

    public void setPlanUsage(boolean use) {
        Element e = this.getXmlElement("/themis/project/plan/use", true);
        e.setText(use ? "true" : "false");
    }

    public boolean getPlanUsage() {
        String use = this.getXmlElementText("/themis/project/plan/use", "true");
        return !"false".equalsIgnoreCase(use);
    }

    public void setLicenseFloatingServer(String s) {
        Element e = this.getXmlElement("/themis/system/license/floatingserver", true);
        e.setText(s);
    }

    public String getLicenseFloatingServer() {
        return this.getXmlElementText("/themis/system/license/floatingserver", null);
    }

    public void setLicenseType(int idx) {
        Element e = this.getXmlElement("/themis/system/license/type", true);
        e.setText(Integer.toString(idx));
    }

    public int getLicenseType() {
        return Util.parseInt((String)this.getXmlElementText("/themis/system/license/type", "0"), (int)0);
    }

    public static enum UpdateMethod {
        INSTALLER,
        MODULE,
        ZIP;

    }

    public static enum Term {
        StatusOffen,
        StatusErledigt,
        TypMangel,
        TypAufgabe,
        TypKontrolle,
        TypInformation,
        TextNoEvent,
        TextNoContent,
        TextNoImage,
        NewEventTitle;

    }
}

