/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.settings;

import at.grid.themis.ontology.settings.ThemisSettings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jdom.Element;

public class ThemisSettingsFileElement {
    ThemisSettings settings;
    String xpath;
    File defaultFile = null;

    public ThemisSettingsFileElement(ThemisSettings s, String xpath) {
        this.settings = s;
        this.xpath = xpath;
    }

    public ThemisSettingsFileElement(ThemisSettings s, String xpath, String defaultFileName) {
        this.settings = s;
        this.xpath = xpath;
        this.defaultFile = new File(defaultFileName.replaceAll("%user%", System.getProperty("user.name")));
    }

    public ThemisSettingsFileElement(ThemisSettings s, String xpath, File defaultFile) {
        this.settings = s;
        this.xpath = xpath;
        this.defaultFile = defaultFile;
    }

    public File getValue(boolean replaceUser) {
        File result;
        try {
            Element element = this.settings.getXmlElement(this.xpath, false);
            if (element != null) {
                String txt = element.getText();
                if ("".equals(txt)) {
                    result = this.defaultFile;
                } else {
                    if (replaceUser) {
                        txt = txt.replaceAll("%user%", System.getProperty("user.name"));
                    }
                    result = new File(txt);
                }
            } else {
                result = this.defaultFile;
                this.settings.getXmlElement(this.xpath, true);
            }
            if (result != null) {
                boolean exists = result.exists();
                boolean existsNio = Files.exists(result.toPath(), new LinkOption[0]);
                if (!exists || !existsNio) {
                    result = null;
                }
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public String getValueAsPath(boolean replaceUser) {
        File f = this.getValue(replaceUser);
        return f == null ? "" : f.getAbsolutePath();
    }

    public boolean hasValue() {
        return this.getValue(false) != null;
    }

    public void setValue(File v) {
        this.settings.getXmlElement(this.xpath, true).setText(v == null ? null : v.getAbsolutePath());
    }

    public void setValue(String v) {
        this.settings.getXmlElement(this.xpath, true).setText(v == null ? null : v);
    }

    public void clear() {
        this.setValue("");
    }

    public String toString() {
        Element element = this.settings.getXmlElement(this.xpath, false);
        if (element != null) {
            return element.getText();
        }
        return "";
    }
}

