/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.signature;

import at.grid.themis.ontology.ThemisApplication;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.openide.util.Exceptions;

public class ThemisSignature {
    private String name;
    private String function;
    private BufferedImage signature;

    public ThemisSignature() {
        this("", "");
    }

    public ThemisSignature(String name, String function) {
        this(name, function, null);
    }

    public ThemisSignature(String name, String function, BufferedImage signature) {
        this.name = name;
        this.function = function;
        this.signature = signature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFunction() {
        return this.function;
    }

    public boolean hasFunction() {
        return this.function != null && !"".equals(this.function);
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public BufferedImage getSignature() {
        return this.signature;
    }

    public File getSignatureFile() {
        String uuid = UUID.randomUUID().toString();
        File f = new File(ThemisApplication.getInstance().getProject().getTempfileLocation(), uuid + ".jpg");
        try {
            if (this.signature != null) {
                ImageIO.write((RenderedImage)this.signature, "jpg", f);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return f;
    }

    public void setSignature(BufferedImage sig) {
        if (sig == null) {
            this.signature = null;
        } else {
            this.signature = new BufferedImage(sig.getWidth(), sig.getHeight(), 1);
            Graphics2D gg = this.signature.createGraphics();
            gg.drawImage((Image)sig, 0, 0, null);
            gg.dispose();
        }
    }

    public String toString() {
        return this.name + " (" + this.function + ") " + (this.signature == null ? "not signed" : "signed");
    }

    public boolean isEmpty() {
        return !(this.name != null && !"".equals(this.name) || this.function != null && !"".equals(this.function));
    }
}

