/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.soap;

import jakarta.xml.ws.Service;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;

public class ThemisSoapClient<T> {
    public static final String DEFAULT_ADDRESS = "http://localhost";
    public static final int DEFAULT_PORT = 8888;
    private final String address;
    private final int port;
    private final Class<T> clazz;
    public final T service;

    public ThemisSoapClient(String address, int port, Class clazz) throws MalformedURLException {
        this.address = address;
        this.port = port;
        this.clazz = clazz;
        this.service = this.createService();
    }

    public ThemisSoapClient(Class clazz) throws MalformedURLException {
        this(DEFAULT_ADDRESS, 8888, clazz);
    }

    private T createService() throws MalformedURLException {
        URL url = new URL(this.address + ":" + this.port + "/" + this.clazz.getSimpleName() + "/" + this.clazz.getSimpleName() + "?wsdl");
        String domain = "grid-it.at";
        QName qName = new QName("http://" + domain + "/", this.clazz.getSimpleName());
        return (T)Service.create((URL)url, (QName)qName).getPort(this.clazz);
    }

    private static String reversePackage(String packageName) {
        String[] tokens;
        String result = "";
        for (String token : tokens = packageName.split("\\.")) {
            result = "." + token + result;
        }
        if (result.startsWith(".")) {
            result = result.substring(1);
        }
        return result;
    }
}

