/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.soap;

import at.grid.themis.ontology.soap.echo.SoapEchoServiceImpl;
import at.grid.themis.ontology.soap.observation.SoapObservationServiceImpl;
import jakarta.xml.ws.Endpoint;
import java.util.ArrayList;

public class ThemisSoapServer {
    public static final String DEFAULT_ADDRESS = "http://localhost";
    public static final int DEFAULT_PORT = 8888;
    private final String address;
    private final int port;
    private final ArrayList<Endpoint> endpoints = new ArrayList();

    public ThemisSoapServer(String address, int port) {
        this.address = address;
        this.port = port;
    }

    public ThemisSoapServer() {
        this(DEFAULT_ADDRESS, 8888);
    }

    public void start() {
        this.publish(new SoapEchoServiceImpl());
        this.publish(new SoapObservationServiceImpl());
    }

    private void publish(Object service) {
        Endpoint endpoint = Endpoint.publish((String)(this.address + ":" + this.port + "/" + service.getClass().getInterfaces()[0].getSimpleName() + "/"), (Object)service);
        this.endpoints.add(endpoint);
    }

    public void stop() {
        for (Endpoint endpoint : this.endpoints) {
            if (!endpoint.isPublished()) continue;
            endpoint.stop();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }
}

