/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.sync;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.sync.SaveWithRelations;
import at.grid.themis.ontology.sync.SynchronisationFeature;
import at.grid.themis.ontology.sync.SynchronisationTask;
import java.util.List;

public class CopyElementToMaster
extends SynchronisationTask {
    private SynchronisationFeature feature = null;

    public CopyElementToMaster(ThemisProject work, ThemisProject master, SynchronisationFeature f, long idEvent) {
        super(work.getUser().getCurrentLanguage());
        this.work = work;
        this.master = master;
        this.feature = f;
        this.idEvent = idEvent;
    }

    @Override
    public void execute() {
        CmsElement element = this.work.loadElement(this.feature.id, this.work.getUser());
        if ("observation".equals(element.getElementcode())) {
            ((CmsObservation)element).removeHistoryForEvent(this.idEvent);
        } else if ("location".equals(element.getElementcode())) {
            element.getAttribute("number").clear();
        } else if ("plan".equals(element.getElementcode())) {
            List<CmsElementSummary> planfiles = ((CmsPlan)element).getPlanfiles();
            for (CmsElementSummary planfile : planfiles) {
                CmsElement pf = planfile.getElement();
                pf.setNew(true);
                pf.setApplication((CmsApplication)this.master);
                this.updateUploads(pf);
                pf.save(true, false);
            }
        } else if ("observationtemplate".equals(element.getElementcode())) {
            boolean bl = false;
        } else {
            boolean bl = false;
        }
        element.setApplication((CmsApplication)this.master);
        element.setNew(true);
        this.updateUploads(element);
        element.save(true, true);
        this.copyElementHistory(this.feature.id, element.getId());
        this.addPostSynchronisationTask(new SaveWithRelations(this.master, element));
    }

    @Override
    public int getCategory() {
        return 2;
    }

    @Override
    public String getCode() {
        return this.feature.elementype.toUpperCase();
    }

    @Override
    public String getTitle() {
        return this.feature.title + (this.feature.deleted ? " [DELETED]" : "");
    }

    @Override
    public long getIdWork() {
        return this.feature.id;
    }

    @Override
    public long getIdMaster() {
        return this.feature.id;
    }

    @Override
    public String getAction() {
        return "Nach MASTER kopieren und dort neu erstellen";
    }
}

