/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.sync;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.sync.CopyElementToMaster;
import at.grid.themis.ontology.sync.SaveWithRelations;
import at.grid.themis.ontology.sync.SynchronisationConflict;
import at.grid.themis.ontology.sync.SynchronisationFeature;
import at.grid.themis.ontology.sync.SynchronisationTask;
import java.util.Iterator;
import java.util.List;

public class OverwriteElementInMaster
extends SynchronisationTask {
    private SynchronisationFeature feature = null;

    public OverwriteElementInMaster(ThemisProject work, ThemisProject master, SynchronisationFeature f, long idEvent) {
        super(work.getUser().getCurrentLanguage());
        this.work = work;
        this.master = master;
        this.feature = f;
        this.idEvent = idEvent;
    }

    public OverwriteElementInMaster(SynchronisationConflict conflict) {
        this(conflict.getWorkProject(), conflict.getMasterProject(), conflict.getSynchronisationFeature(), conflict.idEvent);
    }

    @Override
    public void execute() {
        CmsElement element = this.work.loadElement(this.feature.id, this.work.getUser());
        CmsHistory history = null;
        if ("observation".equals(element.getElementcode())) {
            history = ((CmsObservation)element).getHistory(this.idEvent);
            UploadAttribute historyUploads = history.getUploadAttribute("files");
            for (UploadItem item : historyUploads.getAllUploadItems()) {
                item.createId();
                item.setNew(true);
                item.setStatus(2);
            }
            CmsElement elementMaster = this.master.loadElement(this.feature.id, this.master.getUser());
            elementMaster.setAttributeValue("title", element.getAttributeValue("title"));
            List ids = element.getRelationAttribute("infos").getElementIds();
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                elementMaster.getRelationAttribute("infos").add(id);
            }
            ((CmsObservation)elementMaster).applyHistory(history);
            element = elementMaster;
        } else if ("plan".equals(element.getElementcode())) {
            CmsElement masterPlan = this.master.loadElement(this.feature.id, this.master.getUser());
            List masterPlanfileIds = masterPlan.getRelationAttribute("planfiles").getElementIds();
            if (!masterPlanfileIds.contains(element.getLongAttribute("calibplanfile"))) {
                element.getLongAttribute("calibplanfile").setValue(element.getLongAttribute("calibplanfile").getLong());
            }
            if (!masterPlanfileIds.contains(element.getLongAttribute("currentplanfile"))) {
                element.getLongAttribute("currentplanfile").setValue(element.getLongAttribute("currentplanfile").getLong());
            }
            Iterator iterator = element.getRelationAttribute("planfiles").getElementIds().iterator();
            while (iterator.hasNext()) {
                long idPlanfile = (Long)iterator.next();
                if (masterPlanfileIds.contains(idPlanfile)) continue;
                this.addPostSynchronisationTask(new CopyElementToMaster(this.work, this.master, new SynchronisationFeature(this.feature.id, this.work, 0L), this.idEvent));
            }
        }
        element.setApplication((CmsApplication)this.master);
        element.setNew(false);
        if (!"observation".equals(element.getElementcode())) {
            this.updateUploads(element);
        }
        element.save(true, true);
        this.copyElementHistory(this.feature.id, element.getId());
        this.addPostSynchronisationTask(new SaveWithRelations(this.master, element));
    }

    @Override
    public int getCategory() {
        return 2;
    }

    @Override
    public String getCode() {
        return this.feature.elementype;
    }

    @Override
    public String getTitle() {
        return this.feature.title + (this.feature.deleted ? " [DELETED]" : "");
    }

    @Override
    public long getIdWork() {
        return this.feature.id;
    }

    @Override
    public long getIdMaster() {
        return this.feature.id;
    }

    @Override
    public String getAction() {
        return "In MASTER \u00fcberschreiben";
    }
}

