/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.sync;

import at.grid.cms.attribute.BooleanAttribute;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.attribute.FloatAttribute;
import at.grid.cms.attribute.IntegerAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.LongAttribute;
import at.grid.cms.attribute.MultikeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.sync.OverwriteElementInMaster;
import at.grid.themis.ontology.sync.SynchronisationFeature;
import at.grid.themis.ontology.sync.SynchronisationTask;
import java.util.ArrayList;

public class SynchronisationConflict
extends SynchronisationTask {
    private SynchronisationFeature featureWork = null;
    private SynchronisationFeature featureMaster = null;
    private ThemisProject work = null;
    private ThemisProject master = null;
    private ArrayList<Conflict> conflicts = new ArrayList();
    public static final int USE_WORK = 1;
    public static final int USE_MASTER = 2;
    public static final int NONE = -1;
    private int elementSolution = -1;

    public SynchronisationConflict(ThemisProject work, ThemisProject master, SynchronisationFeature featureWork, SynchronisationFeature featureMaster, long idEvent) {
        super(work.getUser().getCurrentLanguage());
        this.work = work;
        this.master = master;
        this.featureWork = featureWork;
        this.featureMaster = featureMaster;
        this.idEvent = idEvent;
        CmsElement eleC = work.loadElement(featureWork.id, work.getUser());
        CmsElement eleM = master.loadElement(featureMaster.id, master.getUser());
        for (CmsAttribute att : eleC.getAttributes()) {
            String valueM;
            String valueC;
            if (att.isVirtual() || (valueC = att.getValue()).equals(valueM = eleM.getAttribute(att.getCode()).getValue()) || att.getCode().startsWith("meta_")) continue;
            this.conflicts.add(new Conflict(att.getCode(), valueC, valueM));
        }
    }

    public ThemisProject getWorkProject() {
        return this.work;
    }

    public ThemisProject getMasterProject() {
        return this.master;
    }

    public SynchronisationFeature getSynchronisationFeature() {
        return this.featureWork;
    }

    public void clearSolutions() {
        for (Conflict c : this.conflicts) {
            c.solution = -1;
        }
        this.elementSolution = -1;
    }

    public void setElementSolution(int elementSolution) {
        this.elementSolution = elementSolution;
    }

    public ArrayList<Conflict> getConflicts() {
        return this.conflicts;
    }

    public boolean isSolved() {
        if (this.elementSolution != -1) {
            return true;
        }
        for (Conflict c : this.conflicts) {
            if (c.solution != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        CmsElement elementWork = this.work.loadElement(this.featureWork.id, this.work.getUser());
        CmsElement elementMaster = this.master.loadElement(this.featureMaster.id, this.master.getUser());
        if (this.elementSolution == 1) {
            new OverwriteElementInMaster(this).execute();
        } else if (this.elementSolution != 2) {
            block14: for (Conflict c : this.conflicts) {
                if (c.solution != 1) continue;
                CmsAttribute att = elementWork.getAttribute(c.att);
                CmsAttribute attMaster = elementMaster.getAttribute(c.att);
                switch (att.getType()) {
                    case 1: {
                        ((BooleanAttribute)attMaster).setValue(((BooleanAttribute)att).isSet());
                        break;
                    }
                    case 2: {
                        ((DateAttribute)attMaster).setDate(((DateAttribute)att).getDate());
                        break;
                    }
                    case 3: {
                        ((FloatAttribute)attMaster).setValue(((FloatAttribute)att).getFloatValue());
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 7: {
                        ((IntegerAttribute)attMaster).setValue(((IntegerAttribute)att).getValue());
                        break;
                    }
                    case 8: {
                        ((KeyAttribute)attMaster).setValue(((KeyAttribute)att).getId());
                        break;
                    }
                    case 9: {
                        ((LongAttribute)attMaster).setValue(((LongAttribute)att).getLong());
                        break;
                    }
                    case 10: {
                        ((MultikeyAttribute)attMaster).clear();
                        Object object = ((MultikeyAttribute)att).getIds();
                        int n = ((Long[])object).length;
                        for (int i = 0; i < n; ++i) {
                            long id = (Long)object[i];
                            ((MultikeyAttribute)attMaster).addId(id);
                        }
                        continue block14;
                    }
                    case 14: {
                        ((RelationAttribute)attMaster).clear();
                        Object object = ((RelationAttribute)att).getElementIds().iterator();
                        while (object.hasNext()) {
                            long id = (Long)object.next();
                            ((RelationAttribute)attMaster).add(id);
                        }
                        continue block14;
                    }
                    case 12: {
                        attMaster.setValue(att.getValue());
                        break;
                    }
                    case 13: {
                        attMaster.setValue(att.getValue());
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
            }
            elementMaster.save();
        }
    }

    @Override
    public int getCategory() {
        return 2;
    }

    @Override
    public String getCode() {
        return this.featureWork.elementype;
    }

    @Override
    public String getTitle() {
        return this.featureWork.title + (this.featureWork.deleted ? " [DELETED]" : "");
    }

    @Override
    public long getIdWork() {
        return this.featureWork.id;
    }

    @Override
    public long getIdMaster() {
        return this.featureMaster.id;
    }

    @Override
    public String getAction() {
        return "Konflikt";
    }

    public String compare() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public class Conflict {
        public String att;
        public String valWork;
        public String valMaster;
        public int solution = -1;

        public Conflict(String att, String vw, String vm) {
            this.att = att;
            this.valWork = vw;
            this.valMaster = vm;
        }

        public String toString() {
            return ThemisApplication.getInstance().getProject().getResourceText("attribute." + SynchronisationConflict.this.getSynchronisationFeature().getElementype() + "." + this.att, ThemisApplication.getInstance().getLocale());
        }
    }
}

