/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.sync;

import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisProject;
import java.util.Date;
import java.util.UUID;

public class SynchronisationFeature {
    long id;
    UUID uuid;
    Date lastedit;
    String elementype;
    String title;
    boolean deleted;

    public SynchronisationFeature(DataRecord rec, ThemisProject p) {
        this.id = rec.getLong("idelement");
        this.uuid = UUID.fromString(rec.getString("uuid"));
        this.lastedit = rec.getDate("metalastedit", p.getTimeZone());
        this.elementype = rec.getString("elementtype");
        this.title = rec.getString("title");
        this.deleted = rec.getBoolean("deleted");
    }

    public SynchronisationFeature(long id, ThemisProject p, long delta) {
        CmsElement e = p.loadElement(id, p.getUser());
        this.id = id + delta;
        this.uuid = e.getUUID();
        this.lastedit = ((DateAttribute)e.getAttribute("meta_lastedit")).getDate();
        this.elementype = e.getElementcode();
        this.title = e.getTitle();
        this.deleted = e.isTrash();
    }

    public boolean isSameDate(SynchronisationFeature e) {
        if (this.lastedit == null) {
            return false;
        }
        return this.lastedit.equals(e.lastedit);
    }

    boolean compareTitle(SynchronisationFeature em) {
        if (!this.elementype.equals(em.elementype)) {
            return false;
        }
        return this.title.equals(em.title);
    }

    public String toString() {
        return this.elementype + " [" + this.id + "]: " + this.title;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getElementype() {
        return this.elementype;
    }

    public String getTitle() {
        return this.title;
    }
}

