/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.sync;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.sync.CopyElementToMaster;
import at.grid.themis.ontology.sync.CreateKeytableTerm;
import at.grid.themis.ontology.sync.OverwriteElementInMaster;
import at.grid.themis.ontology.sync.ReplaceElementWithMasterElement;
import at.grid.themis.ontology.sync.SynchronisationConflict;
import at.grid.themis.ontology.sync.SynchronisationFeature;
import at.grid.themis.ontology.sync.SynchronisationTask;
import at.grid.themis.ontology.sync.SynchroniseKeytableId;
import at.grid.themis.ontology.sync.UpdateKeytableId;
import at.grid.themis.ontology.sync.UpdateMultipleElementIds;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class SynchronisationManager {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject work;
    ThemisProject master;
    File masterfile;
    HashMap<UUID, SynchronisationFeature> elementsWork;
    HashMap<UUID, SynchronisationFeature> elementsMaster;
    ArrayList<SynchronisationTask> tasks = new ArrayList();
    ArrayList<SynchronisationTask> postTasks = new ArrayList();
    ArrayList<SynchronisationTask> cleanupTasks = new ArrayList();
    SynchronisationTask updateIdsTask = null;
    boolean sameProjects = true;
    long idEventWork;
    String eventWorkTitle = "";
    long idEventMaster = -1L;
    long nextElementIdSequenceValue = -1L;

    public SynchronisationManager(ThemisProject work, ThemisProject master, long idEvent) {
        this.work = work;
        this.master = master;
        this.masterfile = master.getProjectFolder();
        this.idEventWork = idEvent;
    }

    public ArrayList<SynchronisationTask> getSynchronisationTasks() {
        return this.tasks;
    }

    public String analyse(boolean useNameIdentity) {
        boolean newEvent;
        SynchronisationFeature e;
        UUID masterUUID;
        if (ThemisLicense.isLicenseLevelLessThan(ThemisLicense.LicenseLevel.FULL)) {
            return this.work.getResourceText("license.no-license", ThemisApplication.getInstance().getLocale());
        }
        if (!this.master.isOpen()) {
            return this.work.getResourceText("symc.master-not-open", ThemisApplication.getInstance().getLocale());
        }
        if (!this.work.isOpen()) {
            return this.work.getResourceText("symc.work-not-open", ThemisApplication.getInstance().getLocale());
        }
        UUID workUUID = this.work.getProjectElement().getUUID();
        if (!workUUID.equals(masterUUID = this.master.getProjectElement().getUUID())) {
            this.sameProjects = false;
        }
        this.tasks.clear();
        this.postTasks.clear();
        this.cleanupTasks.clear();
        this.updateIdsTask = null;
        CmsElement h = this.work.getDefaultElement("history");
        ArrayList<String> historyAttributes = new ArrayList<String>();
        for (CmsAttribute att : h.getDataAttributes()) {
            historyAttributes.add(att.getCode());
        }
        historyAttributes.add("histories");
        historyAttributes.add("referencedate");
        historyAttributes.add("plannedfor");
        historyAttributes.add("plan");
        historyAttributes.add("hasimage");
        historyAttributes.add("hasaudio");
        historyAttributes.add("meta_lasteditby");
        historyAttributes.add("meta_iduser");
        String language = this.work.getUser().getCurrentLanguage();
        List keytableNames = this.work.getKeytableNames();
        Iterator iterator = keytableNames.iterator();
        block34: while (iterator.hasNext()) {
            String keytableName;
            switch (keytableName = (String)iterator.next()) {
                case "uploaddetail": {
                    continue block34;
                }
                case "permissionlevel": {
                    continue block34;
                }
                case "workflowstatus": {
                    continue block34;
                }
                case "obstype": {
                    continue block34;
                }
            }
            ArrayList tempIds = new ArrayList();
            Keytable tblWork = this.work.getKeytable(keytableName);
            ArrayList workIds = tblWork.getIds();
            Iterator iterator2 = workIds.iterator();
            while (iterator2.hasNext()) {
                long idWork = (Long)iterator2.next();
                String workTerm = tblWork.getTerm(idWork, language);
                Keytable tblMaster = this.master.getKeytable(keytableName);
                long idMaster = tblMaster.getIdByTerm(workTerm, language);
                if (idMaster < 0L) {
                    this.tasks.add(new CreateKeytableTerm(tblWork, tblMaster, idWork, workTerm));
                    continue;
                }
                if (idMaster == idWork) continue;
                if (tblWork.hasId(idMaster, language)) {
                    this.tasks.add(new SynchroniseKeytableId(tblWork, tblMaster, idWork, idMaster));
                    continue;
                }
                this.tasks.add(new UpdateKeytableId(tblWork, idWork, idMaster));
            }
        }
        CmsElement event = this.work.loadElement(this.idEventWork, this.work.getUser());
        this.eventWorkTitle = event.getTitle();
        List historyIds = event.getRelationAttribute("histories").getElementIds();
        List recs = this.work.getDatastorage().executeQuery("SELECT elementto AS id FROM tdtaRelation  WHERE elementfrom IN " + Util.toSqlString((Iterable)historyIds) + " AND relationcode='historyobservation'", true).getResult();
        ArrayList<Long> observationIds = new ArrayList<Long>();
        for (Object rec : recs) {
            observationIds.add(rec.getLong("id"));
        }
        this.elementsWork = new HashMap();
        this.elementsMaster = new HashMap();
        recs = this.work.getDatastorage().executeQuery("SELECT e.idelement,uuid,elementtype,el.title,el.metalastedit,e.deleted FROM tdtaelement AS e INNER JOIN tdtaelementlng AS el ON (e.idelement=el.idelement)", true).getResult();
        for (DataRecord rec : recs) {
            e = new SynchronisationFeature(rec, this.work);
            this.elementsWork.put(e.uuid, e);
        }
        recs = this.master.getDatastorage().executeQuery("SELECT e.idelement,uuid,elementtype,el.title,el.metalastedit,e.deleted FROM tdtaelement AS e INNER JOIN tdtaelementlng AS el ON (e.idelement=el.idelement)", true).getResult();
        for (DataRecord rec : recs) {
            e = new SynchronisationFeature(rec, this.work);
            this.elementsMaster.put(e.uuid, e);
        }
        long lastElementIdMaster = this.master.getLastElementId();
        long lastElementIdWork = this.work.getLastElementId();
        this.nextElementIdSequenceValue = lastElementIdMaster + 1L;
        long lastCommonId = 0L;
        for (UUID uuid : this.elementsWork.keySet()) {
            if (!this.elementsMaster.keySet().contains(uuid) || lastCommonId >= this.elementsWork.get((Object)uuid).id) continue;
            lastCommonId = this.elementsWork.get((Object)uuid).id;
        }
        long deltaId = lastElementIdMaster - lastCommonId;
        if (deltaId > 0L) {
            int ii;
            for (UUID uuid : this.elementsWork.keySet()) {
                SynchronisationFeature e2 = this.elementsWork.get(uuid);
                if (e2.id <= lastCommonId) continue;
                e2.id += deltaId;
                if (e2.id < this.nextElementIdSequenceValue) continue;
                this.nextElementIdSequenceValue = e2.id + 1L;
            }
            this.updateIdsTask = new UpdateMultipleElementIds(this.work, lastCommonId, deltaId);
            if (event.getId() > lastCommonId) {
                event.setId(event.getId() + deltaId);
            }
            long id = 0L;
            for (ii = 0; ii < historyIds.size(); ++ii) {
                id = (Long)historyIds.get(ii);
                if (id <= lastCommonId) continue;
                historyIds.set(ii, id + deltaId);
            }
            for (ii = 0; ii < observationIds.size(); ++ii) {
                id = (Long)observationIds.get(ii);
                if (id <= lastCommonId) continue;
                observationIds.set(ii, id + deltaId);
            }
        }
        if (lastElementIdWork >= this.nextElementIdSequenceValue) {
            this.nextElementIdSequenceValue = lastElementIdWork + 1L;
        }
        boolean bl = newEvent = !this.elementsMaster.containsKey(event.getUUID());
        if (newEvent) {
            this.idEventMaster = this.elementsWork.get((Object)event.getUUID()).id;
            this.tasks.add(new CopyElementToMaster(this.work, this.master, this.elementsWork.get(event.getUUID()), event.getId()));
        } else {
            this.idEventMaster = this.elementsMaster.get((Object)event.getUUID()).id;
        }
        for (UUID uuid : this.elementsWork.keySet()) {
            boolean same;
            CmsElement e2;
            CmsElement e1;
            SynchronisationFeature e3 = this.elementsWork.get(uuid);
            if ("history".equals(e3.elementype) || "planfile".equals(e3.elementype) || "event".equals(e3.elementype)) continue;
            if (!this.elementsMaster.containsKey(uuid)) {
                if ("observation".equals(e3.elementype) && !observationIds.contains(e3.id)) continue;
                if ("event".equals(e3.elementype) || "locationtemplate".equals(e3.elementype) || "observationtemplate".equals(e3.elementype) || "measuretemplate".equals(e3.elementype) || "info".equals(e3.elementype) || "company".equals(e3.elementype) || "plan".equals(e3.elementype)) {
                    boolean foundIdent = false;
                    if (useNameIdentity) {
                        for (SynchronisationFeature em : this.elementsMaster.values()) {
                            if (!e3.compareTitle(em)) continue;
                            this.tasks.add(new ReplaceElementWithMasterElement(this.work, this.master, e3.id, em.id, e3));
                            foundIdent = true;
                            break;
                        }
                    }
                    if (foundIdent) continue;
                    this.tasks.add(new CopyElementToMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                if ("log".equals(e3.elementype)) {
                    CmsElement log = this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getUser());
                    long obsInLogId = log.getLongAttribute("observationid").getLong();
                    if (!observationIds.contains(obsInLogId + (obsInLogId > lastCommonId ? deltaId : 0L))) continue;
                    this.tasks.add(new CopyElementToMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                this.tasks.add(new CopyElementToMaster(this.work, this.master, e3, event.getId()));
                continue;
            }
            if (e3.isSameDate(this.elementsMaster.get(uuid)) || "observation".equals(e3.elementype) && !observationIds.contains(e3.id)) continue;
            SynchronisationFeature em = this.elementsMaster.get(uuid);
            ArrayList workHistory = this.work.getDatastorage().getElementHistoryDates(e3.id - (e3.id > lastCommonId ? deltaId : 0L));
            ArrayList masterHistory = this.master.getDatastorage().getElementHistoryDates(e3.id);
            if (this.checkElementHistory(masterHistory, e3.lastedit)) continue;
            if (this.checkElementHistory(workHistory, em.lastedit)) {
                this.tasks.add(new OverwriteElementInMaster(this.work, this.master, e3, event.getId()));
                continue;
            }
            if ("location".equals(e3.elementype)) {
                e1 = this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getAdminUser());
                e2 = this.master.loadElement(em.id, this.master.getAdminUser());
                boolean same2 = e1.getMD5withoutMeta("observations").equals(e2.getMD5withoutMeta("observations"));
                if (same2) continue;
                this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
                continue;
            }
            if ("observation".equals(e3.elementype)) {
                CmsObservation o1 = (CmsObservation)this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getAdminUser());
                CmsObservation o2 = (CmsObservation)this.master.loadElement(em.id, this.master.getAdminUser());
                boolean same3 = o1.getMD5(historyAttributes).equals(o2.getMD5(historyAttributes));
                if (!same3) {
                    this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
                    continue;
                }
                if (newEvent) {
                    this.tasks.add(new OverwriteElementInMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                if (o2.getHistory(this.idEventMaster) == null) {
                    this.tasks.add(new OverwriteElementInMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                Object hist1 = o1.getHistory(event.getId() - (e3.id > lastCommonId ? deltaId : 0L));
                CmsHistory hist2 = o2.getHistory(this.idEventMaster);
                boolean same2 = hist1.getMD5().equals(hist2.getMD5());
                if (same2) continue;
                this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
                continue;
            }
            e1 = this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getAdminUser());
            e2 = this.master.loadElement(em.id, this.master.getAdminUser());
            String ignoreAttributes = null;
            switch (e3.elementype) {
                case "company": {
                    ignoreAttributes = "tasks";
                    break;
                }
                case "filter": {
                    break;
                }
                case "icon": {
                    break;
                }
                case "info": {
                    ignoreAttributes = "object,observations";
                    break;
                }
                case "locationgroup": {
                    ignoreAttributes = "locationtemplate,observationtemplate";
                    break;
                }
                case "locationtemplate": {
                    break;
                }
                case "measuretemplate": {
                    ignoreAttributes = "observationtemplate";
                    break;
                }
                case "plan": {
                    ignoreAttributes = "sort,locations";
                    break;
                }
            }
            if (same = e1.getMD5(ignoreAttributes).equals(e2.getMD5(ignoreAttributes))) continue;
            this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
        }
        return this.getResult(this.tasks);
    }

    public String analyse2(boolean useNameIdentity) {
        boolean newEvent;
        SynchronisationFeature e;
        UUID masterUUID;
        if (ThemisLicense.isLicenseLevelLessThan(ThemisLicense.LicenseLevel.FULL)) {
            return "No license";
        }
        if (!this.master.isOpen()) {
            return "MASTER Projekt ist nicht ge\u00f6ffnet";
        }
        if (!this.work.isOpen()) {
            return "WORK Projekt ist nicht ge\u00f6ffnet";
        }
        UUID workUUID = this.work.getProjectElement().getUUID();
        if (!workUUID.equals(masterUUID = this.master.getProjectElement().getUUID())) {
            this.sameProjects = false;
        }
        this.tasks.clear();
        this.postTasks.clear();
        this.cleanupTasks.clear();
        this.updateIdsTask = null;
        CmsElement h = this.work.getDefaultElement("history");
        ArrayList<String> historyAttributes = new ArrayList<String>();
        for (CmsAttribute att : h.getDataAttributes()) {
            historyAttributes.add(att.getCode());
        }
        historyAttributes.add("histories");
        historyAttributes.add("referencedate");
        String language = this.work.getUser().getCurrentLanguage();
        List keytableNames = this.work.getKeytableNames();
        Iterator iterator = keytableNames.iterator();
        block13: while (iterator.hasNext()) {
            String keytableName;
            switch (keytableName = (String)iterator.next()) {
                case "uploaddetail": {
                    continue block13;
                }
                case "permissionlevel": {
                    continue block13;
                }
                case "workflowstatus": {
                    continue block13;
                }
                case "obstype": {
                    continue block13;
                }
            }
            ArrayList tempIds = new ArrayList();
            Keytable tblWork = this.work.getKeytable(keytableName);
            ArrayList workIds = tblWork.getIds();
            Iterator iterator2 = workIds.iterator();
            while (iterator2.hasNext()) {
                long idWork = (Long)iterator2.next();
                String workTerm = tblWork.getTerm(idWork, language);
                Keytable tblMaster = this.master.getKeytable(keytableName);
                long idMaster = tblMaster.getIdByTerm(workTerm, language);
                if (idMaster < 0L) {
                    this.tasks.add(new CreateKeytableTerm(tblWork, tblMaster, idWork, workTerm));
                    continue;
                }
                if (idMaster == idWork) continue;
                if (tblWork.hasId(idMaster, language)) {
                    this.tasks.add(new SynchroniseKeytableId(tblWork, tblMaster, idWork, idMaster));
                    continue;
                }
                this.tasks.add(new UpdateKeytableId(tblWork, idWork, idMaster));
            }
        }
        CmsElement event = this.work.loadElement(this.idEventWork, this.work.getUser());
        List historyIds = event.getRelationAttribute("histories").getElementIds();
        List recs = this.work.getDatastorage().executeQuery("SELECT elementto AS id FROM tdtaRelation  WHERE elementfrom IN " + Util.toSqlString((Iterable)historyIds) + " AND relationcode='historyobservation'", true).getResult();
        ArrayList<Long> observationIds = new ArrayList<Long>();
        for (Object rec : recs) {
            observationIds.add(rec.getLong("id"));
        }
        this.elementsWork = new HashMap();
        this.elementsMaster = new HashMap();
        recs = this.work.getDatastorage().executeQuery("SELECT e.idelement,uuid,elementtype,el.title,el.metalastedit,e.deleted FROM tdtaelement AS e INNER JOIN tdtaelementlng AS el ON (e.idelement=el.idelement)", true).getResult();
        for (DataRecord rec : recs) {
            e = new SynchronisationFeature(rec, this.work);
            this.elementsWork.put(e.uuid, e);
        }
        recs = this.master.getDatastorage().executeQuery("SELECT e.idelement,uuid,elementtype,el.title,el.metalastedit,e.deleted FROM tdtaelement AS e INNER JOIN tdtaelementlng AS el ON (e.idelement=el.idelement)", true).getResult();
        for (DataRecord rec : recs) {
            e = new SynchronisationFeature(rec, this.work);
            this.elementsMaster.put(e.uuid, e);
        }
        long lastElementIdMaster = this.master.getLastElementId();
        long lastElementIdWork = this.work.getLastElementId();
        this.nextElementIdSequenceValue = lastElementIdMaster + 1L;
        long lastCommonId = 0L;
        for (UUID uuid : this.elementsWork.keySet()) {
            if (!this.elementsMaster.keySet().contains(uuid) || lastCommonId >= this.elementsWork.get((Object)uuid).id) continue;
            lastCommonId = this.elementsWork.get((Object)uuid).id;
        }
        long deltaId = lastElementIdMaster - lastCommonId;
        if (deltaId > 0L) {
            int ii;
            for (UUID uuid : this.elementsWork.keySet()) {
                SynchronisationFeature e2 = this.elementsWork.get(uuid);
                if (e2.id <= lastCommonId) continue;
                e2.id += deltaId;
                if (e2.id < this.nextElementIdSequenceValue) continue;
                this.nextElementIdSequenceValue = e2.id + 1L;
            }
            this.updateIdsTask = new UpdateMultipleElementIds(this.work, lastCommonId, deltaId);
            if (event.getId() > lastCommonId) {
                event.setId(event.getId() + deltaId);
            }
            long id = 0L;
            for (ii = 0; ii < historyIds.size(); ++ii) {
                id = (Long)historyIds.get(ii);
                if (id <= lastCommonId) continue;
                historyIds.set(ii, id + deltaId);
            }
            for (ii = 0; ii < observationIds.size(); ++ii) {
                id = (Long)observationIds.get(ii);
                if (id <= lastCommonId) continue;
                observationIds.set(ii, id + deltaId);
            }
        }
        if (lastElementIdWork >= this.nextElementIdSequenceValue) {
            this.nextElementIdSequenceValue = lastElementIdWork + 1L;
        }
        boolean bl = newEvent = !this.elementsMaster.containsKey(event.getUUID());
        if (newEvent) {
            this.idEventMaster = this.elementsWork.get((Object)event.getUUID()).id;
            this.tasks.add(new CopyElementToMaster(this.work, this.master, this.elementsWork.get(event.getUUID()), event.getId()));
        } else {
            this.idEventMaster = this.elementsMaster.get((Object)event.getUUID()).id;
        }
        for (UUID uuid : this.elementsWork.keySet()) {
            boolean same;
            CmsElement e2;
            CmsElement e1;
            SynchronisationFeature e3 = this.elementsWork.get(uuid);
            if ("history".equals(e3.elementype) || "planfile".equals(e3.elementype) || "event".equals(e3.elementype)) continue;
            if ("observation".equals(e3.elementype)) {
                boolean bl2 = true;
            }
            if (!this.elementsMaster.containsKey(uuid)) {
                if ("observation".equals(e3.elementype) && !observationIds.contains(e3.id)) continue;
                if ("event".equals(e3.elementype) || "locationtemplate".equals(e3.elementype) || "observationtemplate".equals(e3.elementype) || "measuretemplate".equals(e3.elementype) || "info".equals(e3.elementype) || "company".equals(e3.elementype) || "plan".equals(e3.elementype)) {
                    boolean foundIdent = false;
                    if (useNameIdentity) {
                        for (SynchronisationFeature em : this.elementsMaster.values()) {
                            if (!e3.compareTitle(em)) continue;
                            this.tasks.add(new ReplaceElementWithMasterElement(this.work, this.master, e3.id, em.id, e3));
                            foundIdent = true;
                            break;
                        }
                    }
                    if (foundIdent) continue;
                    this.tasks.add(new CopyElementToMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                if ("log".equals(e3.elementype)) {
                    CmsElement log = this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getUser());
                    long obsInLogId = log.getLongAttribute("observationid").getLong();
                    if (!observationIds.contains(obsInLogId + (obsInLogId > lastCommonId ? deltaId : 0L))) continue;
                    this.tasks.add(new CopyElementToMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                this.tasks.add(new CopyElementToMaster(this.work, this.master, e3, event.getId()));
                continue;
            }
            if (e3.isSameDate(this.elementsMaster.get(uuid)) || "observation".equals(e3.elementype) && !observationIds.contains(e3.id)) continue;
            SynchronisationFeature em = this.elementsMaster.get(uuid);
            ArrayList workHistory = this.work.getDatastorage().getElementHistoryDates(e3.id - (e3.id > lastCommonId ? deltaId : 0L));
            ArrayList masterHistory = this.master.getDatastorage().getElementHistoryDates(e3.id);
            if (this.checkElementHistory(masterHistory, e3.lastedit)) continue;
            if (this.checkElementHistory(workHistory, em.lastedit)) {
                this.tasks.add(new OverwriteElementInMaster(this.work, this.master, e3, event.getId()));
                continue;
            }
            if ("location".equals(e3.elementype)) {
                e1 = this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getAdminUser());
                e2 = this.master.loadElement(em.id, this.master.getAdminUser());
                same = e1.getMD5("observations").equals(e2.getMD5("observations"));
                if (same) continue;
                this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
                continue;
            }
            if ("observation".equals(e3.elementype)) {
                CmsObservation o1 = (CmsObservation)this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getAdminUser());
                CmsObservation o2 = (CmsObservation)this.master.loadElement(em.id, this.master.getAdminUser());
                same = o1.getMD5(historyAttributes).equals(o2.getMD5(historyAttributes));
                if (!same) {
                    this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
                    continue;
                }
                if (newEvent) {
                    this.tasks.add(new OverwriteElementInMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                if (o2.getHistory(this.idEventMaster) == null) {
                    this.tasks.add(new OverwriteElementInMaster(this.work, this.master, e3, event.getId()));
                    continue;
                }
                CmsHistory hist1 = o1.getHistory(event.getId() - (e3.id > lastCommonId ? deltaId : 0L));
                CmsHistory hist2 = o2.getHistory(this.idEventMaster);
                boolean same2 = hist1.getMD5().equals(hist2.getMD5());
                if (same2) continue;
                this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
                continue;
            }
            e1 = this.work.loadElement(e3.id - (e3.id > lastCommonId ? deltaId : 0L), this.work.getAdminUser());
            e2 = this.master.loadElement(em.id, this.master.getAdminUser());
            same = e1.getMD5().equals(e2.getMD5());
            if (same) continue;
            this.tasks.add(new SynchronisationConflict(this.work, this.master, e3, em, event.getId()));
        }
        return this.getResult(this.tasks);
    }

    private boolean checkElementHistory(ArrayList<Date> history, Date dt) {
        long dttime = dt.getTime();
        for (Date dt0 : history) {
            long dt0time = dt0.getTime();
            long delta = dt0time - dttime;
            if (Math.abs(delta) >= 1000L) continue;
            return true;
        }
        return false;
    }

    public String getResult() {
        return this.getResult(this.tasks);
    }

    public String getResultDetails(ArrayList<SynchronisationTask> shownTasks) {
        StringBuilder sb = new StringBuilder();
        for (SynchronisationTask task : shownTasks) {
            sb.append(task.toString()).append("\n");
        }
        return sb.toString();
    }

    public String getResult(ArrayList<SynchronisationTask> shownTasks) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.app.getProject().getResourceText("sync.event") + ": '");
        sb.append(this.eventWorkTitle + "'");
        sb.append("\n... " + this.app.getProject().getResourceText("sync.copy-info") + ":");
        ArrayList<SynchronisationTask> selTasks = this.getKeytableTasks();
        sb.append(selTasks.size() == 0 ? "" : "\n- " + selTasks.size() + " " + this.app.getProject().getResourceText("sync.lists"));
        selTasks = this.getElementTasks("plan");
        sb.append(selTasks.size() == 0 ? "" : "\n- " + selTasks.size() + " " + this.app.getProject().getResourceText("sync.plans"));
        selTasks = this.getElementTasks("company");
        sb.append(selTasks.size() == 0 ? "" : "\n- " + selTasks.size() + " " + this.app.getProject().getResourceText("sync.contacts"));
        selTasks = this.getElementTasks("info");
        sb.append(selTasks.size() == 0 ? "" : "\n- " + selTasks.size() + " " + this.app.getProject().getResourceText("sync.documents"));
        selTasks = this.getElementTasks("locationtemplate");
        selTasks.addAll(this.getElementTasks("observationtemplate"));
        selTasks.addAll(this.getElementTasks("measuretemplate"));
        sb.append(selTasks.size() == 0 ? "" : "\n- " + selTasks.size() + " " + this.app.getProject().getResourceText("sync.templates"));
        selTasks = this.getElementTasks("location");
        sb.append(selTasks.size() == 0 ? "" : "\n- " + selTasks.size() + " " + this.app.getProject().getResourceText("sync.locations"));
        selTasks = this.getElementTasks("observation");
        sb.append(selTasks.size() == 0 ? "" : "\n- " + selTasks.size() + " " + this.app.getProject().getResourceText("sync.observations"));
        boolean conflicts = false;
        for (SynchronisationTask t : this.getConflictTasks()) {
            if (((SynchronisationConflict)t).isSolved()) continue;
            conflicts = true;
            break;
        }
        if (this.getConflictTasks().size() > 0) {
            if (conflicts) {
                sb.append("\n");
                sb.append(this.app.getProject().getResourceText("sync.conflicts"));
            } else {
                sb.append("\n");
                sb.append(this.app.getProject().getResourceText("sync.no-conflicts"));
            }
        }
        return sb.toString();
    }

    public ArrayList<SynchronisationTask> getKeytableTasks() {
        ArrayList<SynchronisationTask> ts = new ArrayList<SynchronisationTask>();
        for (SynchronisationTask t : this.tasks) {
            if (t.getCategory() != 1) continue;
            ts.add(t);
        }
        return ts;
    }

    public ArrayList<SynchronisationTask> getElementTasks(String elementtyp) {
        ArrayList<SynchronisationTask> ts = new ArrayList<SynchronisationTask>();
        ArrayList<SynchronisationTask> ts2 = new ArrayList<SynchronisationTask>();
        for (SynchronisationTask t : this.tasks) {
            if (t.getCategory() == 2 && t.getCode().equalsIgnoreCase(elementtyp)) {
                ts.add(t);
            }
            for (SynchronisationTask t2 : t.postTasks) {
                if (t2.getCategory() != 2 || !t2.getCode().equalsIgnoreCase(elementtyp)) continue;
                ts2.add(t2);
            }
        }
        ts.addAll(ts2);
        return ts;
    }

    public ArrayList<SynchronisationTask> getConflictTasks() {
        ArrayList<SynchronisationTask> ts = new ArrayList<SynchronisationTask>();
        for (SynchronisationTask t : this.tasks) {
            if (!(t instanceof SynchronisationConflict)) continue;
            ts.add(t);
        }
        return ts;
    }

    public void execute(ProgressHandler ph) {
        if (ThemisLicense.isLicenseLevelLessThan(ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        if (!this.master.isOpen()) {
            this.master.open(this.masterfile, null, null, false, null);
        }
        this.work.createActionLog("project_sync", 0L, this.master.getProjectFolder().getAbsolutePath() + "\nEvent-ID: " + this.idEventWork);
        int countTasks = this.tasks.size() + 1;
        int workunits = (int)(1.2 * (double)countTasks);
        ph.switchToDeterminate(workunits);
        this.master.getDatastorage().setSequenceValue("idelement", this.nextElementIdSequenceValue);
        if (this.updateIdsTask != null) {
            this.updateIdsTask.execute();
        }
        int counter = 1;
        ph.progress("Ereignisse \u00fcbertragen ...", counter++);
        for (SynchronisationTask synchronisationTask : this.tasks) {
            if ("event".equalsIgnoreCase(synchronisationTask.getCode())) {
                synchronisationTask.execute();
            }
            if ("user".equals(synchronisationTask.getCode())) {
                synchronisationTask.execute();
            }
            ++counter;
        }
        this.master.setCurrentEvent((CmsEvent)this.master.loadElement(this.idEventMaster, this.master.getUser()), false);
        int countConflicts = 0;
        for (SynchronisationTask synchronisationTask : this.tasks) {
            if (!(synchronisationTask instanceof SynchronisationConflict)) continue;
            ++countConflicts;
        }
        boolean bl = false;
        for (SynchronisationTask t : this.tasks) {
            ph.progress(counter++);
            if ("event".equalsIgnoreCase(t.getCode()) || "user".equalsIgnoreCase(t.getCode()) || t instanceof SynchronisationConflict) continue;
            t.execute();
            this.postTasks.addAll(t.getPostSynchronisationTasks());
            this.cleanupTasks.addAll(t.getCleanupTasks());
        }
        double d = this.postTasks.size() + this.cleanupTasks.size() + this.getConflictTasks().size();
        double taskStep = (double)(workunits - countTasks) / d;
        double postCounter = counter;
        for (SynchronisationTask t : this.postTasks) {
            ph.progress((int)(postCounter += taskStep));
            t.execute();
        }
        for (SynchronisationTask t : this.cleanupTasks) {
            ph.progress((int)(postCounter += taskStep));
            t.execute();
        }
        for (SynchronisationTask t : this.getConflictTasks()) {
            ph.progress((int)(postCounter += taskStep));
            t.execute();
        }
        this.tasks.clear();
        this.postTasks.clear();
        this.cleanupTasks.clear();
        this.updateIdsTask = null;
    }

    private void copyUploadItemsToMaster(CmsElement e, String attributecode, ThemisProject master) {
        for (UploadItem item : e.getUploadAttribute(attributecode).getAllUploadItems()) {
            try {
                File fitem = new File(this.work.getFileLocation(e.getElementcode()), item.getFilename());
                Util.copy((File)fitem, (File)new File(master.getProjectProperty("temp"), item.getName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            item.setNew(true);
        }
    }

    private void saveElementToMaster(CmsElement e, ThemisProject master, boolean copy, boolean ignoreRelations) {
        e.setApplication((CmsApplication)master);
        if (copy) {
            e.setNew(true);
        }
        e.save(false, ignoreRelations);
    }

    private void analyseKeytables() {
        List keytables = this.work.getKeytableNames();
        for (String keytable : keytables) {
            ArrayList copyIds = this.work.getKeytable(keytable).getIds();
            ArrayList masterIds = this.master.getKeytable(keytable).getIds();
            Iterator iterator = copyIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (masterIds.contains(id)) continue;
                for (String lang : this.work.getKeytable(keytable).getLanguages()) {
                    this.master.getKeytable(keytable).addTerm(id, lang, this.work.getKeytable(keytable).getTerm(id, lang));
                }
                this.master.getKeytable(keytable).save();
            }
        }
    }

    public void compareElement(CmsElement ele) {
        ele.getHistory();
    }
}

