/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.sync;

import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.Util;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SynchronisationTask {
    public static final int KEYTABLE = 1;
    public static final int ELEMENT = 2;
    public static final int SQL = 3;
    String language = null;
    ArrayList<SynchronisationTask> postTasks = new ArrayList();
    ArrayList<SynchronisationTask> cleanupTasks = new ArrayList();
    long idEvent = -1L;
    protected ThemisProject work = null;
    protected ThemisProject master = null;

    public SynchronisationTask(String lang) {
        this.language = lang;
    }

    public void setEvent(long id) {
        this.idEvent = id;
    }

    protected abstract void execute();

    public boolean hasPostSynchronisationTasks() {
        return !this.postTasks.isEmpty();
    }

    public void addPostSynchronisationTask(SynchronisationTask t) {
        this.postTasks.add(t);
    }

    public ArrayList<SynchronisationTask> getPostSynchronisationTasks() {
        return this.postTasks;
    }

    public boolean hasCleanupTasks() {
        return !this.cleanupTasks.isEmpty();
    }

    public void addCleanupTask(SynchronisationTask t) {
        this.cleanupTasks.add(t);
    }

    public ArrayList<SynchronisationTask> getCleanupTasks() {
        return this.cleanupTasks;
    }

    public abstract int getCategory();

    public abstract String getCode();

    public abstract String getTitle();

    public abstract long getIdWork();

    public abstract long getIdMaster();

    public abstract String getAction();

    public String toString() {
        return this.getCode() + ": " + this.getTitle() + "\n  ID: " + this.getIdWork() + " -> " + this.getIdMaster() + "\n  Action: " + this.getAction();
    }

    protected void updateUploads(CmsElement e) {
        ArrayList uploadAttributes = e.getUploadAttributes();
        for (UploadAttribute att : uploadAttributes) {
            for (UploadItem item : att.getAllUploadItems()) {
                item.createId();
                item.setNew(true);
                item.setStatus(2);
            }
        }
    }

    protected void copyElementHistory(long idWork, long idMaster) {
        TreeMap workHistories = this.work.getDatastorage().getElementHistory(idWork);
        TreeMap masterHistories = this.master.getDatastorage().getElementHistory(idMaster);
        for (Date dt : workHistories.keySet()) {
            if (masterHistories.keySet().contains(dt)) continue;
            try {
                this.master.getDatastorage().insertElementHistory(idMaster, Util.deflate((String)((String)workHistories.get(dt))));
            }
            catch (SQLException ex) {
                Logger.getLogger(SynchronisationTask.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

