/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.sync;

import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.sync.SynchronisationTask;
import java.util.List;

public class UpdateMultipleElementIds
extends SynchronisationTask {
    private long minimumId = -1L;
    private long delta = -1L;
    private ThemisProject project = null;

    public UpdateMultipleElementIds(ThemisProject p, long lastId, long delta) {
        super(p.getUser().getCurrentLanguage());
        this.project = p;
        this.minimumId = lastId;
        this.delta = delta;
    }

    @Override
    public void execute() {
        List recs = this.project.getDatastorage().executeQuery("SELECT idelement AS id FROM tdtaelement WHERE idelement > " + this.minimumId + " ORDER BY idelement DESC", true).getResult();
        for (DataRecord rec : recs) {
            this.project.getDatastorage().executeUpdate("UPDATE tdtaElement SET idelement = idelement + " + this.delta + " WHERE idelement = " + rec.getLong("id"), true);
        }
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleProject SET projectid = projectid + " + this.delta + " WHERE projectid >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaElePlan SET calibplanfile = calibplanfile + " + this.delta + " WHERE calibplanfile >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaElePlan SET currentplanfile = currentplanfile + " + this.delta + " WHERE currentplanfile >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET idplan = idplan + " + this.delta + " WHERE idplan >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET idbuilding = idbuilding + " + this.delta + " WHERE idbuilding >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocation SET templateid = templateid + " + this.delta + " WHERE templateid >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservation SET templateid = templateid + " + this.delta + " WHERE templateid >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLog SET observationid = observationid + " + this.delta + " WHERE observationid >= " + this.minimumId, true);
        this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLog SET eventid = eventid + " + this.delta + " WHERE eventid >= " + this.minimumId, true);
    }

    @Override
    public int getCategory() {
        return 2;
    }

    @Override
    public String getCode() {
        return "divers";
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public long getIdWork() {
        return this.minimumId;
    }

    @Override
    public long getIdMaster() {
        return this.minimumId + this.delta;
    }

    @Override
    public String getAction() {
        return "Element-IDs anpassen: Um " + this.delta + " erh\u00f6hen";
    }
}

