/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.template;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.openide.util.Exceptions;

public class DemoPackManager {
    private static DemoPackManager instance;
    public static final String TEMPLATE_FILENAME = "templates.xml";
    public final String urlbase = ThemisApplication.getInstance().getSettings().getTemplateDownloadURL();
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    int versionServer = 1;
    int versionLocal = 0;
    boolean ignoreNewVersion = false;
    int fileCount = 0;
    ArrayList<TemplateDescription> projekte = new ArrayList();
    ArrayList<TemplateDescription> projektvorlagen = new ArrayList();
    ArrayList<TemplateDescription> protokollvorlagen = new ArrayList();

    public static DemoPackManager getInstance() {
        if (instance == null) {
            instance = new DemoPackManager();
        }
        return instance;
    }

    private DemoPackManager() {
        if (!new File(ThemisApplication.getInstance().getApplicationDataTemplatesFolder(), TEMPLATE_FILENAME).exists()) {
            this.createFromSource();
        }
        Document docLocal = this.readXmlFromFolder(this.app.getApplicationDataTemplatesFolder());
        Document docServer = this.readXmlFromServer();
        if (docLocal == null && docServer == null) {
            this.app.getDialog().showErrorDialog(this.project.getResourceText("ThemisApplication.errorLoadingXML.text", this.app.getLocale()));
            this.versionLocal = 0;
            this.versionServer = 0;
            return;
        }
        if (docLocal != null) {
            String verLocal = docLocal.getRootElement().getAttributeValue("version", "1");
            this.versionLocal = Util.parseInt((String)verLocal, (int)1);
        }
        if (docServer == null) {
            this.versionServer = 0;
            this.readTemplatesFromFile();
            return;
        }
        String verServer = docServer.getRootElement().getAttributeValue("version", "1");
        this.versionServer = Util.parseInt((String)verServer, (int)1);
        if (docLocal == null) {
            this.versionLocal = 0;
            return;
        }
        this.readTemplatesFromFile();
    }

    public void createFromSource() {
        File f = ThemisApplication.getInstance().getApplicationDataTemplatesFolder();
        f.mkdirs();
        File output = new File(f, "templates.zip");
        Util.deleteContent((File)f);
        try {
            InputStream is = DemoPackManager.class.getResourceAsStream("/at/grid/themis/ontology/media/templates.zip");
            FileOutputStream os = new FileOutputStream(output);
            Util.copy((InputStream)is, (OutputStream)os);
            Util.unzip((File)output, (File)f);
            output.delete();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void setIgnoreNewVersion() {
        this.ignoreNewVersion = true;
    }

    public boolean isNewVersionAvailable() {
        return !this.ignoreNewVersion && this.versionServer > this.versionLocal;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    private Document readXmlFromServer() {
        try {
            String conf = ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0");
            if ("1".equals(conf)) {
                String fldName = ThemisApplication.getInstance().getConfiguration("system.update.source");
                return this.readXmlFromFolder(new File(fldName));
            }
            SAXBuilder builder = new SAXBuilder();
            URL url = new URL(this.urlbase + TEMPLATE_FILENAME);
            boolean available = this.checkServerConnection(url);
            if (available) {
                return builder.build(url.openStream());
            }
        }
        catch (JDOMException ex) {
            this.project.getLogger().log(Level.WARNING, "Error while parsing XML: " + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            this.project.getLogger().log(Level.WARNING, "Error while reading file: " + ex.getMessage());
            return null;
        }
        return null;
    }

    private Document readXmlFromFolder(File folder) {
        if (folder == null) {
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            File fXml = new File(folder, TEMPLATE_FILENAME);
            if (!fXml.isFile()) {
                File installFolder = new File("templates");
                Util.copy((File)installFolder, (File)folder);
            }
            if (fXml.isFile()) {
                return builder.build(fXml);
            }
            this.project.getLogger().log(Level.WARNING, "File not found: " + fXml.getAbsolutePath());
        }
        catch (JDOMException ex) {
            this.project.getLogger().log(Level.WARNING, "Error while parsing XML: " + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            this.project.getLogger().log(Level.WARNING, "Error while reading file: " + ex.getMessage());
            return null;
        }
        return null;
    }

    private boolean checkServerConnection(URL url) {
        boolean alive = false;
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(5000);
            connection.connect();
            alive = true;
            Object var3_3 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return alive;
    }

    private ArrayList<TemplateDescription> getTemplateDescriptions(Document doc, String path) {
        ArrayList<TemplateDescription> tds = new ArrayList<TemplateDescription>();
        try {
            List eles = XPath.selectNodes((Object)doc.getRootElement(), (String)path);
            for (Element e : eles) {
                TemplateDescription td = TemplateDescription.createFromXml(e, "de");
                if (!td.checkLicense()) continue;
                td.setServer(this.urlbase);
                tds.add(td);
            }
        }
        catch (JDOMException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return tds;
    }

    public synchronized void downloadTemplates(ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ph.switchToDeterminate(this.getFileCount() + 1);
        Document doc = this.readXmlFromServer();
        if (doc == null) {
            return;
        }
        File folder = ThemisApplication.getInstance().getApplicationDataTemplatesFolder();
        Util.deleteContent((File)folder);
        int count = 0;
        ph.progress("Projektbeispiele werden geladen...");
        for (TemplateDescription td : this.getTemplateDescriptions(doc, "/vorlagen/projects/project")) {
            ph.progress(++count);
            if (td.checkLicense()) {
                td.download(folder);
            }
            if (!ph.isCancelled()) continue;
            return;
        }
        ph.progress("Projektvorlagen werden geladen...");
        for (TemplateDescription td : this.getTemplateDescriptions(doc, "/vorlagen/projecttemplates/projecttemplate")) {
            ph.progress(++count);
            td.download(folder);
            if (!ph.isCancelled()) continue;
            return;
        }
        ph.progress("Berichtsvorlagen werden geladen...");
        for (TemplateDescription td : this.getTemplateDescriptions(doc, "/vorlagen/reporttemplates/reporttemplate")) {
            ph.progress(++count);
            td.download(folder);
            if (!ph.isCancelled()) continue;
            return;
        }
        try {
            ph.progress("Beschreibungen werden geladen...");
            String conf = ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0");
            File targetFile = new File(folder, TEMPLATE_FILENAME);
            if ("1".equals(conf)) {
                String fldName = ThemisApplication.getInstance().getConfiguration("system.update.source");
                Util.copy((File)new File(fldName, TEMPLATE_FILENAME), (File)targetFile);
            } else {
                Util.copy((URL)new URL(this.urlbase + TEMPLATE_FILENAME), (File)targetFile);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ph.progressDone();
        String verLocal = doc.getRootElement().getAttributeValue("version", "1");
        this.versionLocal = Util.parseInt((String)verLocal, (int)1);
        this.readTemplatesFromFile();
    }

    public void readTemplatesFromFile() {
        Document doc = this.readXmlFromFolder(this.app.getApplicationDataTemplatesFolder());
        if (doc == null) {
            return;
        }
        this.projekte.clear();
        this.projektvorlagen.clear();
        this.protokollvorlagen.clear();
        this.fileCount = 0;
        for (TemplateDescription td : this.getTemplateDescriptions(doc, "/vorlagen/projects/project")) {
            if (!td.isAvailable()) continue;
            this.projekte.add(td);
            ++this.fileCount;
        }
        for (TemplateDescription td : this.getTemplateDescriptions(doc, "/vorlagen/projecttemplates/projecttemplate")) {
            if (!td.isAvailable()) continue;
            this.projektvorlagen.add(td);
            ++this.fileCount;
        }
        for (TemplateDescription td : this.getTemplateDescriptions(doc, "/vorlagen/reporttemplates/reporttemplate")) {
            if (!td.isAvailable()) continue;
            this.protokollvorlagen.add(td);
            ++this.fileCount;
        }
    }

    public ArrayList<TemplateDescription> getProjectTemplates() {
        return this.projektvorlagen;
    }

    public ArrayList<TemplateDescription> getProtokollTemplates() {
        return this.protokollvorlagen;
    }

    public ArrayList<TemplateDescription> getProjects() {
        return this.projekte;
    }

    public static boolean isValidTemplateFile(File f) {
        return f != null && f.isFile() && (f.getName().toLowerCase().endsWith(".xlsx") || f.getName().toLowerCase().endsWith(".themis"));
    }
}

