/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.template;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.jdom.Element;

public class TemplateDescription {
    public String serverUrl = null;
    public String folder = "";
    public String file = null;
    public boolean unzip = false;
    public String image = null;
    public String title = null;
    public String licensetag = null;
    public String description = null;
    public String show = null;
    public String hint = null;
    public int build = 0;
    Type type = Type.INTERNAL;

    public TemplateDescription() {
    }

    public TemplateDescription(String title) {
        this.title = title;
    }

    public TemplateDescription(String title, String file) {
        this.title = title;
        this.file = file;
    }

    public static TemplateDescription createFileSource() {
        TemplateDescription td = new TemplateDescription();
        td.title = ThemisApplication.getInstance().getProject().getResourceText("template.from-file");
        td.description = ThemisApplication.getInstance().getProject().getResourceText("template.from-file-msg");
        td.type = Type.FILE;
        return td;
    }

    public static TemplateDescription createNoSource() {
        TemplateDescription td = new TemplateDescription();
        td.title = ThemisApplication.getInstance().getProject().getResourceText("template.no-template");
        td.description = ThemisApplication.getInstance().getProject().getResourceText("template.no-template-msg");
        td.type = Type.NONE;
        return td;
    }

    public void setType(Type t) {
        this.type = t;
    }

    public boolean isFile() {
        return this.type == Type.FILE;
    }

    public boolean isInternal() {
        return this.type == Type.INTERNAL;
    }

    public static TemplateDescription createFromXml(Element e, String lang) {
        TemplateDescription td = new TemplateDescription();
        if (e.getChild("file") == null) {
            return td;
        }
        td.file = e.getChildText("file");
        td.unzip = "true".equalsIgnoreCase(e.getChild("file").getAttributeValue("unzip"));
        td.folder = e.getChildText("folder");
        if (td.folder != null && !"".equals(td.folder) && !td.folder.endsWith("/")) {
            td.folder = td.folder + "/";
        }
        td.image = e.getChildText("image");
        if (td.image != null && "".equals(td.image.trim())) {
            td.image = null;
        }
        td.title = e.getChildText("title");
        td.licensetag = e.getChildText("license");
        td.hint = e.getChildText("hint");
        td.build = Util.parseInt((String)e.getChildText("build"), (int)0);
        td.description = e.getChildText("description");
        td.show = e.getChildText("show");
        return td;
    }

    public TemplateDescription setServer(String u) {
        this.serverUrl = u;
        return this;
    }

    public boolean checkLicense() {
        if (this.licensetag == null) {
            return true;
        }
        return ThemisApplication.getInstance().getLicense().hasFeature(this.licensetag);
    }

    public URL getURL() {
        if (this.serverUrl == null) {
            return this.getClass().getResource("/at/grid/themis/ontology/media/vorlagen/" + this.file);
        }
        try {
            return new URL(this.serverUrl + this.folder + this.file);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public URL getImageURL() {
        if (this.image == null) {
            return null;
        }
        if (this.serverUrl == null) {
            return this.getClass().getResource("/at/grid/themis/ontology/media/vorlagen/" + this.image);
        }
        try {
            return new URL(this.serverUrl + this.folder + this.image);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean download(File fld) {
        fld = new File(fld, this.folder);
        fld.mkdirs();
        File f = new File(fld, this.file);
        try {
            InputStream is;
            String conf = ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0");
            if ("1".equals(conf)) {
                String fldName = ThemisApplication.getInstance().getConfiguration("system.update.source");
                File fldSource = new File(new File(fldName), this.folder);
                File fSource = new File(fldSource, this.file);
                is = new FileInputStream(fSource);
            } else {
                URL url = this.getURL();
                is = url.openStream();
            }
            FileOutputStream fos = new FileOutputStream(f);
            Util.copy((InputStream)is, (OutputStream)fos);
            Util.closeStream((Closeable)is);
            Util.closeStream((Closeable)fos);
        }
        catch (IOException e) {
            ThemisApplication.getInstance().getDialog().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("info.unpack-failed"), e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(File fld) {
        boolean resultOk = false;
        FileOutputStream fos = null;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        try {
            File f = new File(fld, this.file);
            File folder0 = ThemisApplication.getInstance().getApplicationDataTemplatesFolder();
            File f0 = new File(new File(folder0, this.folder), this.file);
            if (f0.isFile()) {
                Util.copy((File)f0, (File)f);
            } else {
                URL url = this.getURL();
                fos = new FileOutputStream(f);
                InputStream is = url.openStream();
                Util.copy((InputStream)is, (OutputStream)fos);
                Util.closeStream((Closeable)is);
                Util.closeStream((Closeable)fos);
            }
            if (!f.isFile()) {
                return false;
            }
            if (this.unzip) {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(f), Charset.forName("Cp437"));
                byte[] buffer = new byte[2048];
                while ((entry = zis.getNextEntry()) != null) {
                    project.getLogger().fine("extracting file from ZIP: " + entry.getName());
                    if (entry.isDirectory()) {
                        project.getFileAccess().mkdirs(new File(fld, entry.getName()));
                        continue;
                    }
                    try {
                        File fEntry = new File(fld, entry.getName());
                        project.getFileAccess().mkdirs(fEntry.getParentFile());
                        fos = new FileOutputStream(fEntry);
                        int len = 0;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        resultOk = true;
                    }
                    catch (IOException e) {
                        ThemisApplication.getInstance().getDialog().showErrorDialog(project.getResourceText("info.unpack-failed"), e);
                        project.getLogger().severe("Error while unpacking ZIP: " + e.getMessage());
                    }
                    catch (Exception e) {
                        ThemisApplication.getInstance().getDialog().showErrorDialog(project.getResourceText("info.unpack-failed"), e);
                        project.getLogger().severe("Error while unpacking ZIP: " + e.getMessage());
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                    }
                }
                zis.close();
                f.delete();
            }
            return true;
        }
        catch (IOException e) {
            ThemisApplication.getInstance().getDialog().showErrorDialog(project.getResourceText("info.unpack-failed"), e);
            return resultOk;
        }
    }

    public BufferedImage getImage() {
        try {
            URL url = this.getImageURL();
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            BufferedImage bi = ImageIO.read(is);
            is.close();
            return bi;
        }
        catch (IOException e) {
            ThemisApplication.getInstance().getDialog().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("info.unpack-failed"), e);
            return null;
        }
    }

    public void setShow(String fn) {
        this.show = fn;
    }

    public boolean doShow() {
        return this.show != null;
    }

    public File getFileToShow() {
        File folder0 = ThemisApplication.getInstance().getApplicationDataTemplatesFolder();
        File f0 = new File(new File(folder0, this.folder), this.show == null ? this.file : this.show);
        return f0;
    }

    public File getFile() {
        File folder0 = ThemisApplication.getInstance().getApplicationDataTemplatesFolder();
        File f0 = new File(new File(folder0, this.folder), this.file);
        return f0;
    }

    public String toString() {
        return this.title;
    }

    public boolean hasHint() {
        return this.hint != null && !"".equals(this.hint);
    }

    public String getHint() {
        return this.hint;
    }

    public boolean isAvailable() {
        int appbuild = 2146;
        return this.build <= appbuild;
    }

    static enum Type {
        NONE,
        FILE,
        INTERNAL;

    }
}

