/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.template;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.gui.Point;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsLocationgroup;
import at.grid.themis.ontology.element.CmsMeasureTemplate;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openide.util.Exceptions;
import org.xml.sax.InputSource;

public class TemplateManager {
    public static final int CURRENT_FILE_VERSION = 19;
    public static final int PROJECT = 0;
    public static final int PROJECTTEMPLATE = 1;
    public static final int REPORTTEMPLATE = 2;
    ThemisProject project;
    ThemisApplication app;
    HashMap<String, Integer> colGroup = new HashMap();
    HashMap<String, Integer> colLocation = new HashMap();
    HashMap<String, Integer> colObservation = new HashMap();
    HashMap<String, Integer> colMeasure = new HashMap();
    HashMap<String, Integer> colContact = new HashMap();
    HashMap<String, Integer> colDocument = new HashMap();
    HashMap<String, Integer> colIcon = new HashMap();
    int lastEditColumn = 22;
    ArrayList<CellStyle> cellstyles = new ArrayList();
    boolean ignoreDisclaimer = false;
    boolean internalRead = false;
    ArrayList<TemplateDescription> projekte = new ArrayList();
    ArrayList<TemplateDescription> projektvorlagen = new ArrayList();
    ArrayList<TemplateDescription> protokollvorlagen = new ArrayList();
    private ArrayList<String> zipEntries = new ArrayList();
    private String iconfoldername = "icons/";
    private String documentsfoldername = "documents/";
    private boolean templateMatchByTitle = false;
    private boolean removeMissingAfterLoad = false;
    ArrayList<Long> missingTemplateIds = new ArrayList();
    private int colUUID;
    boolean overwriteUUIDalreadyInUse = false;
    boolean createnewUUIDalreadyInUse = false;
    boolean ignoreUUIDalreadyInUse = false;
    private Properties loadResult = new Properties();
    private boolean withTemplates = true;
    private boolean withDocuments = true;
    private boolean withContacts = true;
    private boolean withIcons = true;
    private boolean withKeytables = true;
    private boolean withSettings = true;
    private int countTemplate;
    private int countForm;
    private int countIcon;
    private int countContact;
    private int countDocument;
    private int countReportTemplate;

    public TemplateManager(ThemisApplication a, ThemisProject p) {
        this.app = a;
        this.project = p;
    }

    private ThemisSettings getSettings() {
        return this.app.getSettings();
    }

    public void readInternalTemplates() {
        DemoPackManager demo = DemoPackManager.getInstance();
        this.projekte.clear();
        this.projekte.addAll(demo.getProjects());
        this.projektvorlagen.clear();
        this.projektvorlagen.addAll(demo.getProjectTemplates());
        this.protokollvorlagen.clear();
        this.protokollvorlagen.addAll(demo.getProtokollTemplates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TemplateDescription unpackProject(TemplateDescription td, File folder) {
        try {
            ZipEntry entry;
            URL url = td.getURL();
            if (url == null) {
                this.app.getDialog().showErrorDialog(this.project.getResourceText("info.unpack-failed"));
                return null;
            }
            ZipInputStream zis = new ZipInputStream(url.openStream(), Charset.forName("Cp437"));
            FileOutputStream fos = null;
            byte[] buffer = new byte[2048];
            folder.mkdirs();
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    if (td.show == null) {
                        td.setShow(entry.getName());
                    }
                    new File(folder, entry.getName()).mkdirs();
                    continue;
                }
                try {
                    File f = new File(folder, entry.getName());
                    f.getParentFile().mkdirs();
                    fos = new FileOutputStream(f);
                    int len = 0;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                catch (IOException e) {
                    this.project.getLogger().severe("Error while unpacking ZIP: " + e.getMessage());
                    TemplateDescription templateDescription = null;
                    return templateDescription;
                }
                catch (Exception e) {
                    this.project.getLogger().severe("Error while unpacking ZIP: " + e.getMessage());
                    TemplateDescription templateDescription = null;
                    return templateDescription;
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                }
            }
            return td;
        }
        catch (IOException e2) {
            this.app.getDialog().showErrorDialog(this.project.getResourceText("info.unpack-failed"), e2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unpackProjecttemplate(TemplateDescription td, File projectfolder) {
        try {
            if (this.app.getLicense().isTestLicense()) {
                this.app.getDialog().showWarningDialog("warning.testlicense.noiconsave");
                return false;
            }
            CmsProject projectelement = this.app.getProject().getProjectElement();
            String uuidString = null;
            uuidString = projectelement != null ? this.app.getProject().getProjectElement().getUUID().toString() : Long.toString(new Date().getTime());
            File folder = new File(this.app.getApplicationDataTempFolder(), uuidString);
            this.project.getFileAccess().mkdirs(folder);
            URL url = td.getURL();
            this.project.getLogger().fine("extracting template XLSX file from ZIP: " + td.file);
            FileOutputStream fos = new FileOutputStream(new File(folder, td.file + ".xlsx"));
            Util.copy((InputStream)url.openStream(), (OutputStream)fos);
            fos.close();
            URL url2 = td.getURL();
            if (url2 != null) {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(url2.openStream(), Charset.forName("Cp437"));
                byte[] buffer = new byte[2048];
                while ((entry = zis.getNextEntry()) != null) {
                    boolean bl;
                    this.project.getLogger().fine("extracting file from ZIP: " + entry.getName());
                    if (entry.isDirectory()) {
                        this.project.getFileAccess().mkdirs(new File(folder, entry.getName()));
                        continue;
                    }
                    try {
                        File f = new File(folder, entry.getName());
                        this.project.getFileAccess().mkdirs(f.getParentFile());
                        fos = new FileOutputStream(f);
                        int len = 0;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    catch (IOException e) {
                        this.app.getDialog().showErrorDialog(this.project.getResourceText("info.unpack-failed"), e);
                        this.project.getLogger().severe("Error while unpacking ZIP: " + e.getMessage());
                        bl = false;
                        return bl;
                    }
                    catch (Exception e) {
                        this.app.getDialog().showErrorDialog(this.project.getResourceText("info.unpack-failed"), e);
                        this.project.getLogger().severe("Error while unpacking ZIP: " + e.getMessage());
                        bl = false;
                        return bl;
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                    }
                }
            }
            this.project.getFileAccess().copy(folder, projectfolder);
            this.project.getFileAccess().delete(folder);
            return true;
        }
        catch (IOException e) {
            this.app.getDialog().showErrorDialog(this.project.getResourceText("info.unpack-failed"), e);
            return false;
        }
    }

    public boolean unpackReporttemplate(TemplateDescription td, File folder) {
        try {
            URL url = td.getURL();
            FileOutputStream fos = new FileOutputStream(new File(folder, td.file + ".xlsx"));
            Util.copy((InputStream)url.openStream(), (OutputStream)fos);
            fos.close();
            return true;
        }
        catch (IOException e) {
            this.app.getDialog().showErrorDialog(this.project.getResourceText("info.unpack-failed"), e);
            return false;
        }
    }

    public ArrayList<TemplateDescription> getProjectTemplates() {
        return this.projektvorlagen;
    }

    public ArrayList<TemplateDescription> getProtokollTemplates() {
        return this.protokollvorlagen;
    }

    public ArrayList<TemplateDescription> getProjects() {
        return this.projekte;
    }

    public boolean isIgnoreDisclaimer() {
        return this.ignoreDisclaimer;
    }

    public void setIgnoreDisclaimer(boolean ignoreDisclaimer) {
        this.ignoreDisclaimer = ignoreDisclaimer;
    }

    private void createColumnSpecification(int fileversion) {
        this.colUUID = 4;
        if (fileversion < 11) {
            this.colUUID = -1;
        }
        this.colGroup.clear();
        this.colGroup.put("title", 2);
        if (fileversion >= 11) {
            this.colGroup.put("meta_uuid", 4);
        } else if (fileversion >= 4) {
            this.colGroup.put("meta_lastedit", 4);
        }
        if (fileversion >= 9) {
            this.colGroup.put("description", 3);
            this.colGroup.put("chapter", 5);
        }
        int cc = 1;
        this.colLocation.clear();
        this.colLocation.put(fileversion >= 12 ? "title" : "title", ++cc);
        this.colLocation.put(fileversion >= 12 ? "description" : "description", ++cc);
        if (fileversion >= 11) {
            this.colLocation.put("meta_uuid", ++cc);
        } else if (fileversion >= 4) {
            this.colLocation.put("meta_lastedit", ++cc);
        }
        if (fileversion >= 12) {
            this.colLocation.put("prefixsuffix", ++cc);
            this.colLocation.put("suffix", ++cc);
        }
        this.colLocation.put(fileversion >= 12 ? "text1" : "code", ++cc);
        this.colLocation.put(fileversion >= 12 ? "text2" : "code2", ++cc);
        if (fileversion >= 12) {
            this.colLocation.put("text3", ++cc);
            this.colLocation.put("text4", ++cc);
            this.colLocation.put("longtext1", ++cc);
            this.colLocation.put("longtext2", ++cc);
            this.colLocation.put("longtext3", ++cc);
            this.colLocation.put("longtext4", ++cc);
        }
        if (fileversion >= 4) {
            this.colLocation.put(fileversion >= 12 ? "barcode" : "barcode", ++cc);
        }
        this.colLocation.put(fileversion >= 12 ? "list1" : "list1", ++cc);
        if (fileversion >= 5) {
            this.colLocation.put(fileversion >= 12 ? "list2" : "list2", ++cc);
        }
        if (fileversion >= 12) {
            this.colLocation.put("list3", ++cc);
            this.colLocation.put("list4", ++cc);
            this.colLocation.put("date1", ++cc);
            this.colLocation.put("date2", ++cc);
            this.colLocation.put("date3", ++cc);
            this.colLocation.put("date4", ++cc);
            this.colLocation.put("boolean1", ++cc);
            this.colLocation.put("boolean2", ++cc);
            this.colLocation.put("boolean3", ++cc);
            this.colLocation.put("boolean4", ++cc);
        }
        if (fileversion <= 11) {
            this.colLocation.put("quantity", ++cc);
            this.colLocation.put("dimwidth", ++cc);
            this.colLocation.put("dimheight", ++cc);
            this.colLocation.put("dimdiameter", ++cc);
            this.colLocation.put("dimarea", ++cc);
            this.colLocation.put("icon_title", ++cc);
            this.colLocation.put("icon_file", ++cc);
        }
        if (fileversion >= 12) {
            this.colLocation.put("icon", ++cc);
        }
        if (fileversion >= 5) {
            this.colLocation.put(fileversion >= 12 ? "showalways" : "showalways", ++cc);
        }
        if (fileversion >= 6 && fileversion <= 11) {
            this.colLocation.put("prenumber", ++cc);
            this.colLocation.put("postnumber", ++cc);
        }
        this.colLocation.put(fileversion >= 12 ? "documents" : "infos", ++cc);
        this.colObservation.clear();
        cc = 1;
        if (fileversion == 1) {
            this.colObservation.put("title", 2);
            this.colObservation.put("description", 3);
            this.colObservation.put("code", 4);
            this.colObservation.put("observationtype", 5);
            this.colObservation.put("topic", 6);
            this.colObservation.put("priority", 7);
            this.colObservation.put("quantity", 8);
            this.colObservation.put("responsible", 9);
            this.colObservation.put("duedate", 10);
            this.colObservation.put("idrepeat", 11);
            this.colObservation.put("done", 12);
            this.colObservation.put("infos", 13);
        } else {
            this.colObservation.put(fileversion >= 12 ? "title" : "title", ++cc);
            this.colObservation.put(fileversion >= 12 ? "description" : "description", ++cc);
            if (fileversion >= 11) {
                this.colObservation.put("meta_uuid", ++cc);
            } else if (fileversion >= 4) {
                this.colObservation.put("meta_lastedit", ++cc);
            }
            this.colObservation.put(fileversion >= 12 ? "text1" : "code", ++cc);
            if (fileversion >= 7) {
                this.colObservation.put(fileversion >= 12 ? "text2" : "freetext1", ++cc);
                this.colObservation.put(fileversion >= 12 ? "text3" : "freetext2", ++cc);
                this.colObservation.put(fileversion >= 12 ? "text4" : "freetext3", ++cc);
                this.colObservation.put(fileversion >= 12 ? "longtext1" : "langtext1", ++cc);
                this.colObservation.put(fileversion >= 12 ? "longtext2" : "langtext2", ++cc);
            }
            this.colObservation.put(fileversion >= 12 ? "measure" : "measure", ++cc);
            if (fileversion >= 8) {
                this.colObservation.put(fileversion >= 12 ? "list1" : "topic", ++cc);
                this.colObservation.put(fileversion >= 12 ? "list2" : "observationtype", ++cc);
                this.colObservation.put(fileversion >= 12 ? "list3" : "priority", ++cc);
            } else {
                this.colObservation.put("observationtype", ++cc);
                this.colObservation.put("topic", ++cc);
                this.colObservation.put("priority", ++cc);
            }
            if (fileversion >= 3 && fileversion < 7) {
                this.colObservation.put("freetext1", ++cc);
                this.colObservation.put("freetext2", ++cc);
                this.colObservation.put("freetext3", ++cc);
            }
            if (fileversion >= 15) {
                this.colObservation.put("float1", ++cc);
                this.colObservation.put("float2", ++cc);
                this.colObservation.put("float3", ++cc);
                this.colObservation.put("float4", ++cc);
            }
            if (fileversion <= 11) {
                this.colObservation.put(fileversion >= 12 ? "duedate" : "duedate", ++cc);
            }
            this.colObservation.put(fileversion >= 12 ? "repeat" : "repeat", ++cc);
            if (fileversion >= 12) {
                this.colObservation.put("repeatunit", ++cc);
            }
            this.colObservation.put(fileversion >= 12 ? "done" : "done", ++cc);
            this.colObservation.put(fileversion >= 12 ? "responsible" : "responsible", ++cc);
            if (fileversion <= 11) {
                this.colObservation.put("quantity", ++cc);
            }
            this.colObservation.put("infos", ++cc);
        }
        cc = 1;
        this.colMeasure.clear();
        this.colMeasure.put("title", ++cc);
        this.colMeasure.put("measure", ++cc);
        if (fileversion >= 11) {
            this.colMeasure.put("meta_uuid", ++cc);
        } else if (fileversion >= 4) {
            this.colMeasure.put("meta_lastedit", ++cc);
        }
        this.colContact.clear();
        this.colContact.put("name", 1);
        this.colContact.put("tel", 2);
        this.colContact.put("email", 3);
        this.colIcon.clear();
        this.colIcon.put("title", 1);
        this.colIcon.put("file", 2);
        this.colDocument.clear();
        this.colDocument.put("title", 1);
        this.colDocument.put("comment", 2);
        this.colDocument.put("documenttype", 3);
        this.colDocument.put("date", 4);
        this.colDocument.put("files", 5);
    }

    private HashMap<String, Long> loadExistingGroups(long idparent, boolean useUUID) {
        String parentWhere;
        String string = parentWhere = idparent > 0L ? " AND t.parentgroup = " + idparent : " AND (t.parentgroup IS NULL OR t.parentgroup <= 0)";
        if (idparent == -99L) {
            parentWhere = "";
        }
        List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement,t.titel,e.uuid FROM tdtaelelocationgroup AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE (not e.deleted " + parentWhere + ") ", true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            if (useUUID) {
                map.put(rec.get("uuid"), rec.getLong("idelement"));
                continue;
            }
            map.put(rec.get("titel").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    private HashMap<String, Long> loadExistingLocationTemplates(long lastgroup, boolean useUUID) {
        List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement,t.titel,t.idgroup,e.uuid FROM tdtaelelocationtemplate AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE (not e.deleted) AND idgroup " + (lastgroup < 0L ? " IS NULL" : " = " + Long.toString(lastgroup)), true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            if (useUUID) {
                map.put(rec.get("uuid"), rec.getLong("idelement"));
                continue;
            }
            map.put(rec.get("titel").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    private HashMap<String, Long> loadExistingGroupObservationTemplates(long lastgroup, boolean useUUID) {
        List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement,t.title,t.idlocation,t.idlocationgroup,e.uuid FROM tdtaeleobservationtemplate AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE (NOT e.deleted) AND (idlocationgroup " + (lastgroup < 0L ? " IS NULL OR idlocationgroup<0)" : " = " + Long.toString(lastgroup) + ")"), true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            if (useUUID) {
                map.put(rec.get("uuid"), rec.getLong("idelement"));
                continue;
            }
            map.put(rec.get("title").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    private HashMap<String, Long> loadExistingObservationTemplates(long lastgroup, boolean useUUID) {
        String sql = "SELECT t.idelement,t.title,t.idlocation,t.idlocationgroup,e.uuid FROM tdtaeleobservationtemplate AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE (not e.deleted) AND idlocation " + (lastgroup < 0L ? " IS NULL" : " = " + Long.toString(lastgroup));
        List recs = this.project.getDatastorage().executeQuery(sql, true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            if (useUUID) {
                map.put(rec.get("uuid"), rec.getLong("idelement"));
                continue;
            }
            map.put(rec.get("title").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    private HashMap<String, Long> loadExistingObservationTemplatesWithUUID() {
        String sql = "SELECT t.idelement,t.title,t.idlocation,t.idlocationgroup,e.uuid FROM tdtaeleobservationtemplate AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE (not e.deleted) ";
        List recs = this.project.getDatastorage().executeQuery(sql, true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            map.put(rec.get("uuid"), rec.getLong("idelement"));
        }
        return map;
    }

    public HashMap<String, Long> loadExistingMeasureTemplates(long lastgroup) {
        List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement,t.titel,t.idlocation,e.uuid FROM tdtaelemeasuretemplate AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE (NOT e.deleted) AND (idlocation " + (lastgroup < 0L ? " IS NULL OR idlocation<0)" : " = " + Long.toString(lastgroup) + ")"), true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            map.put(rec.get("titel").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    public HashMap<String, Long> loadExistingContacts() {
        List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement,t.name,e.uuid FROM tdtaelecompany AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE NOT e.deleted ", true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            map.put(rec.get("name").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    public HashMap<String, Long> loadExistingDocuments() {
        List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement,t.title,e.uuid FROM tdtaeleinfo AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE NOT e.deleted", true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            map.put(rec.get("title").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    public HashMap<String, Long> loadExistingIcons() {
        List recs = this.project.getDatastorage().executeQuery("SELECT t.idelement,t.title,e.uuid FROM tdtaeleicon AS t INNER JOIN tdtaElement AS e ON (t.idelement=e.idelement) WHERE NOT e.deleted", true).getResult();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (DataRecord rec : recs) {
            map.put(rec.get("title").trim(), rec.getLong("idelement"));
        }
        return map;
    }

    public boolean loadTemplate(File f) {
        if (f.getName().toLowerCase().endsWith(".xml")) {
            this.app.getDialog().showErrorDialog("XML-Vorlagen werden nicht mehr unterst\u00fctzt.");
            return false;
        }
        return this.loadTemplatesFromXls(null, null, f);
    }

    public int getFileVersion(Sheet sheet, int defaultvalue) {
        try {
            if ("".equals(this.getCellValue(sheet, 1, 7))) {
                return defaultvalue;
            }
            return Integer.parseInt(this.getCellValue(sheet, 1, 7));
        }
        catch (Exception exception) {
            return defaultvalue;
        }
    }

    public boolean checkFileVersion(int v) {
        if (v > 19) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nDie Projektvorlage hat eine Version, die noch nicht unterst\u00fctzt wird.");
            return false;
        }
        return true;
    }

    public void writeFileVersionToSheet(Sheet sheet) {
        this.getCell(sheet, 1, 6).setCellValue("Version:");
        this.getCell(sheet, 1, 7).setCellValue(19.0);
    }

    public boolean saveTemplatesAsThemisFile(File f) {
        ThemisFile tf = new ThemisFile();
        tf.setAsProjectTemplate();
        try {
            return tf.saveToFile(f, true);
        }
        catch (IOException ex) {
            this.app.getDialog().showErrorDialog("Datei kann nicht gespeichert werden: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public boolean saveTextTemplates(File f) {
        try {
            this.project.createActionLog("projectsetting_export", 0L, f.getAbsolutePath());
            URL url = this.getClass().getResource("/at/grid/themis/ontology/media/projektvorlage.xlsx");
            Workbook wb = WorkbookFactory.create((InputStream)url.openStream());
            this.createColumnSpecification(19);
            Sheet sheet = wb.getSheet("Textvorlagen");
            if (sheet == null) {
                sheet = wb.getSheet("Templates");
            }
            this.getCell(sheet, 1, 7).setCellValue(19.0);
            this.saveTextTemplates(wb);
            ArrayList<Sheet> toBeDeleted = new ArrayList<Sheet>();
            for (int ii = 0; ii < wb.getNumberOfSheets(); ++ii) {
                Sheet sh = wb.getSheetAt(ii);
                if (sh == sheet) continue;
                toBeDeleted.add(sh);
            }
            for (Sheet sh : toBeDeleted) {
                wb.removeSheetAt(wb.getSheetIndex(sh));
            }
            FileOutputStream fos = new FileOutputStream(f);
            wb.setForceFormulaRecalculation(true);
            wb.write((OutputStream)fos);
            fos.close();
            wb.close();
            return true;
        }
        catch (IOException ex) {
            this.project.getLogger().severe("I/O Error while saving template: " + ex.getMessage());
        }
        catch (EncryptedDocumentException ex) {
            this.project.getLogger().severe("Encryption Error while saving template: " + ex.getMessage());
        }
        catch (Exception ex) {
            this.project.getLogger().severe("Other Error while saving template: " + ex.getMessage());
        }
        return false;
    }

    public boolean saveTemplates(File f) {
        try {
            this.project.createActionLog("projectsetting_export", 0L, f.getAbsolutePath());
            URL url = this.getClass().getResource("/at/grid/themis/ontology/media/projektvorlage.xlsx");
            Workbook wb = WorkbookFactory.create((InputStream)url.openStream());
            this.createColumnSpecification(19);
            Sheet sheet = wb.getSheet("Textvorlagen");
            if (sheet == null) {
                sheet = wb.getSheet("Templates");
            }
            this.getCell(sheet, 1, 7).setCellValue(19.0);
            this.iconfoldername = "icons_" + Util.getFileNameWithoutExtension((File)f) + "/";
            this.saveContacts(wb);
            this.saveDocuments(wb, f);
            this.saveIcons(wb, f);
            this.saveLists(wb);
            this.saveTextTemplates(wb);
            this.saveAttributeVisibility(wb);
            this.saveSettings(wb);
            FileOutputStream fos = new FileOutputStream(f);
            wb.setForceFormulaRecalculation(true);
            wb.write((OutputStream)fos);
            fos.close();
            wb.close();
            return true;
        }
        catch (IOException ex) {
            this.project.getLogger().severe("I/O Error while saving template: " + ex.getMessage());
        }
        catch (EncryptedDocumentException ex) {
            this.project.getLogger().severe("Encryption Error while saving template: " + ex.getMessage());
        }
        catch (Exception ex) {
            this.project.getLogger().severe("Other Error while saving template: " + ex.getMessage());
        }
        return false;
    }

    public Properties getLoadResult() {
        return this.loadResult;
    }

    public boolean loadTemplatesFromXls(File f) {
        return this.loadTemplatesFromXls(null, null, f);
    }

    public boolean loadTemplatesFromXls(InputStream is, File f) {
        return this.loadTemplatesFromXls(is, null, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyseTemplateFile(File f) {
        String line;
        FileInputStream is = null;
        Workbook wb = null;
        Sheet sheet = null;
        try {
            is = new FileInputStream(f);
            wb = WorkbookFactory.create((InputStream)is);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException | EncryptedDocumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (wb == null) {
            return;
        }
        this.withSettings = this.withSettings && (wb.getSheet("Attributes") != null || wb.getSheet("Attribute") != null || wb.getSheet("Einstellungen") != null || wb.getSheet("Settings") != null);
        this.withKeytables = this.withKeytables && (wb.getSheet("Listen") != null || wb.getSheet("Lists") != null);
        this.countTemplate = 0;
        sheet = wb.getSheet("Textvorlagen");
        if (sheet == null) {
            sheet = wb.getSheet("Templates");
        }
        if (sheet != null) {
            for (int row = 11; row < sheet.getLastRowNum() + 1; ++row) {
                line = this.getCellValue(sheet, row, 1).toLowerCase();
                if ("".equals(line)) continue;
                ++this.countTemplate;
            }
        }
        this.countIcon = 0;
        sheet = wb.getSheet("Icons");
        if (sheet != null) {
            for (int row = 11; row < sheet.getLastRowNum() + 1; ++row) {
                line = this.getCellValue(sheet, row, 1).toLowerCase();
                if ("".equals(line)) continue;
                ++this.countIcon;
            }
        }
        this.countContact = 0;
        sheet = wb.getSheet("Kontakte");
        if (sheet == null) {
            sheet = wb.getSheet("Contacts");
        }
        if (sheet != null) {
            for (int row = 11; row < sheet.getLastRowNum() + 1; ++row) {
                line = this.getCellValue(sheet, row, 1).toLowerCase();
                if ("".equals(line)) continue;
                ++this.countContact;
            }
        }
        this.countDocument = 0;
        sheet = wb.getSheet("Dokumente");
        if (sheet == null) {
            sheet = wb.getSheet("Documents");
        }
        if (sheet != null) {
            for (int row = 11; row < sheet.getLastRowNum() + 1; ++row) {
                line = this.getCellValue(sheet, row, 1).toLowerCase();
                if ("".equals(line)) continue;
                ++this.countDocument;
            }
        }
        this.countForm = 0;
        this.countReportTemplate = 0;
    }

    public int getCountTemplate() {
        return this.countTemplate;
    }

    public int getCountForm() {
        return this.countForm;
    }

    public int getCountIcon() {
        return this.countIcon;
    }

    public int getCountContact() {
        return this.countContact;
    }

    public int getCountDocument() {
        return this.countDocument;
    }

    public int getCountReportTemplate() {
        return this.countReportTemplate;
    }

    public boolean hasKeytables() {
        return this.withKeytables;
    }

    public boolean hasSettings() {
        return this.withSettings;
    }

    public TemplateManager setWithTemplates(boolean flg) {
        this.withTemplates = flg;
        return this;
    }

    public TemplateManager setWithDocuments(boolean flg) {
        this.withDocuments = flg;
        return this;
    }

    public TemplateManager setWithContacts(boolean flg) {
        this.withContacts = flg;
        return this;
    }

    public TemplateManager setWithIcons(boolean flg) {
        this.withIcons = flg;
        return this;
    }

    public TemplateManager setWithKeytables(boolean flg) {
        this.withKeytables = flg;
        return this;
    }

    public TemplateManager setWithSettings(boolean flg) {
        this.withSettings = flg;
        return this;
    }

    public boolean loadTemplatesFromXls(InputStream is, InputStream is2, File f) {
        int row = 0;
        Date dt0 = new Date();
        this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, begin loading template");
        this.templateMatchByTitle = this.getSettings().getTemplateMatchByTitle();
        this.removeMissingAfterLoad = this.getSettings().getTemplateDeleteMissingItems();
        try {
            int disclaimerOk;
            String disclaimer;
            int fileversion;
            Workbook wb;
            if (f != null) {
                this.project.createActionLog("projectsetting_load", 0L, f.getAbsolutePath());
            } else {
                this.project.createActionLog("projectsetting_load", 0L, "from internal resource");
            }
            HashMap<String, Long> contactMap = this.loadExistingContacts();
            HashMap<String, Long> documentMap = this.loadExistingDocuments();
            HashMap<String, Long> iconMap = this.loadExistingIcons();
            boolean hasContacts = false;
            boolean hasGroups = false;
            this.loadResult.clear();
            if (is == null) {
                is = new FileInputStream(f);
                wb = WorkbookFactory.create((InputStream)is);
            } else {
                wb = WorkbookFactory.create((InputStream)is);
            }
            this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, workbook loaded");
            Sheet sheet = wb.getSheet("Textvorlagen");
            if (sheet == null) {
                sheet = wb.getSheet("Templates");
            }
            if (!this.checkFileVersion(fileversion = this.getFileVersion(sheet, 1))) {
                wb.close();
                return false;
            }
            if (fileversion >= 4 && (disclaimer = this.getCellValue(sheet, 3, 7)) != null && !"".equals(disclaimer) && !this.ignoreDisclaimer && (disclaimerOk = this.app.getDialog().showInfoOptionDialog(disclaimer, "Disclaimer", new String[]{this.project.getResourceText("core.core.text.continue", this.app.getLocale()), this.project.getResourceText("core.core.text.cancel", this.app.getLocale())})) != 0) {
                try {
                    wb.close();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            if (fileversion == 1) {
                this.app.getDialog().showErrorDialog("Old version not supported anymore");
                return false;
            }
            this.createColumnSpecification(fileversion);
            this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, finished preparations");
            if (this.withSettings) {
                sheet = wb.getSheet("Attribute");
                if (sheet == null) {
                    sheet = wb.getSheet("Attributes");
                }
                this.loadAttributeVisibility(sheet, fileversion, hasGroups, hasContacts);
                this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, attributes loaded");
                sheet = wb.getSheet("Einstellungen");
                if (sheet == null) {
                    sheet = wb.getSheet("Settings");
                }
                this.loadSettings(sheet, fileversion);
                this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, settings loaded");
            }
            if (this.withIcons) {
                sheet = wb.getSheet("Icons");
                this.loadIcons(sheet, is2, f, iconMap);
                this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, icons loaded");
            }
            if (this.withDocuments) {
                sheet = wb.getSheet("Dokumente");
                if (sheet == null) {
                    sheet = wb.getSheet("Documents");
                }
                this.loadDocuments(sheet, is2, f, documentMap);
                this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, documents loaded");
            }
            if (this.withContacts) {
                sheet = wb.getSheet("Kontakte");
                if (sheet == null) {
                    sheet = wb.getSheet("Contacts");
                }
                hasContacts = this.loadContacts(sheet, hasContacts, contactMap);
                this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, contacts loaded");
            }
            if (this.withKeytables) {
                sheet = wb.getSheet("Listen");
                if (sheet == null) {
                    sheet = wb.getSheet("Lists");
                }
                this.loadLists(sheet, fileversion);
                this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, lists loaded");
            }
            Boolean result = true;
            if (this.withTemplates) {
                sheet = wb.getSheet("Textvorlagen");
                if (sheet == null) {
                    sheet = wb.getSheet("Templates");
                }
                result = this.loadTextTemplates(sheet, is2, f, fileversion, hasGroups);
                this.project.getLogger().fine("LOADTEMPLATE: " + (new Date().getTime() - dt0.getTime()) + " ms, text templates loaded");
                if (result != null) {
                    hasGroups = result;
                }
            }
            try {
                wb.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result != null;
        }
        catch (IOException ex) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Textvorlagen in Zeile " + row, ex);
        }
        catch (EncryptedDocumentException ex) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Textvorlagen in Zeile " + row, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Textvorlagen in Zeile " + row, ex);
        }
        return false;
    }

    private void saveAttributeVisibility(Workbook wb) {
        Sheet sheet = wb.getSheet("Attribute");
        if (sheet == null) {
            sheet = wb.getSheet("Attributes");
        }
        this.writeFileVersionToSheet(sheet);
        int row = 7;
        CellStyle styleLocked = this.getCell(sheet, row, 1).getCellStyle();
        styleLocked.setLocked(true);
        ArrayList<ThemisAttribute> locationAttributesUsed = this.getSettings().getLocationAttributesUsed();
        for (ThemisAttribute themisAttribute : this.getSettings().getLocationAttributes()) {
            if (themisAttribute.isVirtual() || themisAttribute.isUserdefined()) continue;
            this.saveAttributeSettings(sheet, row, 1, themisAttribute, styleLocked);
            ++row;
        }
        for (ThemisAttribute themisAttribute : locationAttributesUsed) {
            if (themisAttribute.isVirtual()) continue;
            this.saveAttributeSettings(sheet, row, 1, themisAttribute, styleLocked);
            ++row;
        }
        for (ThemisAttribute themisAttribute : this.getSettings().getLocationAttributes()) {
            if (themisAttribute.isVirtual() || !themisAttribute.isUserdefined() || locationAttributesUsed.contains(themisAttribute)) continue;
            this.saveAttributeSettings(sheet, row, 1, themisAttribute, styleLocked);
            ++row;
        }
        row = 7;
        ArrayList<ThemisAttribute> observationAttributesUsed = this.getSettings().getObservationAttributesUsed();
        for (ThemisAttribute ta : this.getSettings().getObservationAttributes()) {
            if (ta.isVirtual() || ta.isUserdefined()) continue;
            this.saveAttributeSettings(sheet, row, 6, ta, styleLocked);
            ++row;
        }
        for (ThemisAttribute ta : observationAttributesUsed) {
            if (ta.isVirtual()) continue;
            this.saveAttributeSettings(sheet, row, 6, ta, styleLocked);
            ++row;
        }
        for (ThemisAttribute ta : this.getSettings().getObservationAttributes()) {
            if (ta.isVirtual() || !ta.isUserdefined() || observationAttributesUsed.contains(ta)) continue;
            this.saveAttributeSettings(sheet, row, 6, ta, styleLocked);
            ++row;
        }
        row = 7;
        ArrayList<ThemisAttribute> arrayList = this.getSettings().getObservationTableAttributes();
        for (ThemisAttribute ta : this.getSettings().getObservationTableAttributes()) {
            if (ta == null) continue;
            this.getCell(sheet, row, 12).setCellValue(ta.getTargetLetter(true).toUpperCase() + ta.getId());
            this.getCell(sheet, row, 13).setCellValue((double)ta.getWidthInTable());
            ++row;
        }
    }

    private void saveAttributeSettings(Sheet sheet, int row, int col, ThemisAttribute ta, CellStyle styleLocked) {
        this.getCell(sheet, row, col).setCellValue(ta.getId());
        this.getCell(sheet, row, col + 1).setCellValue(ta.getLabel());
        if (!ta.isUserdefined()) {
            Cell c = this.getCell(sheet, row, col + 1);
            c.setCellStyle(styleLocked);
        }
        this.getCell(sheet, row, col + 2).setCellValue(ta.isUsed() ? ta.getShow() : "");
        this.getCell(sheet, row, col + 3).setCellValue(ta.isUsed() && ta.isWriteprotected() ? "X" : "");
        this.getCell(sheet, row, col + 4).setCellValue(ta.isUsed() && ta.isChecklistedit() ? "X" : "");
    }

    private void loadAttributeVisibility(Sheet sheet, int fileversion, boolean hasGroups, boolean hasContacts) {
        boolean attWriteprotected;
        String attShow;
        boolean attUsed;
        String attLabel;
        String attId;
        if (sheet == null) {
            return;
        }
        if (!this.checkFileVersion(fileversion = this.getFileVersion(sheet, fileversion))) {
            return;
        }
        for (ThemisAttribute ta : this.getSettings().getLocationAttributes()) {
            ta.setUsed(false);
            ta.setEditStyle(ThemisAttribute.Edit.DIALOG_ONLY);
        }
        for (ThemisAttribute ta : this.getSettings().getObservationAttributes()) {
            ta.setUsed(false);
            ta.setEditStyle(ThemisAttribute.Edit.DIALOG_ONLY);
        }
        if (fileversion <= 11) {
            this.loadAttributeVisibilityOldVersion(sheet, fileversion, hasGroups, hasContacts);
            return;
        }
        int row = 7;
        while (!"".equals(this.getCellValue(sheet, row, 1))) {
            attId = this.getCellValue(sheet, row, 1);
            attLabel = this.getCellValue(sheet, row, 2);
            attUsed = !"".equalsIgnoreCase(this.getCellValue(sheet, row, 3));
            attShow = this.getCellValue(sheet, row, 3);
            if ("x".equalsIgnoreCase(attShow)) {
                attShow = "mkia";
            }
            attWriteprotected = "x".equalsIgnoreCase(this.getCellValue(sheet, row, 4));
            ThemisAttribute ta = this.getSettings().getLocationAttribute(attId);
            if (ta != null) {
                ta.setLabel(attLabel);
                ta.setUsed(attUsed);
                ta.setShow(attShow);
                ta.setChecklistedit(false);
                ta.setWriteprotected(attWriteprotected);
            }
            ++row;
        }
        row = 7;
        while (!"".equals(this.getCellValue(sheet, row, 6))) {
            attId = this.getCellValue(sheet, row, 6);
            attLabel = this.getCellValue(sheet, row, 7);
            attUsed = !"".equalsIgnoreCase(this.getCellValue(sheet, row, 8));
            attShow = this.getCellValue(sheet, row, 8);
            if ("x".equalsIgnoreCase(attShow)) {
                attShow = "mkia";
            }
            attWriteprotected = "x".equalsIgnoreCase(this.getCellValue(sheet, row, 9));
            boolean attChecklist = "x".equalsIgnoreCase(this.getCellValue(sheet, row, 10));
            ThemisAttribute ta = this.getSettings().getObservationAttribute(attId);
            if (ta != null) {
                ta.setLabel(attLabel);
                ta.setUsed(attUsed);
                ta.setShow(attShow);
                ta.setChecklistedit(attChecklist);
                ta.setWriteprotected(attWriteprotected);
            }
            ++row;
        }
        row = 7;
        this.getSettings().clearObservationTableAttributes();
        while (!"".equals(this.getCellValue(sheet, row, 12))) {
            attId = this.getCellValue(sheet, row, 12);
            String colWidthStr = this.getCellValue(sheet, row, 13);
            try {
                ThemisAttribute ta;
                int colWidth = Integer.parseInt(colWidthStr);
                if (attId.toLowerCase().startsWith("b.")) {
                    ta = this.getSettings().getObservationAttribute(attId.substring(2));
                    ta.setWidthInTable(colWidth);
                    this.getSettings().addObservationTableAttributes(ta.getTargetCode(), attId.substring(2));
                } else {
                    ta = this.getSettings().getLocationAttribute(attId.substring(2));
                    ta.setWidthInTable(colWidth);
                    this.getSettings().addObservationTableAttributes(ta.getTargetCode(), attId.substring(2));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++row;
        }
    }

    private void loadAttributeVisibilityOldVersion(Sheet sheet, int fileversion, boolean hasGroups, boolean hasContacts) {
        int row = -1;
        try {
            Properties propsProject = new Properties();
            row = 7;
            this.getSettings().getLocationAttribute("group").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)) || hasGroups);
            this.getSettings().getLocationAttribute("text1").setLabel(this.getCellValue(sheet, row, 2, "Text 1"));
            this.getSettings().getLocationAttribute("text1").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            this.getSettings().getLocationAttribute("text2").setLabel(this.getCellValue(sheet, row, 2, "Text 2"));
            this.getSettings().getLocationAttribute("text2").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            if (fileversion >= 4) {
                this.getSettings().getLocationAttribute("barcode").setLabel(this.getCellValue(sheet, row, 2, "QR-Code"));
                this.getSettings().getLocationAttribute("barcode").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            }
            this.getSettings().getLocationAttribute("list1").setLabel(this.getCellValue(sheet, row, 2, "Liste 1"));
            this.getSettings().getLocationAttribute("list1").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            this.getSettings().getLocationAttribute("list2").setLabel(this.getCellValue(sheet, row, 2, "Liste 2"));
            this.getSettings().getLocationAttribute("list2").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            this.getSettings().getLocationAttribute("icon").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            this.getSettings().getLocationAttribute("documents").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            this.getSettings().getLocationAttribute("size").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            this.getSettings().getLocationAttribute("quantity").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)));
            propsProject.setProperty("attribute.locnumber.individual", !"auto".equalsIgnoreCase(this.getCellValue(sheet, row++, 3)) ? "yes" : "no");
            row = 7;
            this.getSettings().getObservationAttribute("text1").setLabel(this.getCellValue(sheet, row, 6, "Text 1"));
            this.getSettings().getObservationAttribute("text1").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("text2").setLabel(this.getCellValue(sheet, row, 6, "Text 2"));
            this.getSettings().getObservationAttribute("text2").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("text3").setLabel(this.getCellValue(sheet, row, 6, "Text 3"));
            this.getSettings().getObservationAttribute("text3").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("text4").setLabel(this.getCellValue(sheet, row, 6, "Text 4"));
            this.getSettings().getObservationAttribute("text4").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            if (fileversion >= 7) {
                this.getSettings().getObservationAttribute("longtext1").setLabel(this.getCellValue(sheet, row, 6, "Langtext 1"));
                this.getSettings().getObservationAttribute("longtext1").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
                this.getSettings().getObservationAttribute("longtext2").setLabel(this.getCellValue(sheet, row, 6, "Langtext 2"));
                this.getSettings().getObservationAttribute("longtext2").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            }
            this.getSettings().getObservationAttribute("quantity").setLabel(this.getCellValue(sheet, row, 6, "Menge"));
            this.getSettings().getObservationAttribute("quantity").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("list1").setLabel(this.getCellValue(sheet, row, 6, "Liste 1"));
            this.getSettings().getObservationAttribute("list1").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("list2").setLabel(this.getCellValue(sheet, row, 6, "Liste 2"));
            this.getSettings().getObservationAttribute("list2").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("list3").setLabel(this.getCellValue(sheet, row, 6, "Liste 3"));
            this.getSettings().getObservationAttribute("list3").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            if (fileversion >= 4) {
                this.getSettings().getObservationAttribute("assessment").setLabel(this.getCellValue(sheet, row, 6, "Risiko"));
                this.getSettings().getObservationAttribute("assessment").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            }
            this.getSettings().getObservationAttribute("responsible").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("duedate").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("done").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("measure").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().getObservationAttribute("documents").setUsed("x".equalsIgnoreCase(this.getCellValue(sheet, row++, 7)));
            this.getSettings().setImageForObservation("b".equalsIgnoreCase(this.getCellValue(sheet, 7, 10, "b")));
            this.getSettings().setImageForLocation("g".equalsIgnoreCase(this.getCellValue(sheet, 7, 10, "b")));
            this.project.setProjectProperties(propsProject);
            this.app.setConfiguration(propsProject);
        }
        catch (Exception e) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\n" + e.getLocalizedMessage());
        }
    }

    private void saveSettings(Workbook wb) {
        Sheet sheet = wb.getSheet("Einstellungen");
        if (sheet == null) {
            sheet = wb.getSheet("Settings");
        }
        if (sheet != null) {
            this.writeFileVersionToSheet(sheet);
            int idx = Integer.parseInt(this.project.getProjectProperty("attribute.locnumber.scheme", "0"));
            this.getCell(sheet, 7, 3).setCellValue((double)idx);
            this.getCell(sheet, 9, 3).setCellValue("yes".equalsIgnoreCase(this.project.getProjectProperty("attribute.locnumber.individual", "no")) ? "manual" : "auto");
            this.getCell(sheet, 10, 3).setCellValue((double)this.app.getSettings().getDisplayHideDoneTask());
            this.getCell(sheet, 11, 3).setCellValue(this.app.getSettings().getShowBuildingsInLocList() ? "X" : "");
            this.getCell(sheet, 13, 3).setCellValue(this.app.getSettings().getDoCreateNewObservationWithLocation() ? "X" : "");
            this.getCell(sheet, 15, 3).setCellValue(this.app.getSettings().getDoAutoGenerateEvent() ? "X" : "");
            this.getCell(sheet, 19, 3).setCellValue((double)this.getSettings().getImageUploadSize());
            this.getCell(sheet, 20, 3).setCellValue((double)this.getSettings().getImageUploadQuality());
            this.getCell(sheet, 21, 3).setCellValue(this.getSettings().getImageForObservation() ? "B" : "G");
            this.getCell(sheet, 22, 3).setCellValue(this.getSettings().getImageKeepOriginal() ? "X" : "");
            this.getCell(sheet, 32, 3).setCellValue(this.getSettings().getDisplayLabelAttribute());
            this.getCell(sheet, 33, 3).setCellValue(this.getSettings().getDisplayLabelNumber() ? "X" : "");
            this.getCell(sheet, 34, 3).setCellValue(this.getSettings().getDisplayMoveIconWithLabel() ? "X" : "");
            Point pt = this.getSettings().getDisplayLabelOffset();
            this.getCell(sheet, 35, 3).setCellValue(pt == null ? "" : pt.getX() + "," + pt.getY());
            this.getCell(sheet, 37, 3).setCellValue((double)this.getSettings().getDisplayPointSize());
            this.getCell(sheet, 38, 3).setCellValue(this.getSettings().getDisplayColorPoint());
            this.getCell(sheet, 39, 3).setCellValue(this.getSettings().getDisplayColorPointSelected());
            this.getCell(sheet, 40, 3).setCellValue((double)this.getSettings().getDisplayColorSetting());
            this.getCell(sheet, 41, 3).setCellValue((double)this.getSettings().getDisplayFontSize());
            this.getCell(sheet, 42, 3).setCellValue((double)this.getSettings().getDisplayLineSize());
            this.getCell(sheet, 46, 3).setCellValue((double)this.getSettings().getDisplayIconSize());
            this.getCell(sheet, 47, 3).setCellValue(this.getSettings().getDisplayColorOption().toStringDefinition());
            this.getCell(sheet, 54, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.StatusOffen));
            this.getCell(sheet, 55, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.StatusErledigt));
            this.getCell(sheet, 57, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.TypMangel));
            this.getCell(sheet, 58, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.TypAufgabe));
            this.getCell(sheet, 59, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.TypKontrolle));
            this.getCell(sheet, 60, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.TypInformation));
            this.getCell(sheet, 62, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.TextNoEvent));
            this.getCell(sheet, 63, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.TextNoImage));
            this.getCell(sheet, 64, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.TextNoContent));
            this.getCell(sheet, 66, 2).setCellValue(this.getSettings().getTerm(ThemisSettings.Term.NewEventTitle));
        }
    }

    private void loadSettings(Sheet sheet, int fileversion) {
        if (sheet == null) {
            return;
        }
        if ((fileversion = this.getFileVersion(sheet, fileversion)) <= 11) {
            this.loadSettingsOldVersion(sheet, fileversion);
            return;
        }
        this.project.setProjectProperty("attribute.locnumber.scheme", this.getCellValue(sheet, 7, 3));
        this.project.setProjectProperty("attribute.locnumber.individual", "x".equalsIgnoreCase(this.getCellValue(sheet, 9, 3)) ? "" : "");
        if (fileversion >= 17) {
            this.getSettings().setDisplayHideDoneTask(this.getCellValueInt(sheet, 10, 3, 2));
        }
        this.getSettings().setShowBuildingsInLocList("x".equalsIgnoreCase(this.getCellValue(sheet, 11, 3)));
        this.getSettings().setDoCreateNewObservationWithLocation("x".equalsIgnoreCase(this.getCellValue(sheet, 13, 3)));
        if (fileversion >= 19) {
            this.getSettings().setDoAutoGenerateEvent("x".equalsIgnoreCase(this.getCellValue(sheet, 15, 3)));
        }
        this.getSettings().setImageUploadSize(this.getCellValueInt(sheet, 19, 3, 2000));
        this.getSettings().setImageUploadQuality(Math.max(0.1f, Math.min(this.getCellValueFloat(sheet, 20, 3, 0.8f), 1.0f)));
        this.getSettings().setImageForObservation("b".equalsIgnoreCase(this.getCellValue(sheet, 21, 3, "b")));
        this.getSettings().setImageForLocation("g".equalsIgnoreCase(this.getCellValue(sheet, 21, 3, "b")));
        this.getSettings().setImageKeepOriginal("x".equalsIgnoreCase(this.getCellValue(sheet, 22, 3, "")));
        this.getSettings().setDisplayLabelAttribute(this.getCellValue(sheet, 32, 3));
        this.getSettings().setDisplayLabelNumber("x".equalsIgnoreCase(this.getCellValue(sheet, 33, 3)));
        this.getSettings().setDisplayMoveIconWithLabel("x".equalsIgnoreCase(this.getCellValue(sheet, 34, 3)));
        String labeloffset = this.getCellValue(sheet, 35, 3, "");
        if ("".equals(labeloffset)) {
            this.getSettings().setDisplayLabelOffset(null);
        } else {
            String[] labeloffsetKoord = labeloffset.split(",");
            if (labeloffsetKoord.length == 2) {
                Point p = new Point(Double.parseDouble(labeloffsetKoord[0]), Double.parseDouble(labeloffsetKoord[1]));
                this.getSettings().setDisplayLabelOffset(p);
            }
        }
        this.getSettings().setDisplayPointSize(this.getCellValueInt(sheet, 37, 3, 4));
        this.getSettings().setDisplayColorPoint(this.getCellValue(sheet, 38, 3));
        this.getSettings().setDisplayColorPointSelected(this.getCellValue(sheet, 39, 3));
        this.getSettings().setDisplayColorSetting(this.getCellValueInt(sheet, 40, 3, 0));
        this.getSettings().setDisplayFontSize(this.getCellValueInt(sheet, 41, 3, 12));
        this.getSettings().setDisplayLineSize(this.getCellValueInt(sheet, 42, 3, 4));
        this.getSettings().setDisplayIconSize(this.getCellValueInt(sheet, 46, 3, 4));
        if (fileversion >= 14) {
            this.getSettings().setDisplayColorOption(ColorOption.fromString(this.getCellValue(sheet, 47, 3)));
        } else {
            Color labelBackground = ThemisUtil.getColorFromString(this.getCellValue(sheet, 43, 3));
            Color labelText = ThemisUtil.getColorFromString(this.getCellValue(sheet, 45, 3));
            boolean labelTransparent = "x".equalsIgnoreCase(this.getCellValue(sheet, 44, 3));
            ColorOption co = labelTransparent ? new ColorOption("Transparent") : new ColorOption("Feste Farbe", labelBackground.getRGB());
            co.setColor(labelBackground.getRGB());
            co.setForegroundColor(labelText.getRGB());
        }
        Properties propsProject = new Properties();
        this.getSettings().setTerm(ThemisSettings.Term.StatusOffen, this.getCellValue(sheet, 54, 2));
        this.getSettings().setTerm(ThemisSettings.Term.StatusErledigt, this.getCellValue(sheet, 55, 2));
        this.getSettings().setTerm(ThemisSettings.Term.TypMangel, this.getCellValue(sheet, 57, 2));
        this.getSettings().setTerm(ThemisSettings.Term.TypAufgabe, this.getCellValue(sheet, 58, 2));
        this.getSettings().setTerm(ThemisSettings.Term.TypKontrolle, this.getCellValue(sheet, 59, 2));
        this.getSettings().setTerm(ThemisSettings.Term.TypInformation, this.getCellValue(sheet, 60, 2));
        this.getSettings().setTerm(ThemisSettings.Term.TextNoEvent, this.getCellValue(sheet, 62, 2));
        this.getSettings().setTerm(ThemisSettings.Term.TextNoImage, this.getCellValue(sheet, 63, 2));
        this.getSettings().setTerm(ThemisSettings.Term.TextNoContent, this.getCellValue(sheet, 64, 2));
        if (fileversion >= 18) {
            this.getSettings().setTerm(ThemisSettings.Term.NewEventTitle, this.getCellValue(sheet, 66, 2));
        }
        this.project.setProjectProperties(propsProject);
    }

    private void loadSettingsOldVersion(Sheet sheet, int fileversion) {
        if (sheet == null) {
            return;
        }
        int row = -1;
        try {
            Properties propsProject = new Properties();
            row = 7;
            String setting = this.getCellValue(sheet, row, 1);
            while (setting != null && !"".equals(setting)) {
                switch (setting) {
                    case "LOC_NO": {
                        int idx = 0;
                        for (int ii = 0; ii < 3; ++ii) {
                            if (!"x".equalsIgnoreCase(this.getCellValue(sheet, row + ii, 3))) continue;
                            idx = ii;
                        }
                        propsProject.setProperty("attribute.locnumber.scheme", Integer.toString(idx));
                        row += 2;
                        break;
                    }
                    case "PLAN_LBL": {
                        String lblSetting = this.getCellValue(sheet, row, 4);
                        propsProject.setProperty("project.plan.label", lblSetting);
                        break;
                    }
                    case "PLAN_LBL_NO": {
                        propsProject.setProperty("project.plan.label-number", "x".equalsIgnoreCase(this.getCellValue(sheet, row, 3)) ? "yes" : "no");
                        break;
                    }
                    case "PERM_TEMPLATE": {
                        this.app.getSettings().setPermissionEditTemplates(this.getCellValue(sheet, row, 4));
                    }
                }
                setting = this.getCellValue(sheet, ++row, 1);
            }
            if (fileversion >= 9) {
                row = 23;
                this.getSettings().setTerm(ThemisSettings.Term.StatusOffen, this.getCellValue(sheet, row++, 2));
                this.getSettings().setTerm(ThemisSettings.Term.StatusErledigt, this.getCellValue(sheet, row++, 2));
                int n = ++row;
                this.getSettings().setTerm(ThemisSettings.Term.TypMangel, this.getCellValue(sheet, n, 2));
                int n2 = ++row;
                this.getSettings().setTerm(ThemisSettings.Term.TypAufgabe, this.getCellValue(sheet, n2, 2));
                int n3 = ++row;
                this.getSettings().setTerm(ThemisSettings.Term.TypKontrolle, this.getCellValue(sheet, n3, 2));
                int n4 = ++row;
                ++row;
                this.getSettings().setTerm(ThemisSettings.Term.TypInformation, this.getCellValue(sheet, n4, 2));
                int n5 = ++row;
                ++row;
                this.getSettings().setTerm(ThemisSettings.Term.TextNoEvent, this.getCellValue(sheet, n5, 2));
            }
            this.project.setProjectProperties(propsProject);
            this.app.setConfiguration(propsProject);
        }
        catch (Exception e) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\n" + e.getLocalizedMessage());
        }
    }

    private void saveDisplaySettings(Workbook wb, File f) {
        Sheet sheet = wb.getSheet("Anzeige");
        if (sheet == null) {
            sheet = wb.getSheet("Display");
        }
        if (sheet != null) {
            int systemsetting = Integer.parseInt(this.app.getConfiguration("display.label", "0"));
            String sel = this.project.getProjectProperty("project.plan.label", systemsetting == 1 || systemsetting == 2 ? "title" : "none");
            boolean bl = "yes".equalsIgnoreCase(this.project.getProjectProperty("project.plan.label-number", systemsetting < 2 ? "yes" : "no"));
        }
    }

    private void loadDisplaySettings(Sheet sheet, int fileversion) {
        if (sheet == null) {
            return;
        }
    }

    private void saveIcons(Workbook wb, File f) {
        Sheet sheet = wb.getSheet("Icons");
        int row = 7;
        if (sheet != null) {
            this.writeFileVersionToSheet(sheet);
            if (this.app.getLicense().isTestLicense()) {
                this.app.getDialog().showWarningDialog("warning.testlicense.noiconsave");
                return;
            }
            this.readCellStyles(sheet, row);
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "icon");
            Iterator iterator = s.search().getResultIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                CmsElement e = this.project.loadElement(id, this.project.getUser());
                this.getCell(sheet, row, this.colIcon.get("title")).setCellValue(e.getAttributeValue("title"));
                UploadItem item = e.getUploadAttribute("file").getFirstUploadItem();
                boolean error = false;
                if (item != null) {
                    String fn = null;
                    try {
                        this.getCell(sheet, row, this.colIcon.get("file")).setCellValue(this.iconfoldername + item.getName());
                        File targetFile = new File(f.getParentFile(), this.iconfoldername + item.getName());
                        targetFile.getParentFile().mkdirs();
                        Util.copy((File)item.getFile(), (File)targetFile);
                    }
                    catch (IOException ex) {
                        if (error) {
                            this.app.getDialog().showErrorDialog("Fehler beim Speichern mehrerer Icons. Diese Meldung wird nicht weiter gezeigt.", ex);
                        }
                        this.app.getDialog().showErrorDialog("Fehler beim Speichern der Icons: " + fn, ex);
                        error = true;
                    }
                }
                ++row;
            }
        }
    }

    private void loadIcons(Sheet sheet, InputStream is2, File f, HashMap<String, Long> iconMap) {
        if (sheet == null) {
            return;
        }
        int iconFileNotFoundWarning = 0;
        int firstRow = 7;
        int lastRow = sheet.getLastRowNum() + 1;
        int row = 0;
        int countNew = 0;
        int countModified = 0;
        int countMissing = 0;
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            for (row = firstRow; row <= lastRow; ++row) {
                ZipEntry entry;
                CmsIcon i;
                Properties props = this.getRowProperties(this.colIcon, sheet, row, null);
                String icon_title = props.getProperty("title");
                String icon_file = props.getProperty("file");
                if (icon_title == null || icon_file == null || "".equals(icon_file)) continue;
                if ("".equals(icon_title)) {
                    icon_title = icon_file;
                }
                if (iconMap.containsKey(icon_title)) {
                    long id = iconMap.get(icon_title);
                    if (!ids.contains(id)) {
                        ++countModified;
                        ids.add(id);
                    }
                    i = (CmsIcon)this.project.loadElement(id, this.project.getUser());
                } else {
                    i = (CmsIcon)this.project.createElement("icon", this.project.getUser());
                    iconMap.put(icon_title, i.getId());
                    ++countNew;
                }
                if (f != null) {
                    File file = new File(f.getParentFile(), icon_file);
                    if (file.isFile()) {
                        i.setAttributeValue("title", icon_title);
                        i.getUploadAttribute("file").addUpload(file);
                        if (i.isTrash()) {
                            i.restoreFromTrash();
                        }
                        i.save();
                        continue;
                    }
                    if (iconFileNotFoundWarning == 0) {
                        this.app.getDialog().showWarningDialog("Icon-Datei '" + file.getAbsolutePath() + "' existiert nicht bzw. kann nicht gelesen weren.");
                        ++iconFileNotFoundWarning;
                        continue;
                    }
                    if (iconFileNotFoundWarning != true) continue;
                    this.app.getDialog().showWarningDialog("Es k\u00f6nnen auch weitere Icon-Dateien nicht geladen werden. Diese Meldung wird nicht mehr angezeigt.");
                    ++iconFileNotFoundWarning;
                    continue;
                }
                if (is2 == null) continue;
                is2.reset();
                ZipInputStream zis = new ZipInputStream(is2, Charset.forName("Cp437"));
                FileOutputStream fos = null;
                byte[] buffer = new byte[2048];
                while ((entry = zis.getNextEntry()) != null) {
                    if (icon_file.equals(entry.getName())) {
                        File fdummy = new File(entry.getName());
                        File ff = new File(this.app.getProject().getTempfileLocation(), fdummy.getName());
                        ff.getParentFile().mkdirs();
                        fos = new FileOutputStream(ff);
                        int len = 0;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        i.setAttributeValue("title", icon_title);
                        i.getUploadAttribute("file").addUpload(ff);
                        if (i.isTrash()) {
                            i.restoreFromTrash();
                        }
                        i.save();
                    }
                    zis.closeEntry();
                }
                zis.close();
            }
        }
        catch (Exception e) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\n" + e.getLocalizedMessage());
        }
        this.loadResult.setProperty("icon.new", Integer.toString(countNew));
        this.loadResult.setProperty("icon.modified", Integer.toString(countModified));
        this.loadResult.setProperty("icon.missing", Integer.toString(countMissing));
    }

    private void saveDocuments(Workbook wb, File f) {
        Sheet sheet = wb.getSheet("Dokumente");
        if (sheet == null) {
            sheet = wb.getSheet("Documents");
        }
        this.documentsfoldername = "documents_" + Util.getFileNameWithoutExtension((File)f) + "/";
        int row = 7;
        if (sheet != null) {
            this.writeFileVersionToSheet(sheet);
            this.readCellStyles(sheet, row);
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "info");
            Iterator iterator = s.search().getResultIds().iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                CmsElement e = this.project.loadElement(id, this.project.getUser());
                this.getCell(sheet, row, this.colDocument.get("title")).setCellValue(e.getAttributeValue("title"));
                this.getCell(sheet, row, this.colDocument.get("documenttype")).setCellValue(e.getAttributeValue("documenttype"));
                this.getCell(sheet, row, this.colDocument.get("comment")).setCellValue(e.getAttributeValue("comment"));
                List items = e.getUploadAttribute("files").getUploadItems();
                int col = this.colDocument.get("files");
                String fn = null;
                boolean error = false;
                for (UploadItem item : items) {
                    try {
                        fn = item.getFilename();
                        File targetFile = new File(f.getParentFile(), this.documentsfoldername + item.getName());
                        targetFile.getParentFile().mkdirs();
                        if (!item.getFile().exists()) continue;
                        this.getCell(sheet, row, col).setCellValue(this.documentsfoldername + item.getName());
                        Util.copy((File)item.getFile(), (File)targetFile);
                        ++col;
                    }
                    catch (IOException ex) {
                        if (error) {
                            this.app.getDialog().showErrorDialog("Fehler beim Speichern mehrerer Dokumente. Diese Meldung wird nicht weiter gezeigt.", ex);
                            continue;
                        }
                        this.app.getDialog().showErrorDialog("Fehler beim Speichern des Dokumnets: " + fn, ex);
                        error = true;
                    }
                }
                ++row;
            }
        }
    }

    private void loadDocuments(Sheet sheet, InputStream is2, File f, HashMap<String, Long> documentMap) {
        if (sheet == null) {
            return;
        }
        int firstRow = 7;
        int lastRow = sheet.getLastRowNum() + 1;
        int row = 0;
        try {
            for (row = firstRow; row <= lastRow; ++row) {
                CmsInfo e;
                String title;
                Properties props = this.getRowProperties(this.colDocument, sheet, row, null);
                if (props.isEmpty() || (title = props.getProperty("title")) == null || title.isEmpty()) continue;
                if (documentMap.containsKey(props.getProperty("title"))) {
                    e = (CmsInfo)this.project.loadElement(documentMap.get(props.getProperty("title")), this.project.getUser());
                } else {
                    e = (CmsInfo)this.project.createElement("info", this.project.getUser());
                    documentMap.put(props.getProperty("title"), e.getId());
                }
                int firstcolumn = this.colDocument.get("files");
                String val = this.getCellValue(sheet, row, firstcolumn);
                StringBuilder filenames = new StringBuilder();
                boolean first = true;
                for (int ii = 0; ii < 10 && !"".equals(val); ++ii) {
                    ZipEntry entry;
                    val = this.getCellValue(sheet, row, firstcolumn + ii);
                    if ("".equals(val)) continue;
                    if (f != null) {
                        File file = new File(f.getParentFile(), val);
                        if (!first) {
                            filenames.append(",");
                        }
                        filenames.append(file.getAbsolutePath());
                        first = false;
                        continue;
                    }
                    if (is2 == null) continue;
                    is2.reset();
                    ZipInputStream zis = new ZipInputStream(is2, Charset.forName("Cp437"));
                    FileOutputStream fos = null;
                    byte[] buffer = new byte[2048];
                    while ((entry = zis.getNextEntry()) != null) {
                        if (val.equals(entry.getName())) {
                            File fdummy = new File(entry.getName());
                            File ff = new File(this.app.getProject().getTempfileLocation(), fdummy.getName());
                            ff.getParentFile().mkdirs();
                            fos = new FileOutputStream(ff);
                            int len = 0;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                            fos.close();
                            if (!first) {
                                filenames.append(",");
                            }
                            filenames.append(ff.getAbsolutePath());
                            first = false;
                        }
                        zis.closeEntry();
                    }
                    zis.close();
                }
                if (filenames.length() > 0) {
                    props.setProperty("files", filenames.toString());
                }
                e.setAttributes(props);
                if (e.isTrash()) {
                    e.restoreFromTrash();
                }
                e.save();
            }
        }
        catch (Exception e) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\n" + e.getLocalizedMessage());
        }
    }

    private void saveContacts(Workbook wb) {
        Sheet sheet = wb.getSheet("Kontakte");
        if (sheet == null) {
            sheet = wb.getSheet("Contacts");
        }
        int row = 7;
        if (sheet != null) {
            this.writeFileVersionToSheet(sheet);
            this.readCellStyles(sheet, row);
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "company");
            s.addSelectAllAttributes("company");
            List recs = s.search().getResult();
            for (DataRecord rec : recs) {
                for (Map.Entry<String, Integer> entry : this.colContact.entrySet()) {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(rec.getString("company" + entry.getKey()));
                }
                ++row;
            }
        }
    }

    private boolean loadContacts(Sheet sheet, boolean hasContacts, HashMap<String, Long> contactMap) {
        if (sheet == null) {
            return hasContacts;
        }
        int firstRow = 7;
        int lastRow = sheet.getLastRowNum() + 1;
        int row = 0;
        try {
            for (row = firstRow; row <= lastRow; ++row) {
                CmsCompany e;
                Properties props = this.getRowProperties(this.colContact, sheet, row, null);
                if (props.isEmpty() || props.getProperty("name") == null || "".equals(props.getProperty("name"))) continue;
                if (contactMap.containsKey(props.getProperty("name"))) {
                    e = (CmsCompany)this.project.loadElement(contactMap.get(props.getProperty("name")), this.project.getUser());
                } else {
                    e = (CmsCompany)this.project.createElement("company", this.project.getUser());
                    contactMap.put(props.getProperty("name"), e.getId());
                }
                e.setAttributes(props);
                if (e.isTrash()) {
                    e.restoreFromTrash();
                }
                e.save();
                hasContacts = true;
            }
        }
        catch (Exception e) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\n" + e.getLocalizedMessage());
        }
        return hasContacts;
    }

    private void saveLists(Workbook wb) {
        Sheet sheet = wb.getSheet("Listen");
        if (sheet == null) {
            sheet = wb.getSheet(" Lists");
        }
        if (sheet != null) {
            this.writeFileVersionToSheet(sheet);
            String[] lists = new String[]{"list1", "list2", "list3", "list4", "topic", "observationtype", "priority", "documenttype"};
            for (int ii = 0; ii < lists.length; ++ii) {
                int row = 7;
                Keytable keytable = this.project.getKeytable(lists[ii]);
                ArrayList terms = (ArrayList)keytable.getTable().get(this.project.getUser().getCurrentLanguage());
                if (terms == null) continue;
                for (KeytableRecord term : terms) {
                    this.getCell(sheet, row, ii + 1).setCellValue(term.term);
                    if (term.color != null) {
                        XSSFCellStyle cs = (XSSFCellStyle)wb.createCellStyle();
                        Color c = new Color(term.color);
                        XSSFColor bgColor = new XSSFColor(c, null);
                        cs.setFillForegroundColor(bgColor);
                        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        this.getCell(sheet, row, ii + 1).setCellStyle((CellStyle)cs);
                    }
                    ++row;
                }
            }
        }
    }

    private void loadLists(Sheet sheet, int fileversion) {
        if (sheet == null) {
            return;
        }
        int row = -1;
        try {
            String[] lists = fileversion >= 12 ? new String[]{"list1", "list2", "list3", "list4", "topic", "observationtype", "priority", "documenttype"} : (fileversion >= 8 ? new String[]{"list1", "list2", "topic", "observationtype", "priority", "documenttype"} : new String[]{"list1", "list2", "observationtype", "topic", "priority", "documenttype"});
            for (int ii = 0; ii < lists.length; ++ii) {
                Keytable keytable = this.project.getKeytable(lists[ii]);
                for (row = 7; row < 100; ++row) {
                    String val = this.getCellValue(sheet, row, ii + 1, "");
                    if (!"".equals(val)) {
                        int rgb0;
                        Color c;
                        int[] rgbInt;
                        XSSFColor xssfCellColor;
                        byte[] rgb;
                        CellStyle cs;
                        org.apache.poi.ss.usermodel.Color csColor;
                        KeytableRecord rec;
                        long id = keytable.getId(val);
                        if (id < 0L) {
                            rec = keytable.addTerm(keytable.createNewId(), this.project.getPrimaryLang(), val);
                            if (rec == null || fileversion < 14 || !((csColor = (cs = this.getCell(sheet, row, ii + 1).getCellStyle()).getFillForegroundColorColor()) instanceof XSSFColor) || (rgb = (xssfCellColor = (XSSFColor)csColor).getRGB()) == null) continue;
                            rgbInt = new int[3];
                            for (int jj = 0; jj < 3; ++jj) {
                                rgbInt[jj] = rgb[jj] < 0 ? rgb[jj] + 256 : rgb[jj];
                            }
                            c = new Color(rgbInt[0], rgbInt[1], rgbInt[2]);
                            rgb0 = c.getRGB();
                            rec.color = c.getRGB();
                            continue;
                        }
                        rec = keytable.getRecord(id, this.project.getPrimaryLang());
                        if (rec == null || fileversion < 14 || !((csColor = (cs = this.getCell(sheet, row, ii + 1).getCellStyle()).getFillForegroundColorColor()) instanceof XSSFColor) || (rgb = (xssfCellColor = (XSSFColor)csColor).getRGB()) == null) continue;
                        rgbInt = new int[3];
                        for (int jj = 0; jj < 3; ++jj) {
                            rgbInt[jj] = rgb[jj] < 0 ? rgb[jj] + 256 : rgb[jj];
                        }
                        c = new Color(rgbInt[0], rgbInt[1], rgbInt[2]);
                        rgb0 = c.getRGB();
                        rec.color = c.getRGB();
                        continue;
                    }
                    row = 100;
                }
                keytable.save();
            }
        }
        catch (Exception e) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + (null == e.getMessage() ? "" : "\n" + e.getMessage()));
        }
    }

    private void saveTextTemplates(Workbook wb) {
        long id;
        ThemisAttribute ta;
        Sheet sheet = wb.getSheet("Textvorlagen");
        if (sheet == null) {
            sheet = wb.getSheet("Templates");
        }
        for (Map.Entry<String, Integer> entry : this.colObservation.entrySet()) {
            ta = this.getSettings().getObservationAttribute(entry.getKey());
            if (ta == null) {
                this.getCell(sheet, 7, entry.getValue()).setCellValue("[" + entry.getKey() + "]");
                continue;
            }
            this.getCell(sheet, 7, entry.getValue()).setCellValue(ta.getLabel() + " [" + ta.getId() + "]");
        }
        for (Map.Entry<String, Integer> entry : this.colLocation.entrySet()) {
            ta = this.getSettings().getLocationAttribute(entry.getKey());
            if (ta == null) {
                this.getCell(sheet, 6, entry.getValue()).setCellValue("[" + entry.getKey() + "]");
                continue;
            }
            this.getCell(sheet, 6, entry.getValue()).setCellValue(ta.getLabel() + " [" + ta.getId() + "]");
        }
        int row = 11;
        this.readCellStyles(sheet, row);
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("measuretemplate");
        s.addSelectAllAttributes("measuretemplate");
        s.setSort("ele.itemsort,ele.titel");
        s.addWhere("idlocation IS NULL");
        List<DataRecord> recs = s.search().getResult();
        for (DataRecord rec : recs) {
            this.setMeasureRow(sheet, row, rec);
            ++row;
        }
        s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("observationtemplate");
        s.addSelectMeta();
        s.addSelectAllAttributes("observationtemplate");
        s.setSort("ele.itemsort,idtype,el.title");
        s.addWhere("idlocation IS NULL");
        s.addWhere("idlocationgroup IS NULL");
        ArrayList ids = s.search().getResultIds();
        Iterator<Object> iterator = ids.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            CmsObservationTemplate t = (CmsObservationTemplate)this.project.loadElement(id, this.project.getUser());
            this.setObservationRow(sheet, row, t);
            ++row;
        }
        s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("locationtemplate");
        s.addSelectAllAttributes("locationtemplate");
        s.setSort("ele.itemsort,el.title");
        s.addWhere("idgroup IS NULL");
        ids = s.search().getResultIds();
        iterator = ids.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            ++row;
            CmsLocationTemplate l = (CmsLocationTemplate)this.project.loadElement(id, this.project.getUser());
            row = this.saveTemplateLocationToSheet(sheet, row, l);
        }
        recs = this.getLocationGroups();
        for (DataRecord rec : recs) {
            row = this.saveGroupToSheet(sheet, row, rec.getLong("meta_id"), 1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean loadTextTemplates(Sheet sheet, InputStream is2, File f, int fileversion, boolean hasGroups) {
        if (sheet == null) {
            return hasGroups;
        }
        int row = -1;
        int firstRow = 11;
        int lastRow = sheet.getLastRowNum() + 1;
        boolean useUUID = !this.templateMatchByTitle && fileversion >= 11;
        this.missingTemplateIds = new ArrayList();
        this.overwriteUUIDalreadyInUse = false;
        this.createnewUUIDalreadyInUse = false;
        this.ignoreUUIDalreadyInUse = false;
        int countNew = 0;
        int countModified = 0;
        int countMissing = 0;
        ArrayList ids = new ArrayList();
        try {
            HashMap<Object, Object> measureMap = new HashMap<String, Long>();
            HashMap<String, Long> locationMap = this.loadExistingLocationTemplates(-1L, useUUID);
            HashMap<String, Long> locationMapTitle = this.loadExistingLocationTemplates(-1L, false);
            HashMap<String, Long> observationMap = useUUID ? this.loadExistingObservationTemplatesWithUUID() : this.loadExistingObservationTemplates(-1L, useUUID);
            HashMap<String, Long> observationMapTitle = this.loadExistingObservationTemplates(-1L, false);
            HashMap<String, Long> groupMap = this.loadExistingGroups(-99L, useUUID);
            HashMap<String, Long> groupMap1Title = this.loadExistingGroups(-1L, false);
            HashMap hashMap = new HashMap();
            HashMap<Object, Object> groupMap3Title = new HashMap();
            HashMap<String, Long> iconMap = this.loadExistingIcons();
            ArrayList existingTemplateIds = new ArrayList();
            existingTemplateIds.addAll(this.project.getDatastorage().executeQuery("SELECT idelement AS meta_id FROM tdtaelement WHERE elementtype='locationgroup' AND NOT deleted", true).getResultIds());
            existingTemplateIds.addAll(this.project.getDatastorage().executeQuery("SELECT idelement AS meta_id FROM tdtaelement WHERE elementtype='locationtemplate' AND NOT deleted", true).getResultIds());
            existingTemplateIds.addAll(this.project.getDatastorage().executeQuery("SELECT idelement AS meta_id FROM tdtaelement WHERE elementtype='observationtemplate' AND NOT deleted", true).getResultIds());
            existingTemplateIds.addAll(this.project.getDatastorage().executeQuery("SELECT idelement AS meta_id FROM tdtaelement WHERE elementtype='measuretemplate' AND NOT deleted", true).getResultIds());
            ArrayList<Long> loadedTemplateIds = new ArrayList<Long>();
            ArrayList<String> loadedTemplateUUIDs = new ArrayList<String>();
            ArrayList deletedTemplateIds = new ArrayList();
            CmsLocationgroup lastGroup = null;
            CmsLocationgroup lastGroup1 = null;
            CmsLocationgroup lastGroup2 = null;
            ThemisElement lastLocationTemplate = null;
            ThemisElement lastObservationTemplate = null;
            int itemSort = this.project.getDatastorage().getTemplateItemSortMax();
            for (row = firstRow; row <= lastRow; ++row) {
                ThemisElement e;
                ThemisAttribute ta;
                Properties rowProps;
                void var21_23;
                CmsLocationgroup grp;
                Properties props;
                String line = this.getCellValue(sheet, row, 1).toLowerCase();
                if ("".equals(line)) continue;
                String uuid = this.colUUID > 0 ? this.getCellValue(sheet, row, this.colUUID) : null;
                String newUUID = null;
                long uuidElementId = -1L;
                if (uuid != null && !"".equals(uuid)) {
                    if (loadedTemplateUUIDs.contains(uuid)) {
                        if (!this.app.getDialog().showConfirmDialog("error.template.double-uuid", this.project.getResourceText("error.template.title"), new Object[]{row})) return null;
                        newUUID = UUID.randomUUID().toString();
                    } else {
                        loadedTemplateUUIDs.add(uuid);
                        uuidElementId = this.project.getDatastorage().getElementId(UUID.fromString(uuid));
                        if (uuidElementId > 0L && this.project.getDatastorage().isDeleted(uuidElementId)) {
                            groupMap.put(uuid, uuidElementId);
                        }
                    }
                }
                if ("grp".equalsIgnoreCase(line) || "grp1".equalsIgnoreCase(line)) {
                    boolean group1Exists;
                    boolean validUUID;
                    hasGroups = true;
                    props = this.getRowProperties(this.colGroup, sheet, row, newUUID);
                    if (props.getProperty("title") == null || "".equals(props.getProperty("title"))) continue;
                    boolean bl = validUUID = useUUID && props.getProperty("meta_uuid") != null && !"".equals(props.getProperty("meta_uuid"));
                    boolean bl2 = validUUID ? uuidElementId > 0L : (group1Exists = groupMap1Title.containsKey(props.getProperty("title").trim()));
                    if (group1Exists) {
                        ++countModified;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " GRP1 [UPDATE]: " + props.getProperty("title"));
                        grp = validUUID ? (CmsLocationgroup)this.project.loadElement(UUID.fromString(props.getProperty("meta_uuid")), this.project.getUser()) : (CmsLocationgroup)this.project.loadElement(groupMap1Title.get(props.getProperty("title").trim()), this.project.getUser());
                        grp.setUUID(props.getProperty("meta_uuid"));
                        locationMap = this.loadExistingLocationTemplates(grp.getId(), useUUID);
                        locationMapTitle = this.loadExistingLocationTemplates(grp.getId(), false);
                        if (!useUUID) {
                            observationMap = this.loadExistingGroupObservationTemplates(grp.getId(), useUUID);
                        }
                        observationMapTitle = this.loadExistingGroupObservationTemplates(grp.getId(), false);
                        HashMap<String, Long> hashMap2 = this.loadExistingGroups(grp.getId(), false);
                        groupMap3Title.clear();
                    } else {
                        ++countNew;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " GRP1 [INSERT]: " + props.getProperty("title"));
                        grp = (CmsLocationgroup)this.project.createElement("locationgroup", this.project.getUser());
                        grp.setUUID(props.getProperty("meta_uuid"));
                        locationMap.clear();
                        locationMapTitle.clear();
                        if (!useUUID) {
                            observationMap.clear();
                        }
                        observationMapTitle.clear();
                        var21_23.clear();
                        groupMap3Title.clear();
                    }
                    grp.setAttributes(props);
                    if (grp.isTrash()) {
                        grp.restoreFromTrash();
                    }
                    grp.getIntegerAttribute("itemsort").setValue(itemSort + row);
                    if (!this.checkUUID(uuidElementId, grp, row)) {
                        return null;
                    }
                    grp.save();
                    loadedTemplateIds.add(grp.getId());
                    lastGroup = grp;
                    lastGroup1 = grp;
                    lastGroup2 = null;
                    lastLocationTemplate = null;
                    lastObservationTemplate = null;
                    continue;
                }
                if ("grp2".equalsIgnoreCase(line)) {
                    boolean group2Exists;
                    boolean validUUID;
                    if (lastGroup1 == null) {
                        this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\nGRP2 ben\u00f6tigt eine dar\u00fcber definierte GRP1/GRP");
                        return null;
                    }
                    props = this.getRowProperties(this.colGroup, sheet, row, newUUID);
                    boolean bl = validUUID = useUUID && props.getProperty("meta_uuid") != null && !"".equals(props.getProperty("meta_uuid"));
                    boolean bl3 = validUUID ? uuidElementId > 0L : (group2Exists = var21_23.containsKey(props.getProperty("title")));
                    if (group2Exists) {
                        ++countModified;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " GRP2 [UPDATE]: " + props.getProperty("title"));
                        grp = validUUID ? (CmsLocationgroup)this.project.loadElement(UUID.fromString(props.getProperty("meta_uuid")), this.project.getUser()) : (CmsLocationgroup)this.project.loadElement((Long)var21_23.get(props.getProperty("title")), this.project.getUser());
                        grp.setUUID(props.getProperty("meta_uuid"));
                        locationMap = this.loadExistingLocationTemplates(grp.getId(), useUUID);
                        locationMapTitle = this.loadExistingLocationTemplates(grp.getId(), false);
                        if (!useUUID) {
                            observationMap = this.loadExistingGroupObservationTemplates(grp.getId(), useUUID);
                        }
                        observationMapTitle = this.loadExistingGroupObservationTemplates(grp.getId(), false);
                        groupMap3Title = this.loadExistingGroups(grp.getId(), false);
                    } else {
                        ++countNew;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " GRP2 [INSERT]: " + props.getProperty("title"));
                        grp = (CmsLocationgroup)this.project.createElement("locationgroup", this.project.getUser());
                        grp.setUUID(props.getProperty("meta_uuid"));
                        locationMap.clear();
                        locationMapTitle.clear();
                        if (!useUUID) {
                            observationMap.clear();
                        }
                        observationMapTitle.clear();
                        groupMap3Title.clear();
                    }
                    grp.setAttributes(props);
                    if (grp.isTrash()) {
                        grp.restoreFromTrash();
                    }
                    grp.getLongAttribute("parentgroup").setValue(lastGroup1.getId());
                    grp.getIntegerAttribute("itemsort").setValue(itemSort + row);
                    if (!this.checkUUID(uuidElementId, grp, row)) {
                        return null;
                    }
                    grp.save();
                    loadedTemplateIds.add(grp.getId());
                    lastGroup = grp;
                    lastGroup2 = grp;
                    lastLocationTemplate = null;
                    lastObservationTemplate = null;
                    continue;
                }
                if ("grp3".equalsIgnoreCase(line)) {
                    boolean group3Exists;
                    boolean validUUID;
                    if (lastGroup2 == null) {
                        this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\nGRP3 ben\u00f6tigt eine dar\u00fcber definierte GRP2");
                        return null;
                    }
                    props = this.getRowProperties(this.colGroup, sheet, row, newUUID);
                    boolean bl = validUUID = useUUID && props.getProperty("meta_uuid") != null && !"".equals(props.getProperty("meta_uuid"));
                    boolean bl4 = validUUID ? uuidElementId > 0L : (group3Exists = groupMap3Title.containsKey(props.getProperty("title")));
                    if (group3Exists) {
                        ++countModified;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " GRP3 [UPDATE]: " + props.getProperty("title"));
                        grp = validUUID ? (CmsLocationgroup)this.project.loadElement(UUID.fromString(props.getProperty("meta_uuid")), this.project.getUser()) : (CmsLocationgroup)this.project.loadElement((Long)groupMap3Title.get(props.getProperty("title")), this.project.getUser());
                        grp.setUUID(props.getProperty("meta_uuid"));
                        locationMap = this.loadExistingLocationTemplates(grp.getId(), useUUID);
                        locationMapTitle = this.loadExistingLocationTemplates(grp.getId(), false);
                        if (!useUUID) {
                            observationMap = this.loadExistingGroupObservationTemplates(grp.getId(), useUUID);
                        }
                        observationMapTitle = this.loadExistingGroupObservationTemplates(grp.getId(), false);
                    } else {
                        ++countNew;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " GRP3 [INSERT]: " + props.getProperty("title"));
                        grp = (CmsLocationgroup)this.project.createElement("locationgroup", this.project.getUser());
                        grp.setUUID(props.getProperty("meta_uuid"));
                        locationMap.clear();
                        locationMapTitle.clear();
                        if (!useUUID) {
                            observationMap.clear();
                        }
                        observationMapTitle.clear();
                    }
                    grp.setAttributes(props);
                    if (grp.isTrash()) {
                        grp.restoreFromTrash();
                    }
                    grp.getLongAttribute("parentgroup").setValue(lastGroup2.getId());
                    grp.getIntegerAttribute("itemsort").setValue(itemSort + row);
                    if (!this.checkUUID(uuidElementId, grp, row)) {
                        return null;
                    }
                    grp.save();
                    loadedTemplateIds.add(grp.getId());
                    lastGroup = grp;
                    lastLocationTemplate = null;
                    lastObservationTemplate = null;
                    continue;
                }
                if ("g".equalsIgnoreCase(line)) {
                    boolean locationExists;
                    boolean validUUID;
                    rowProps = this.getRowProperties(this.colLocation, sheet, row, newUUID);
                    props = new Properties();
                    for (String k : rowProps.stringPropertyNames()) {
                        ta = this.getSettings().getLocationAttribute(k);
                        if (fileversion <= 11 || ta == null) {
                            props.put(k, rowProps.getProperty(k));
                            continue;
                        }
                        props.put(ta.getCmsCode(), rowProps.getProperty(k));
                    }
                    boolean bl = validUUID = useUUID && props.getProperty("meta_uuid") != null && !"".equals(props.getProperty("meta_uuid"));
                    boolean bl5 = validUUID ? uuidElementId > 0L : (locationExists = locationMapTitle.containsKey(props.getProperty("title")));
                    if (locationExists) {
                        ++countModified;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " G    [UPDATE]: " + props.getProperty("title"));
                        e = validUUID ? (CmsLocationTemplate)this.project.loadElement(UUID.fromString(props.getProperty("meta_uuid")), this.project.getUser()) : (CmsLocationTemplate)this.project.loadElement(locationMapTitle.get(props.getProperty("title")), this.project.getUser());
                        e.setUUID(props.getProperty("meta_uuid"));
                        if (!useUUID) {
                            observationMap = this.loadExistingObservationTemplates(e.getId(), useUUID);
                        }
                        observationMapTitle = this.loadExistingObservationTemplates(e.getId(), false);
                    } else {
                        ++countNew;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " G    [INSERT]: " + props.getProperty("title"));
                        e = (CmsLocationTemplate)this.project.createElement("locationtemplate", this.project.getUser());
                        e.setUUID(props.getProperty("meta_uuid"));
                        if (useUUID) {
                            locationMap.put(e.getUUIDasString(), e.getId());
                            locationMapTitle.put(props.getProperty("title"), e.getId());
                        } else {
                            locationMap.put(props.getProperty("title"), e.getId());
                            locationMapTitle.put(props.getProperty("title"), e.getId());
                        }
                        if (!useUUID) {
                            observationMap.clear();
                        }
                        observationMapTitle.clear();
                    }
                    ((CmsLocationTemplate)e).setAttributes(props);
                    CmsIcon i = null;
                    String icon_file = null;
                    String icon_title = null;
                    if (fileversion <= 11) {
                        icon_title = props.getProperty("icon_title");
                        icon_file = props.getProperty("icon_file");
                        if (icon_title != null && icon_file != null && !"".equals(icon_file)) {
                            if ("".equals(icon_title)) {
                                icon_title = Util.getFileNameWithoutExtension((File)new File(icon_file));
                            }
                            i = (CmsIcon)this.project.getIcon(icon_title);
                        }
                    } else {
                        Long iconId;
                        icon_file = props.getProperty("icon");
                        if (icon_file != null && !"".equals(icon_file) && (iconId = iconMap.get(icon_title = Util.getFileNameWithoutExtension((File)new File(icon_file)))) != null) {
                            i = (CmsIcon)this.project.loadElement(iconId, this.project.getUser());
                        }
                    }
                    if (i == null && icon_file != null) {
                        if (f != null) {
                            i = this.createIcon(f, icon_file, icon_title);
                        } else if (is2 != null) {
                            i = this.createIcon(is2, icon_file, icon_title);
                        }
                    }
                    if (i != null) {
                        e.getRelationAttribute("icon").set(i);
                    }
                    if (lastGroup != null) {
                        e.getRelationAttribute("locationgroup").set(lastGroup.getId());
                    }
                    if (e.isTrash()) {
                        e.restoreFromTrash();
                    }
                    e.getIntegerAttribute("itemsort").setValue(itemSort + row);
                    if (!this.checkUUID(uuidElementId, e, row)) {
                        return null;
                    }
                    e.save();
                    loadedTemplateIds.add(e.getId());
                    lastLocationTemplate = e;
                    lastObservationTemplate = null;
                    continue;
                }
                if (line.toLowerCase().startsWith("b")) {
                    boolean observationExists;
                    boolean validUUID;
                    rowProps = this.getRowProperties(this.colObservation, sheet, row, newUUID);
                    props = new Properties();
                    for (String k : rowProps.stringPropertyNames()) {
                        ta = this.getSettings().getObservationAttribute(k);
                        if (fileversion <= 11 || ta == null) {
                            props.put(k, rowProps.getProperty(k));
                            continue;
                        }
                        if ("repeat".equals(ta.getId())) {
                            props.put("duedate", rowProps.getProperty(k));
                            continue;
                        }
                        props.put(ta.getCmsCode(), rowProps.getProperty(k));
                    }
                    if ("".equals(props.getProperty("title", ""))) {
                        props.setProperty("title", props.getProperty("description"));
                    }
                    if ("".equals(props.getProperty("title", ""))) continue;
                    int type = 1;
                    if ("bi".equalsIgnoreCase(line)) {
                        type = 3;
                    } else if ("bk".equalsIgnoreCase(line)) {
                        type = 2;
                    } else if ("ba".equalsIgnoreCase(line)) {
                        type = 4;
                    }
                    boolean bl = validUUID = useUUID && !"".equals(props.getProperty("meta_uuid"));
                    boolean bl6 = validUUID ? uuidElementId > 0L : (observationExists = observationMapTitle.containsKey(props.getProperty("title")));
                    if (observationExists) {
                        ++countModified;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " " + line + "   [UPDATE]: " + props.getProperty("title"));
                        e = validUUID ? (CmsObservationTemplate)this.project.loadElement(UUID.fromString(props.getProperty("meta_uuid")), this.project.getUser()) : (CmsObservationTemplate)this.project.loadElement(observationMapTitle.get(props.getProperty("title")), this.project.getUser());
                        e.setUUID(props.getProperty("meta_uuid"));
                        measureMap = this.loadExistingMeasureTemplates(e.getId());
                    } else {
                        ++countNew;
                        this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " " + line + "   [INSERT]: " + props.getProperty("title"));
                        e = (CmsObservationTemplate)this.project.createElement("observationtemplate", this.project.getUser());
                        e.setUUID(props.getProperty("meta_uuid"));
                        if (useUUID) {
                            observationMap.put(e.getUUIDasString(), e.getId());
                            observationMapTitle.put(props.getProperty("title"), e.getId());
                        } else {
                            observationMap.put(props.getProperty("title"), e.getId());
                            observationMapTitle.put(props.getProperty("title"), e.getId());
                        }
                        measureMap.clear();
                    }
                    if (lastLocationTemplate != null) {
                        e.getRelationAttribute("location").set(lastLocationTemplate.getId());
                        e.getRelationAttribute("locationgroup").clear();
                    } else if (lastGroup != null) {
                        e.getRelationAttribute("location").clear();
                        e.getRelationAttribute("locationgroup").set(lastGroup.getId());
                    } else {
                        e.getRelationAttribute("location").clear();
                        e.getRelationAttribute("locationgroup").clear();
                    }
                    ((CmsObservationTemplate)e).setAttributes(props);
                    e.getKeyAttribute("type").setValue((long)type);
                    if (e.isTrash()) {
                        e.restoreFromTrash();
                    }
                    e.getIntegerAttribute("itemsort").setValue(itemSort + row);
                    if (!this.checkUUID(uuidElementId, e, row)) {
                        return null;
                    }
                    e.save();
                    loadedTemplateIds.add(e.getId());
                    lastObservationTemplate = e;
                    continue;
                }
                if (!"m".equalsIgnoreCase(line) || lastObservationTemplate == null) continue;
                props = this.getRowProperties(this.colMeasure, sheet, row, newUUID);
                if (measureMap.containsKey(props.getProperty("title"))) {
                    ++countModified;
                    this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " M    [UPDATE]: " + props.getProperty("title"));
                    e = (CmsMeasureTemplate)this.project.loadElement((Long)measureMap.get(props.getProperty("title")), this.project.getUser());
                    e.setUUID(props.getProperty("meta_uuid"));
                } else {
                    ++countNew;
                    this.project.getLogger().fine("LOADTEMPLATE: Reading line " + row + " M    [INSERT]: " + props.getProperty("title"));
                    e = (CmsMeasureTemplate)this.project.createElement("measuretemplate", this.project.getUser());
                    e.setUUID(props.getProperty("meta_uuid"));
                    e.getRelationAttribute("observationtemplate").set(lastObservationTemplate.getId());
                    measureMap.put(props.getProperty("title"), e.getId());
                }
                e.setAttributes(props);
                if (e.isTrash()) {
                    e.restoreFromTrash();
                }
                e.getIntegerAttribute("itemsort").setValue(itemSort + row);
                if (!this.checkUUID(uuidElementId, e, row)) {
                    return null;
                }
                e.save();
                loadedTemplateIds.add(e.getId());
            }
            Iterator iterator = existingTemplateIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (loadedTemplateIds.contains(id)) continue;
                this.missingTemplateIds.add(id);
            }
            countMissing = this.missingTemplateIds.size();
            this.loadResult.setProperty("text.new", Integer.toString(countNew));
            this.loadResult.setProperty("text.modified", Integer.toString(countModified));
            this.loadResult.setProperty("text.missing", Integer.toString(countMissing));
            return hasGroups;
        }
        catch (Exception e) {
            this.app.getDialog().showErrorDialog("Fehler beim Laden der Vorlage\nArbeitsblatt " + sheet.getSheetName() + ", Zeile " + row + "\n" + e.getLocalizedMessage());
        }
        return hasGroups;
    }

    public ArrayList<Long> getMissingTemplateIds() {
        return this.missingTemplateIds;
    }

    private boolean checkUUID(long uuidElementId, CmsElement ele, int row) {
        if (this.overwriteUUIDalreadyInUse) {
            return true;
        }
        if (uuidElementId > 0L && ele.getId() != uuidElementId) {
            String t = this.project.getDatastorage().getElementTitle(uuidElementId);
            if (ele.getTitle().equalsIgnoreCase(t)) {
                return true;
            }
            if (this.createnewUUIDalreadyInUse) {
                ele.createNewUUID();
                return true;
            }
            int result = this.app.getDialog().showInfoOptionDialog("error.template.uuid-already-in-use", this.project.getResourceText("error.template.title"), new Object[]{row, ele.getTitle(), t}, new Object[]{"\u00dcberschreiben", "Neu erstellen", "Abbrechen"});
            switch (result) {
                case 0: {
                    this.overwriteUUIDalreadyInUse = true;
                    return true;
                }
                case 1: {
                    this.createnewUUIDalreadyInUse = true;
                    ele.createNewUUID();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private CmsIcon createIcon(InputStream is, String icon_file, String icon_title) {
        CmsIcon i = null;
        return i;
    }

    private CmsIcon createIcon(File f, String icon_file, String icon_title) {
        CmsIcon i = null;
        File file = new File(f.getParentFile(), icon_file);
        if (file.isFile()) {
            try {
                BufferedImage image = ImageIO.read(file);
                File tempFile = new File(this.app.getProject().getTempfileLocation(), file.getName());
                ImageIO.write((RenderedImage)image, Util.getFileExtension((File)file), tempFile);
                i = (CmsIcon)this.project.createElement("icon", this.project.getUser());
                i.setAttributeValue("title", icon_title);
                UploadItem item = i.getUploadAttribute("file").addUpload(tempFile);
                item.setStatus(1);
                i.save();
            }
            catch (IOException ex) {
                Logger.getLogger(TemplateManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return i;
    }

    private Properties getRowProperties(HashMap<String, Integer> coldef, Sheet sheet, int row, String newUUID) {
        Properties props = new Properties();
        for (String key : coldef.keySet()) {
            String val = this.getCellValue(sheet, row, coldef.get(key));
            if (val == null) continue;
            props.put(key, val.trim());
        }
        if (newUUID != null) {
            props.put("meta_uuid", newUUID);
        }
        return props;
    }

    private String getCellValue(Sheet sh, int row, int col) {
        Row r = sh.getRow(row - 1);
        if (r == null) {
            return "";
        }
        Cell c = r.getCell(col - 1);
        if (c == null) {
            return "";
        }
        switch (c.getCellType()) {
            case BOOLEAN: {
                return c.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case NUMERIC: {
                double v = c.getNumericCellValue();
                if (v == Math.floor(v)) {
                    return Integer.toString((int)v);
                }
                return Double.toString(c.getNumericCellValue());
            }
            case STRING: {
                return c.getStringCellValue();
            }
            case _NONE: {
                return "";
            }
        }
        return c.getStringCellValue();
    }

    private String getCellValue(Sheet sh, int row, int col, String defaultValue) {
        String v = this.getCellValue(sh, row, col);
        return v == null || "".equals(v) ? defaultValue : v;
    }

    private int getCellValueInt(Sheet sh, int row, int col, int defaultValue) {
        String v = this.getCellValue(sh, row, col, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private float getCellValueFloat(Sheet sh, int row, int col, float defaultValue) {
        String v = this.getCellValue(sh, row, col, Float.toString(defaultValue));
        try {
            return Float.parseFloat(v);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTemplatesFromZIP(String u) {
        OutputStream os = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(u);
            File f = new File(this.project.getTempfileLocation(), "vorlage.zip");
            os = new FileOutputStream(f);
            Util.copy((InputStream)is, (OutputStream)os);
            this.loadTemplatesFromZIP(f);
            f.delete();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TemplateManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TemplateManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TemplateManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void loadTemplatesFromZIP(File f) {
        try {
            ThemisFile tf = new ThemisFile().setContentType(ThemisFile.ContentType.TEMPLATE);
            String string = tf.loadFromFile(f, true).getError();
        }
        catch (IOException ex) {
            Logger.getLogger(TemplateManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JDOMException ex) {
            Logger.getLogger(TemplateManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Properties getProperties(ZipFile zip, ZipEntry entry) throws IOException {
        InputStream inputStream = zip.getInputStream(entry);
        Properties props = new Properties();
        props.load(inputStream);
        inputStream.close();
        return props;
    }

    private CmsElement createElement(ZipFile zip, ZipEntry entry) throws IOException, JDOMException {
        InputStream inputStream = zip.getInputStream(entry);
        InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(is);
        CmsElement e = this.project.createElement(doc, this.project.getUser(), zip);
        return e;
    }

    public void loadTemplatesFromXml(File f) {
        boolean overwriteTemplates = false;
        int countOverwriteDialog = 0;
        boolean overwriteIcons = false;
        int countOverwriteIcon = 0;
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(f);
        }
        catch (JDOMException ex) {
            this.app.getDialog().showErrorDialog("Error while loading XML.", (Exception)((Object)ex));
            this.project.getLogger().log(Level.WARNING, "Error while parsing XML: " + ex.getMessage());
            return;
        }
        catch (IOException ex) {
            this.app.getDialog().showErrorDialog(this.project.getResourceText("ThemisApplication.errorLoadingXML.text", this.app.getLocale()), ex);
            this.project.getLogger().log(Level.WARNING, "Error while reading file: " + ex.getMessage());
            return;
        }
        try {
            HashMap<String, Long> locations = new HashMap<String, Long>();
            HashMap<String, Long> groups = new HashMap<String, Long>();
            HashMap<String, Long> contacts = new HashMap<String, Long>();
            HashMap<String, Long> icons = new HashMap<String, Long>();
            HashMap<String, Long> observations = new HashMap<String, Long>();
            HashMap<String, Long> topics = new HashMap<String, Long>();
            HashMap<String, Long> measures = new HashMap<String, Long>();
            ArrayList<Element> observationElements = new ArrayList<Element>();
            CmsSqlSearch search = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            search.setElementtypes("locationtemplate");
            search.addSelectMeta();
            search.addSelectAllAttributes("locationtemplate");
            List recs = search.search().getResult();
            for (DataRecord rec : recs) {
                locations.put(rec.get("locationgroup").trim() + ":" + rec.get("title"), rec.getLong("meta_id"));
            }
            search = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            search.setElementtypes("locationgroup");
            search.addSelectMeta();
            search.addSelectAllAttributes("locationgroup");
            recs = search.search().getResult();
            for (DataRecord rec : recs) {
                groups.put(rec.get("title"), rec.getLong("meta_id"));
            }
            search = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            search.setElementtypes("company");
            search.addSelectAllAttributes("company");
            recs = search.search().getResult();
            for (DataRecord rec : recs) {
                contacts.put(rec.get("name"), rec.getLong("meta_id"));
            }
            search = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            search.setElementtypes("icon");
            search.addSelectMeta();
            search.addSelectAllAttributes("icon");
            recs = search.search().getResult();
            for (DataRecord rec : recs) {
                icons.put(rec.get("title"), rec.getLong("meta_id"));
            }
            search = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            search.setElementtypes("observationtemplate");
            search.addSelectMeta();
            search.addSelectAllAttributes("observationtemplate");
            recs = search.search().getResult();
            for (DataRecord rec : recs) {
                long idloc = rec.isEmpty("idlocation") ? -1L : rec.getLong("idlocation");
                observations.put(idloc + ":" + rec.get("title"), Long.parseLong(rec.get("meta_id")));
            }
            search = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            search.setElementtypes("measuretemplate");
            search.addSelectMeta();
            search.addSelectAllAttributes("measuretemplate");
            recs = search.search().getResult();
            for (DataRecord rec : recs) {
                long idObs = rec.isEmpty("idobservationtemplate") ? -1L : rec.getLong("idobservationtemplate");
                measures.put(idObs + ":" + rec.get("title"), Long.parseLong(rec.get("meta_id")));
            }
            search = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            search.setElementtypes("company");
            search.addSelectMeta();
            recs = search.search().getResult();
            for (DataRecord rec : recs) {
                topics.put(rec.get("meta_title"), rec.getLong("metad_id"));
            }
            float templateversion = 2.2f;
            if (doc.getRootElement().getAttribute("version") != null) {
                templateversion = doc.getRootElement().getAttribute("version").getFloatValue();
            }
            if ((double)templateversion >= 3.0) {
                List groupElements = doc.getRootElement().getChildren("locationgroup");
                for (Element groupElement : groupElements) {
                    String s = groupElement.getText();
                    if (groups.containsKey(s) && !overwriteTemplates && countOverwriteDialog == 0) {
                        ++countOverwriteDialog;
                        if (this.app.getDialog().showConfirmDialog(this.project.getResourceText("ThemisApplication.overwriteTempaltes.text", this.app.getLocale()))) {
                            overwriteTemplates = true;
                        }
                    }
                    if (!overwriteTemplates && groups.containsKey(s)) continue;
                    CmsLocationgroup g = overwriteTemplates && groups.containsKey(s) ? (CmsLocationgroup)this.project.loadElement((Long)groups.get(s), this.project.getUser()) : (groups.containsKey(s) ? (CmsLocationgroup)this.project.loadElement((Long)groups.get(s), this.project.getUser()) : (CmsLocationgroup)this.project.createElement("locationgroup"));
                    g.setAttributeValue("title", groupElement.getText());
                    g.save();
                    groups.put(s, g.getId());
                }
            }
            List locationElements = doc.getRootElement().getChildren("location");
            for (Element locationElement : locationElements) {
                long locationId = 0L;
                String s = locationElement.getAttributeValue("group").trim() + ":" + locationElement.getAttributeValue("title");
                if (locations.containsKey(s) && !overwriteTemplates && countOverwriteDialog == 0) {
                    ++countOverwriteDialog;
                    if (this.app.getDialog().showConfirmDialog(MessageFormat.format(this.project.getResourceText("ThemisApplication.overwriteTemplates2.text", this.app.getLocale()), s))) {
                        overwriteTemplates = true;
                    }
                }
                if (overwriteTemplates || !locations.containsKey(s)) {
                    CmsLocationTemplate t = overwriteTemplates && locations.containsKey(s) ? (CmsLocationTemplate)this.project.loadElement((Long)locations.get(s), this.project.getUser()) : (CmsLocationTemplate)this.project.createElement("locationtemplate");
                    t.setAttributeValue("title", locationElement.getAttributeValue("title"));
                    if ((double)templateversion < 3.0) {
                        t.setAttributeValue("description", locationElement.getAttributeValue("description"));
                    } else {
                        String[] keyattributesLoc;
                        t.setAttributeValue("description", locationElement.getChildText("description"));
                        t.setAttributeValue("code", locationElement.getAttributeValue("code"));
                        t.setAttributeValue("code2", locationElement.getAttributeValue("code2"));
                        t.setAttributeValue("quantity", locationElement.getAttributeValue("quantity"));
                        t.setAttributeValue("dimwidth", locationElement.getAttributeValue("dimwidth"));
                        t.setAttributeValue("dimheight", locationElement.getAttributeValue("dimheight"));
                        t.setAttributeValue("dimdiameter", locationElement.getAttributeValue("dimdiameter"));
                        t.setAttributeValue("dimarea", locationElement.getAttributeValue("dimarea"));
                        for (String keyattribute : keyattributesLoc = new String[]{"list1,list1,list1", "list2,list2,list2"}) {
                            String[] items = keyattribute.split(",");
                            String keyattributeValue = locationElement.getAttributeValue(items[0]);
                            if ("".equals(keyattributeValue) || keyattributeValue == null) continue;
                            long keyId = this.project.getKeytable(items[2]).getId(keyattributeValue);
                            if (keyId < 0L) {
                                long newid = this.project.getKeytable(items[2]).getNextId();
                                this.project.getKeytable(items[2]).addTerm(newid, this.project.getUser().getCurrentLanguage(), locationElement.getAttributeValue(items[0]));
                                this.project.getKeytable(items[2]).save();
                                keyId = newid;
                            }
                            t.setAttributeValue(items[1], Long.toString(keyId));
                        }
                        String grp = locationElement.getAttributeValue("group");
                        if (grp != null && !"".equals(grp)) {
                            if (groups.containsKey(grp)) {
                                long idgrp = (Long)groups.get(grp);
                                t.getRelationAttribute("locationgroup").set(idgrp);
                            } else {
                                CmsLocationgroup g2 = (CmsLocationgroup)this.project.createElement("locationgroup");
                                g2.setAttributeValue("title", grp);
                                g2.save();
                                t.getRelationAttribute("locationgroup").set(g2.getId());
                                groups.put(grp, g2.getId());
                            }
                        }
                    }
                    String iconfile = locationElement.getAttributeValue("icon_file");
                    String icontitle = locationElement.getAttributeValue("icon_title");
                    if (iconfile != null && icontitle != null && !"".equals(iconfile) && !"".equals(icontitle)) {
                        CmsIcon icon;
                        if (icons.containsKey(icontitle)) {
                            icon = (CmsIcon)this.project.loadElement((Long)icons.get(icontitle), this.project.getUser());
                            String[] nameUploadItem = icon.getUploadAttribute("file").getFirstUploadItem().getFilename().split("_", 2);
                            if (!iconfile.equals(nameUploadItem[1]) && countOverwriteIcon == 0) {
                                ++countOverwriteIcon;
                                if (this.app.getDialog().showConfirmDialog(this.project.getResourceText("ThemisApplication.newIcon.text", this.app.getLocale()), this.project.getResourceText("ThemisApplication.newIconShort.text", this.app.getLocale()))) {
                                    overwriteIcons = true;
                                }
                            }
                            if (overwriteIcons) {
                                icon.getUploadAttribute("file").addUpload(new File(f.getParentFile(), iconfile));
                                icon.save();
                            }
                        } else {
                            icon = (CmsIcon)this.project.createElement("icon");
                            icon.setAttributeValue("title", icontitle);
                            icon.getUploadAttribute("file").addUpload(new File(f.getParentFile(), iconfile));
                            icon.save();
                            icons.put(icon.getAttributeValue("title"), icon.getAttributeValueLong("meta_id"));
                        }
                        if (icon != null) {
                            t.getRelationAttribute("icon").set(icon.getId());
                        }
                    }
                    t.save();
                    locations.put(s, t.getId());
                    locationId = t.getId();
                } else {
                    locationId = (Long)locations.get(s);
                }
                List elements = locationElement.getChildren("observation");
                for (Element element : elements) {
                    element.setAttribute("idlocation", Long.toString(locationId));
                    observationElements.add(element);
                }
            }
            List elements = doc.getRootElement().getChildren("observation");
            for (Element element : elements) {
                observationElements.add(element);
            }
            for (Element observationElement : observationElements) {
                String[] keyattributes;
                long locationId;
                String s = (double)templateversion >= 3.0 ? observationElement.getAttributeValue("title") : observationElement.getText();
                Attribute att = observationElement.getAttribute("idlocation");
                long l = locationId = att == null ? -1L : att.getLongValue();
                if (observations.containsKey(locationId + ":" + s) && !overwriteTemplates && countOverwriteDialog == 0) {
                    ++countOverwriteDialog;
                    if (this.app.getDialog().showConfirmDialog(this.project.getResourceText("ThemisApplication.overwriteTempaltes.text", this.app.getLocale()))) {
                        overwriteTemplates = true;
                    }
                }
                if (observations.containsKey(locationId + ":" + s) && !overwriteTemplates) continue;
                long obsId = observations.containsKey(locationId + ":" + s) ? (Long)observations.get(locationId + ":" + s) : -1L;
                CmsObservationTemplate t = obsId >= 0L ? (CmsObservationTemplate)this.project.loadElement(obsId, this.project.getUser()) : (CmsObservationTemplate)this.project.createElement("observationtemplate");
                t.setAttributeValue("description", observationElement.getChildText("info"));
                for (String keyattribute : keyattributes = new String[]{"type,observationtype,observationtype", "priority,priority,priority", "topic,topic,topic"}) {
                    String[] items = keyattribute.split(",");
                    String keyattributeValue = observationElement.getAttributeValue(items[0]);
                    if ("".equals(keyattributeValue) || keyattributeValue == null) continue;
                    long keyId = this.project.getKeytable(items[2]).getId(keyattributeValue);
                    if (keyId < 0L) {
                        long newid = this.project.getKeytable(items[2]).getNextId();
                        this.project.getKeytable(items[2]).addTerm(newid, this.project.getUser().getCurrentLanguage(), observationElement.getAttributeValue(items[0]));
                        this.project.getKeytable(items[2]).save();
                        keyId = newid;
                    }
                    t.setAttributeValue(items[1], Long.toString(keyId));
                }
                s = observationElement.getAttributeValue("responsible");
                if (s != null && !"".equals(s)) {
                    long cId = -1L;
                    if (contacts.containsKey(s)) {
                        cId = (Long)contacts.get(s);
                    } else {
                        CmsCompany company = (CmsCompany)this.project.createElement("company");
                        company.setAttributeValue("name", s);
                        company.save();
                        cId = company.getId();
                        contacts.put(company.getTitle(), cId);
                    }
                    t.getRelationAttribute("responsible").add(cId);
                }
                t.setAttributeValue("title", observationElement.getAttributeValue("title"));
                t.setAttributeValue("done", observationElement.getAttributeValue("done"));
                t.setAttributeValue("duedate", observationElement.getAttributeValue("duedate"));
                t.getKeyAttribute("repeat").setValue(observationElement.getAttributeValue("repeat"));
                if (locationId >= 0L) {
                    t.getRelationAttribute("location").set(locationId);
                }
                if ((double)templateversion >= 3.0) {
                    t.setAttributeValue("code", observationElement.getAttributeValue("code"));
                    t.setAttributeValue("quantity", observationElement.getAttributeValue("quantity"));
                }
                t.save();
                if (!((double)templateversion >= 3.0)) continue;
                List measureElements = observationElement.getChildren("measure");
                for (Element measureElement : measureElements) {
                    s = t.getId() + ":" + measureElement.getAttributeValue("title");
                    if (!measures.containsKey(s) || overwriteTemplates || countOverwriteDialog != 0) continue;
                    ++countOverwriteDialog;
                    if (this.app.getDialog().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/ontology/BundleThemis").getString("ThemisApplication.overwriteTempaltes.text")) && this.app.getDialog().showConfirmDialog(this.project.getResourceText("ThemisApplication.overwriteTempaltes.text", this.app.getLocale()))) {
                        overwriteTemplates = true;
                    }
                    if (measures.containsKey(s) && !overwriteTemplates) continue;
                    long measureId = measures.containsKey(s) ? (Long)measures.get(s) : -1L;
                    CmsMeasureTemplate m = measureId >= 0L ? (CmsMeasureTemplate)this.project.loadElement(measureId, this.project.getUser()) : (CmsMeasureTemplate)this.project.createElement("measuretemplate");
                    m.setAttributeValue("measure", measureElement.getText());
                    m.setAttributeValue("title", measureElement.getAttributeValue("title"));
                    m.getRelationAttribute("observationtemplate").set(t.getId());
                    m.save();
                }
            }
            this.app.getDialog().showInfoDialog(this.project.getResourceText("ThemisApplication.templatesLoaded2.text", this.app.getLocale()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateLocationGroupFullIds() {
        List recs = this.project.getDatastorage().executeQuery("SELECT idelement,parentgroup FROM tdtaEleLocationgroup", true).getResult();
        HashMap<Long, GroupFullSpec> map = this.updateLocationGroupFullIds(-1L, new HashMap<Long, GroupFullSpec>());
        for (long id : map.keySet()) {
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocationgroup SET  groupfullid=" + Util.toSqlString((String)map.get((Object)Long.valueOf((long)id)).fullid) + ",groupfullname=" + Util.toSqlString((String)map.get((Object)Long.valueOf((long)id)).fullname) + " WHERE idelement=" + id, true);
        }
    }

    private HashMap<Long, GroupFullSpec> updateLocationGroupFullIds(long parentId, HashMap<Long, GroupFullSpec> mapFull) {
        List<DataRecord> recs = this.getLocationGroups(parentId);
        for (DataRecord rec : recs) {
            long id = rec.getLong("meta_id");
            Long parent = rec.getLong("parentgroup");
            String fullId = id + ".";
            String fullName = rec.getString("title").replace("/", "-");
            if (parent != null && parent > 0L) {
                String parentFullId = mapFull.get((Object)parent).fullid;
                fullId = parentFullId + fullId;
                String parentFullName = mapFull.get((Object)parent).fullname;
                fullName = parentFullName + " / " + fullName;
            }
            mapFull.put(id, new GroupFullSpec(fullId, fullName));
            mapFull = this.updateLocationGroupFullIds(id, mapFull);
        }
        return mapFull;
    }

    public List<DataRecord> getLocationGroups() {
        return this.getLocationGroups(-1L);
    }

    public List<DataRecord> getLocationGroups(long idparent) {
        List<DataRecord> recs = this.readGroupsFromDatabase(null, idparent);
        for (DataRecord rec : recs) {
            String groupfullid = rec.getString("groupfullid");
            int level = groupfullid.split("\\.").length;
            if (level > 3) {
                this.project.getLogger().severe("Error in Group '" + rec.getString("meta_title") + "', groupfullid = " + groupfullid);
                level = 3;
            }
            rec.add("level", Integer.toString(level));
            if (idparent != -99L) continue;
            rec.add("meta_title", "      ".substring(0, 2 * (level - 1)) + rec.getString("meta_title"));
        }
        return recs;
    }

    public List<Long> getLocationGroupId(String term, long idparent) {
        List<DataRecord> recs = this.readGroupsFromDatabase(term, idparent);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DataRecord rec : recs) {
            ids.add(rec.getLong("meta_id"));
        }
        return ids;
    }

    public long getFirstLocationGroupId(String term, long idparent) {
        List<Long> ids = this.getLocationGroupId(term, idparent);
        return ids.isEmpty() ? -1L : ids.get(0);
    }

    public List<Long> getLocationGroupId(String term) {
        CmsElement e = this.project.getDefaultElement("locationgroup");
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("locationgroup");
        s.addWhereAttribute(e.getAttribute("title"), "=", term);
        ArrayList ids = s.search().getResultIds();
        return ids;
    }

    public List<DataRecord> getLocationTemplates(long idGroup) {
        return this.readTemplatesFromDatabase("locationtemplate", "locationgroup", idGroup);
    }

    public List<DataRecord> getLocationTemplates(String title, long idGroup) {
        return this.readTemplatesFromDatabase("locationtemplate", "locationgroup", title, idGroup);
    }

    public long getFirstLocationTemplateId(String title, long idGroup) {
        List<DataRecord> recs = this.readTemplatesFromDatabase("locationtemplate", "locationgroup", title, idGroup);
        return recs.isEmpty() ? -1L : recs.get(0).getLong("meta_id");
    }

    public List<DataRecord> getObservationTemplates(long idGroup, long idLocation) {
        return this.getObservationTemplates(idGroup, idLocation, true, -1);
    }

    public List<DataRecord> getObservationTemplates(long idGroup, long idLocation, boolean includeTop, int level) {
        int[] types;
        SearchResult result;
        ArrayList recs = new ArrayList();
        CmsElement def = this.app.getProject().getDefaultElement("observationtemplate");
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes(def.getElementcode());
        s.addSelectTitle("meta_title");
        s.addSelect("ele.idtype", "type");
        s.addSelect("ele.itemsort", "itemsort");
        s.setSort("ele.itemsort,el.title");
        if (idLocation > 0L) {
            s.addWhereRelationId((CmsAttribute)def.getRelationAttribute("location"), "=", Long.toString(idLocation));
            result = s.search();
            recs.addAll(result.getResult());
        }
        ArrayList<Long> groupids = new ArrayList<Long>();
        while (idGroup > 0L) {
            s.clearWhere();
            s.addWhereRelationId((CmsAttribute)def.getRelationAttribute("locationgroup"), "=", Long.toString(idGroup));
            result = s.search();
            recs.addAll(0, result.getResult());
            idGroup = Util.parseLong((String)this.project.getDatastorage().getElementAttribute(idGroup, "parentgroup"), (long)-1L);
            if (groupids.contains(idGroup)) {
                idGroup = -1L;
                continue;
            }
            groupids.add(idGroup);
        }
        if (includeTop) {
            s.clearWhere();
            s.addWhereRelationNone((CmsAttribute)def.getRelationAttribute("locationgroup"));
            s.addWhereRelationNone((CmsAttribute)def.getRelationAttribute("location"));
            result = s.search();
            recs.addAll(0, result.getResult());
        }
        if (level >= 0) {
            for (DataRecord rec : recs) {
                rec.add("level", Integer.toString(level));
            }
        }
        ArrayList<DataRecord> recsSort = new ArrayList<DataRecord>();
        for (int obstype : types = new int[]{2, 1, 4, 3}) {
            for (DataRecord rec : recs) {
                if (rec.getInt("type", Integer.valueOf(-1)) != obstype) continue;
                recsSort.add(rec);
            }
        }
        return recsSort;
    }

    public List<DataRecord> getMeasureTemplates(long idObservation) {
        return this.getMeasureTemplates(idObservation, -1);
    }

    public List<DataRecord> getMeasureTemplates(long idObservation, int level) {
        SearchResult result;
        ArrayList<DataRecord> recs = new ArrayList<DataRecord>();
        ThemisProject project = ThemisApplication.getInstance().getProject();
        CmsElement def = project.getDefaultElement("measuretemplate");
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)project, project.getUser(), false);
        s.setElementtypes(def.getElementcode());
        s.addSelectTitle("meta_title");
        s.addSelect("ele.titel", "title");
        s.addSelect("ele.measure", "measure");
        s.setSort("ele.titel");
        if (idObservation > 0L) {
            s.addWhereRelationId((CmsAttribute)def.getRelationAttribute("observationtemplate"), "=", Long.toString(idObservation));
            result = s.search();
            recs.addAll(result.getResult());
        }
        s.clearWhere();
        s.addWhereRelationNone((CmsAttribute)def.getRelationAttribute("observationtemplate"));
        result = s.search();
        recs.addAll(0, result.getResult());
        if (level >= 0) {
            for (DataRecord rec : recs) {
                rec.add("level", Integer.toString(level));
            }
        }
        return recs;
    }

    private List<DataRecord> readGroupsFromDatabase(String title, long idparent) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("locationgroup");
        s.addSelectAllAttributes("locationgroup");
        s.setSort("ele.itemsort,ele.groupfullname,el.title");
        if (idparent != -99L) {
            if (idparent < 0L) {
                s.addWhere("ele.parentgroup<=0 OR ele.parentgroup IS NULL");
            } else {
                s.addWhere("ele.parentgroup=" + idparent);
            }
        }
        if (title != null && !"".equals(title)) {
            s.addWhere("ele.titel=" + Util.toSqlString((String)title));
        }
        List recs = s.search().getResult();
        return recs;
    }

    private List<DataRecord> readTemplatesFromDatabase(String elementtype, String relationattribute, long parentId) {
        return this.readTemplatesFromDatabase(elementtype, relationattribute, null, parentId);
    }

    private List<DataRecord> readTemplatesFromDatabase(String elementtype, String relationattribute, String title, long parentId) {
        String dbField;
        CmsAttribute att;
        CmsElement eleDef = this.app.getProject().getDefaultElement(elementtype);
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes(elementtype);
        s.addSelectAllAttributes(elementtype);
        s.setSort("ele.itemsort,el.title");
        if (relationattribute != null) {
            if (parentId < 0L) {
                s.addWhereRelationNone((CmsAttribute)eleDef.getRelationAttribute(relationattribute));
            } else {
                s.addWhereRelationId((CmsAttribute)eleDef.getRelationAttribute(relationattribute), "=", Long.toString(parentId));
            }
        }
        if (title != null && (att = eleDef.getAttribute("title")) != null && (dbField = att.getField()) != null) {
            s.addWhere("ele." + dbField + "=" + Util.toSqlString((String)title));
        }
        SearchResult result = s.search();
        return result.getResult();
    }

    private int saveGroupToSheet(Sheet sheet, int row, long idgroup, int level) {
        long id;
        CmsLocationgroup g = (CmsLocationgroup)this.project.loadElement(idgroup, this.project.getUser());
        this.setLocationGroupRow(sheet, ++row, g, level);
        ++row;
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("observationtemplate");
        s.addSelectMeta();
        s.addSelectAllAttributes("observationtemplate");
        s.setSort("ele.itemsort,idtype,el.title");
        s.addWhere("idlocationgroup=" + g.getId());
        List recs2 = s.search().getResult();
        ArrayList ids2 = s.search().getResultIds();
        Iterator iterator = ids2.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            CmsObservationTemplate t = (CmsObservationTemplate)this.project.loadElement(id, this.project.getUser());
            this.setObservationRow(sheet, row, t);
            ++row;
            s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("measuretemplate");
            s.addSelectAllAttributes("measuretemplate");
            s.setSort("ele.itemsort,ele.titel");
            s.addWhere("idlocation=" + id);
            List recs3 = s.search().getResult();
            for (DataRecord rec3 : recs3) {
                this.setMeasureRow(sheet, row, rec3);
                ++row;
            }
        }
        s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("locationtemplate");
        s.addSelectAllAttributes("locationtemplate");
        s.setSort("ele.itemsort,el.title");
        s.addWhere("idgroup=" + g.getId());
        ids2 = s.search().getResultIds();
        iterator = ids2.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            ++row;
            CmsLocationTemplate l = (CmsLocationTemplate)this.project.loadElement(id, this.project.getUser());
            row = this.saveTemplateLocationToSheet(sheet, row, l);
        }
        List<DataRecord> recs = this.getLocationGroups(idgroup);
        for (DataRecord rec : recs) {
            row = this.saveGroupToSheet(sheet, row, rec.getLong("meta_id"), level + 1);
        }
        return row;
    }

    private int saveTemplateLocationToSheet(Sheet sheet, int row, CmsLocationTemplate l) {
        this.setLocationRow(sheet, row, l);
        ++row;
        CmsSqlSearch s2 = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s2.setElementtypes("observationtemplate");
        s2.addSelectMeta();
        s2.addSelectAllAttributes("observationtemplate");
        s2.setSort("ele.itemsort,idtype,el.title");
        s2.addWhere("idlocation=" + l.getId());
        ArrayList ids2 = s2.search().getResultIds();
        Iterator iterator = ids2.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            CmsObservationTemplate t = (CmsObservationTemplate)this.project.loadElement(id, this.project.getUser());
            this.setObservationRow(sheet, row, t);
            ++row;
            CmsSqlSearch s3 = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s3.setElementtypes("measuretemplate");
            s3.addSelectAllAttributes("measuretemplate");
            s3.setSort("ele.itemsort,ele.titel");
            s3.addWhere("idlocation=" + t.getId());
            List recs3 = s3.search().getResult();
            for (DataRecord rec3 : recs3) {
                this.setMeasureRow(sheet, row, rec3);
                ++row;
            }
        }
        return row;
    }

    private void setLocationRow(Sheet sheet, int row, CmsLocationTemplate l) {
        this.getCell(sheet, row, 1).setCellValue("G");
        String iconTitle = "";
        String iconFile = "";
        long idicon = l.getRelationAttribute("icon").getFirstElementId();
        if (idicon > 0L) {
            CmsIcon icon = (CmsIcon)this.project.loadElement(idicon, this.project.getUser());
            iconTitle = icon.getAttributeValue("title");
            UploadItem upload = icon.getUploadAttribute("file").getFirstUploadItem();
            if (upload != null) {
                iconFile = this.iconfoldername + upload.getName();
            }
        }
        block12: for (Map.Entry<String, Integer> entry : this.colLocation.entrySet()) {
            switch (entry.getKey()) {
                case "icon": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(iconFile);
                    break;
                }
                case "meta_lastedit": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(l.getDateAttribute(entry.getKey()).getDate());
                    break;
                }
                case "meta_uuid": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(l.getUUID().toString());
                    break;
                }
                case "infos": {
                    int col = entry.getValue();
                    RelationAttribute infoAtt = l.getRelationAttribute("infos");
                    if (infoAtt == null) continue block12;
                    for (CmsElementSummary ele : infoAtt.getElements()) {
                        this.getCell(sheet, row, col).setCellValue(ele.getTitle());
                        ++col;
                    }
                    continue block12;
                }
                default: {
                    ThemisAttribute ta = this.getSettings().getLocationAttribute(entry.getKey());
                    if (ta == null) continue block12;
                    this.getCell(sheet, row, entry.getValue()).setCellValue(l.getAttributeValue(ta.getCmsCode()));
                }
            }
        }
    }

    private void setObservationRow(Sheet sheet, int row, CmsObservationTemplate t) {
        int type = (int)t.getKeyAttribute("type").getId();
        switch (type) {
            case 1: {
                this.getCell(sheet, row, 1).setCellValue("BM");
                break;
            }
            case 2: {
                this.getCell(sheet, row, 1).setCellValue("BK");
                break;
            }
            case 3: {
                this.getCell(sheet, row, 1).setCellValue("BI");
                break;
            }
            case 4: {
                this.getCell(sheet, row, 1).setCellValue("BA");
                break;
            }
            default: {
                this.getCell(sheet, row, 1).setCellValue("BM");
            }
        }
        block22: for (Map.Entry<String, Integer> entry : this.colObservation.entrySet()) {
            switch (entry.getKey()) {
                case "repeatunit": {
                    long id = t.getKeyAttribute("repeat").getId();
                    this.getCell(sheet, row, entry.getValue()).setCellValue(id < 0L ? "" : Long.toString(id));
                    break;
                }
                case "repeat": {
                    if (!t.getKeyAttribute("repeat").hasValue()) continue block22;
                    this.getCell(sheet, row, entry.getValue()).setCellValue((double)t.getIntegerAttribute("duedate").getIntValue());
                    break;
                }
                case "meta_lastedit": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(t.getDateAttribute("meta_lastedit").getDate());
                    break;
                }
                case "meta_uuid": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(t.getUUID().toString());
                    break;
                }
                case "done": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(t.getBooleanAttribute("done").isSet() ? "TRUE" : "");
                    break;
                }
                case "infos": {
                    int col = entry.getValue();
                    RelationAttribute infoAtt = t.getRelationAttribute("infos");
                    if (infoAtt == null) continue block22;
                    for (CmsElementSummary ele : infoAtt.getElements()) {
                        this.getCell(sheet, row, col).setCellValue(ele.getTitle());
                        ++col;
                    }
                    continue block22;
                }
                default: {
                    ThemisAttribute ta = this.getSettings().getObservationAttribute(entry.getKey());
                    if (ta == null) continue block22;
                    String attval = t.getAttributeValue(ta.getCmsCode());
                    this.getCell(sheet, row, entry.getValue()).setCellValue(attval);
                }
            }
        }
    }

    private void setMeasureRow(Sheet sheet, int row, DataRecord rec) {
        this.getCell(sheet, row, 1).setCellValue("M");
        block8: for (Map.Entry<String, Integer> entry : this.colMeasure.entrySet()) {
            switch (entry.getKey()) {
                case "meta_lastedit": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(rec.getDate(entry.getKey(), this.app.getTimeZone()));
                    continue block8;
                }
                case "meta_uuid": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(rec.getString("meta_uuid"));
                    continue block8;
                }
            }
            this.getCell(sheet, row, entry.getValue()).setCellValue(rec.getString(entry.getKey()));
        }
    }

    private void setLocationGroupRow(Sheet sheet, int row, CmsLocationgroup grp, int level) {
        this.getCell(sheet, row, 1).setCellValue("GRP" + level);
        block8: for (Map.Entry<String, Integer> entry : this.colGroup.entrySet()) {
            switch (entry.getKey()) {
                case "meta_lastedit": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(grp.getDateAttribute(entry.getKey()).getDate());
                    continue block8;
                }
                case "meta_uuid": {
                    this.getCell(sheet, row, entry.getValue()).setCellValue(grp.getUUID().toString());
                    continue block8;
                }
            }
            this.getCell(sheet, row, entry.getValue()).setCellValue(grp.getAttributeValue(entry.getKey()));
        }
    }

    public void exportTemplatesAsZIP(File f) throws FileNotFoundException, IOException {
        ThemisFile tf = new ThemisFile();
        tf.setAsProjectTemplate();
        tf.saveToFile(f, false);
    }

    private Cell getCell(Sheet sh, int row, int col) {
        return this.getCell(sh, row, col, true);
    }

    private Cell getCell(Sheet sh, int row, int col, boolean applyStyle) {
        Cell c;
        Row r = sh.getRow(row - 1);
        if (r == null) {
            r = sh.createRow(row - 1);
        }
        if ((c = r.getCell(col - 1)) == null) {
            c = r.createCell(col - 1);
        }
        return c;
    }

    public String saveTemplatesAsXml(File f) {
        try {
            Element locationElement;
            Document doc = new Document();
            Element root = new Element("templates").setAttribute("version", "3.0");
            doc.setRootElement(root);
            HashMap<Long, Element> locations = new HashMap<Long, Element>();
            HashMap<Long, ArrayList> measures = new HashMap<Long, ArrayList>();
            ArrayList contacts = new ArrayList();
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("locationgroup");
            s.addSelectAllAttributes("locationgroup");
            List recs = s.search().getResult();
            for (DataRecord rec : recs) {
                Element groupElement = new Element("locationgroup").setText(rec.getString("title"));
                root.addContent((Content)groupElement);
            }
            s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("company");
            s.addSelectAllAttributes("company");
            recs = s.search().getResult();
            for (DataRecord rec : recs) {
                Element contactElement = new Element("contact").setAttribute("name", rec.getString("name")).setAttribute("tel", rec.getString("tel")).setAttribute("email", rec.getString("email"));
                root.addContent((Content)contactElement);
            }
            s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("measuretemplate");
            s.addSelectAllAttributes("measuretemplate");
            recs = s.search().getResult();
            for (DataRecord rec : recs) {
                long idobs = rec.getLong("idobservationtemplate");
                ArrayList elements = measures.containsKey(idobs) ? (ArrayList)measures.get(idobs) : new ArrayList();
                elements.add(new Element("measure").setAttribute("title", rec.getString("title")).setText(rec.getString("measure")));
                measures.put(idobs, elements);
            }
            s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("locationtemplate");
            s.addSelectAllAttributes("locationtemplate");
            s.addSelectRelationId((CmsAttribute)this.project.getDefaultElement("locationtemplate").getRelationAttribute("icon"));
            s.addSelectRelationTerm((CmsAttribute)this.project.getDefaultElement("locationtemplate").getRelationAttribute("locationgroup"));
            recs = s.search().getResult();
            for (DataRecord rec : recs) {
                locationElement = new Element("location").setAttribute("title", rec.get("title")).setAttribute("code", rec.get("code")).setAttribute("code2", rec.get("code2")).setAttribute("quantity", rec.get("quantity")).setAttribute("dimwidth", rec.get("dimwidth")).setAttribute("dimheight", rec.get("dimheight")).setAttribute("dimdiameter", rec.get("dimdiameter")).setAttribute("dimarea", rec.get("dimarea")).setAttribute("list1", rec.get("list1")).setAttribute("list2", rec.get("list2")).setAttribute("group", rec.getString("locationgroup"));
                locationElement.addContent((Content)new Element("description").setText(rec.getString("description")));
                if (!rec.isEmpty("idicon")) {
                    CmsIcon icon = (CmsIcon)this.project.loadElement(rec.getLong("idicon"), this.project.getUser());
                    UploadItem upload = icon.getUploadAttribute("file").getFirstUploadItem();
                    Util.copy((File)upload.getFile(), (File)new File(f.getParentFile(), upload.getName()));
                    locationElement.setAttribute("icon_file", upload.getName());
                    locationElement.setAttribute("icon_title", icon.getAttributeValue("title"));
                } else {
                    locationElement.setAttribute("icon_file", "");
                    locationElement.setAttribute("icon_title", "");
                }
                locations.put(rec.getLong("meta_id"), locationElement);
                root.addContent((Content)locationElement);
            }
            s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("observationtemplate");
            s.addSelectMeta();
            s.addSelectAllAttributes("observationtemplate");
            recs = s.search().getResult();
            for (DataRecord rec : recs) {
                long locationid = rec.getLong("idlocation");
                Element observationElement = new Element("observation").setAttribute("title", rec.get("title")).setAttribute("code", rec.get("code")).setAttribute("quantity", rec.get("quantity")).setAttribute("type", rec.get("observationtype")).setAttribute("topic", rec.get("topic")).setAttribute("priority", rec.get("priority")).setAttribute("responsible", rec.get("responsible")).setAttribute("done", rec.get("done")).setAttribute("duedate", rec.get("duedate")).setAttribute("repeat", rec.get("idrepeat"));
                observationElement.addContent((Content)new Element("info").setText(rec.get("description")));
                ArrayList es = (ArrayList)measures.get(rec.getLong("meta_id"));
                if (es != null) {
                    for (Element e : es) {
                        observationElement.addContent((Content)e);
                    }
                }
                if (locationid > 0L) {
                    locationElement = (Element)locations.get(locationid);
                    locationElement.addContent((Content)observationElement);
                    continue;
                }
                root.addContent((Content)observationElement);
            }
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat().setTextMode(Format.TextMode.PRESERVE));
            if (f != null) {
                try {
                    out.output(doc, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.app.getDialog().showInfoDialog(this.project.getResourceText("ThemisApplication.templatesLoaded.text", this.app.getLocale()));
            return out.outputString(doc);
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog(this.project.getResourceText("ThemisApplication.errorSavingtemplates.text", this.app.getLocale()), ex);
            return "";
        }
    }

    private void readCellStyles(Sheet sheet, int row) {
        this.cellstyles.clear();
        for (int ii = 1; ii < 50; ++ii) {
            this.cellstyles.add(this.getCell(sheet, row, ii, false).getCellStyle());
        }
    }

    class GroupFullSpec {
        String fullid;
        String fullname;

        public GroupFullSpec(String id, String name) {
            this.fullid = id;
            this.fullname = name;
        }

        public String toString() {
            return this.fullid;
        }
    }
}

