/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.util;

import at.grid.cms.content.UploadItem;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.openide.util.Exceptions;

public class EmailSendThread {
    ArrayList<String> recipients = new ArrayList();
    String bcc;
    String smtp;
    int port;
    int encryption;
    String from;
    String subject;
    String message;
    String messageType = "text/plain";
    ArrayList<File> attachments = new ArrayList();
    String authpwd = null;
    String authuser = null;
    PasswordAuthentication authentication;
    Properties mailHeader = new Properties();
    boolean inlineImage = false;
    public static final int TLS = 1;
    public static final int SSL = 2;

    public EmailSendThread() {
    }

    public EmailSendThread(String betreff, String msg) {
        this.subject = betreff;
        this.message = msg;
    }

    public EmailSendThread setSubject(String subj) {
        this.subject = subj;
        return this;
    }

    public EmailSendThread setMessage(String msg) {
        this.message = msg;
        return this;
    }

    public EmailSendThread addRecipient(String to) {
        this.recipients.add(to);
        return this;
    }

    public EmailSendThread setBcc(String bcc) {
        this.bcc = bcc;
        return this;
    }

    public EmailSendThread setFrom(String from) {
        this.from = from;
        return this;
    }

    public EmailSendThread setAuthentication(String user, String pwd) {
        this.authuser = user;
        this.authpwd = pwd;
        return this;
    }

    public EmailSendThread setAuthentication(PasswordAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public EmailSendThread setServer(String server, int port, int encryption) {
        this.smtp = server;
        this.port = port;
        this.encryption = encryption;
        return this;
    }

    public EmailSendThread setMessageType(String t) {
        this.messageType = t;
        return this;
    }

    public String getBcc() {
        return this.bcc;
    }

    public String getSmtp() {
        return this.smtp;
    }

    public int getPort() {
        return this.port;
    }

    public int getEncryption() {
        return this.encryption;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public EmailSendThread addAttachment(File file) {
        this.attachments.add(file);
        return this;
    }

    public EmailSendThread addMailHeader(Properties props) {
        if (props != null) {
            this.mailHeader.putAll((Map<?, ?>)props);
        }
        return this;
    }

    public EmailSendThread addMailHeader(String key, String val) {
        this.mailHeader.setProperty(key, val);
        return this;
    }

    public EmailSendThread setImagesInline() {
        this.inlineImage = true;
        return this;
    }

    public boolean send(boolean ignoreError) {
        MultiPartEmail email = this.createMail(ignoreError);
        try {
            if (email != null) {
                email.send();
                return true;
            }
        }
        catch (EmailException ex) {
            if (!ignoreError) {
                ThemisApplication.getInstance().getDialog().showWarningDialog("Fehler beim Senden des Emails. Bitte \u00fcberpr\u00fcfen Sie Ihre Internetverbindung, sowie Ihre Email Konfiguration in den Systemeinstellungen.\nFehler: " + ex.getMessage());
                ex.printStackTrace();
            }
            ThemisLogger.logger.warning("Fehler beim Senden des Emails: " + ex.getLocalizedMessage());
        }
        return false;
    }

    public boolean send2(boolean ignoreError) {
        MimeMessage email = this.createEmail2();
        if (email != null) {
            try {
                Transport.send((Message)email);
                return true;
            }
            catch (MessagingException ex) {
                if (!ignoreError) {
                    ThemisApplication.getInstance().getDialog().showWarningDialog("Fehler beim Senden des Emails. Bitte \u00fcberpr\u00fcfen Sie Ihre Internetverbindung, sowie Ihre Email Konfiguration in den Systemeinstellungen.\nFehler: " + ex.getMessage());
                    ex.printStackTrace();
                }
                ThemisLogger.logger.warning("Fehler beim Senden des Emails: " + ex.getLocalizedMessage());
            }
        }
        return false;
    }

    public MultiPartEmail createMail(boolean ignoreError) {
        try {
            MultiPartEmail email = new MultiPartEmail();
            email.setSmtpPort(this.port);
            switch (this.encryption) {
                case 2: {
                    email.setSSL(true);
                    break;
                }
                case 1: {
                    email.setTLS(true);
                }
            }
            if (this.authentication != null) {
                email.setAuthentication(this.authentication.getUserName(), this.authentication.getPassword());
            } else if (this.authuser != null) {
                email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.authuser, this.authpwd));
            }
            if (ThemisApplication.getInstance().isDebugMode()) {
                email.setDebug(true);
            }
            email.setHostName(this.smtp);
            email.setFrom(this.from);
            email.setSubject(this.subject);
            email.setHeaders((Map)this.mailHeader);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)this.message, this.messageType);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (File f : this.attachments) {
                messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(f);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(f.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            email.setContent(multipart);
            for (String to : this.recipients) {
                email.addTo(to);
            }
            return email;
        }
        catch (Exception ex) {
            if (!ignoreError) {
                ThemisApplication.getInstance().getDialog().showWarningDialog("Fehler beim Erstellen der E-Mails.\nFehler: " + ex.getMessage());
                ex.printStackTrace();
            }
            ThemisLogger.logger.warning("Error while creating an e-mail: " + ex.getLocalizedMessage());
            return null;
        }
    }

    public MimeMessage createEmail2() {
        MimeMessage message = null;
        try {
            Properties props = new Properties();
            props.setProperty("mail.transport.protocol", "smtp");
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            message = new MimeMessage(mailSession);
            MimeMultipart multipart = new MimeMultipart();
            message.setHeader("X-Unsent", "1");
            if (this.mailHeader != null) {
                for (String headerKey : this.mailHeader.stringPropertyNames()) {
                    message.setHeader(headerKey, this.mailHeader.getProperty(headerKey));
                }
            }
            message.setSubject(this.subject);
            if (this.recipients != null) {
                message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)String.join((CharSequence)",", this.recipients)));
            }
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)this.message, this.messageType);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (File f : this.attachments) {
                if (this.inlineImage && "jpg".equalsIgnoreCase(Util.getFileExtension((File)f))) {
                    messageBodyPart = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(f);
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                    messageBodyPart.setHeader("Content-ID", "<image>");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    continue;
                }
                messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(f);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(f.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)multipart);
        }
        catch (MessagingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return message;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        is.close();
        return bytes;
    }

    private void attachFiles(MultiPartEmail email, List<UploadItem> items) throws FileNotFoundException, IOException, EmailException {
        for (UploadItem item : items) {
            FileInputStream fin = new FileInputStream(item.getFile());
            ByteArrayDataSource source = new ByteArrayDataSource(EmailSendThread.getBytesFromFile(item.getFile()), "application/octet-stream");
            email.attach((DataSource)source, item.getName(), "attachment", "attachment");
        }
    }

    public void saveToFile(File f) {
        MimeMessage email = this.createEmail2();
        if (email != null) {
            try (FileOutputStream fos = new FileOutputStream(f);){
                email.writeTo((OutputStream)fos);
            }
            catch (IOException | MessagingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

