/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.util;

import at.grid.cms.content.Keytable;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;

public class RiskAssessment {
    ThemisProject project = ThemisApplication.getInstance().getProject();
    Keytable tblProbability = null;
    Keytable tblDamage = null;
    Keytable tblRisk = null;

    public RiskAssessment(String tblProbName, String tblDamageName, String tblRiskName) {
        this.tblProbability = this.project.getKeytable(tblProbName);
        this.tblDamage = this.project.getKeytable(tblDamageName);
        this.tblRisk = this.project.getKeytable(tblRiskName);
    }

    public long calcRisk(long idProbability, long idDamage) {
        int upperClassLimit;
        if (!this.project.isOpen()) {
            return -1L;
        }
        if (this.tblProbability == null || this.tblProbability.size() == 0) {
            return -1L;
        }
        if (this.tblDamage == null || this.tblDamage.size() == 0) {
            return -1L;
        }
        if (this.tblRisk == null || this.tblRisk.size() == 0) {
            return -1L;
        }
        int idxProbability = this.tblProbability.getIndex(idProbability);
        int idxDamage = this.tblDamage.getIndex(idDamage);
        int risk = idxProbability + 1 + idxDamage;
        int riskMax = this.tblProbability.size() + this.tblDamage.size() - 1;
        int countRiskClass = this.tblRisk.size();
        float riskClassStep = countRiskClass / riskMax;
        int idxRisk = this.tblRisk.size() - 1;
        int ii = 0;
        while (ii < this.tblRisk.size() && risk <= (upperClassLimit = (int)((float)(ii + 1) * riskClassStep))) {
            idxRisk = ii++;
        }
        long idRisk = this.tblRisk.getIdSafe(idxRisk);
        return idRisk;
    }
}

