/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class Util {
    public static Logger logger = null;
    public static String DATETIME_SQL = "yyyy-MM-dd HH:mm:ss";
    public static String DATETIME_XML = "yyyy-MM-dd HH:mm:ss";
    public static String DATETIME_ISO = "yyyy-MM-dd HH:mm:ss";
    public static String DATETIME_FILE = "yyyyMMdd_HHmmss";
    public static String DATETIME_URL = "yyyyMMddHHmmss";
    public static String DATETIME_READ = "dd.MM.yyyy HH:mm:ss";
    public static String DATE_SQL = "yyyy-MM-dd";
    public static String DATE_XML = "yyyy-MM-dd";
    public static String DATE_ISO = "yyyy-MM-dd";
    public static String DATE_FILE = "yyyyMMdd";
    public static String DATE_URL = "yyyyMMdd";
    public static String DATE_READ = "dd.MM.yyyy";

    public static Logger getLogger(String name) {
        if (logger == null) {
            logger = Logger.getLogger(name);
            logger.setUseParentHandlers(false);
            ConsoleHandler h = new ConsoleHandler();
            h.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    String lvl = record.getLevel().getName();
                    int idx = Math.max(12, lvl.length());
                    String ref = "";
                    if (record.getLevel().equals(Level.SEVERE)) {
                        ref = " [" + record.getSourceClassName() + ":" + record.getSourceMethodName() + "] ";
                    }
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(record.getMillis()) + " " + lvl + "              ".substring(idx) + record.getMessage() + ref + "\n";
                }
            });
            logger.addHandler(h);
        }
        return logger;
    }

    public static Logger getFileLogger(File output, String name) {
        if (logger == null) {
            StreamHandler h;
            logger = Logger.getLogger(name);
            logger.setUseParentHandlers(false);
            try {
                h = new FileHandler(output.getAbsolutePath(), true);
            }
            catch (IOException ex) {
                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                h = new ConsoleHandler();
            }
            catch (SecurityException ex) {
                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                h = new ConsoleHandler();
            }
            h.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(record.getMillis()) + " " + record.getLevel() + " [" + record.getSourceClassName() + ":" + record.getSourceMethodName() + "] " + record.getMessage() + "\n";
                }
            });
            logger.addHandler(h);
        }
        return logger;
    }

    public static double round(double v, int s) {
        double exp = Math.pow(10.0, s);
        return (double)Math.round(v * exp) / exp;
    }

    public static float round(float v, int s) {
        return (float)Util.round((double)v, s);
    }

    public static double interpolate(double[] x, double[] y, double x0) throws IllegalArgumentException {
        int ii;
        int l = x.length;
        if (l != y.length) {
            throw new IllegalArgumentException("Array length mismatch, cannot interpolate");
        }
        for (ii = 1; ii < l; ++ii) {
            if (x[ii] < x[ii - 1]) {
                throw new IllegalArgumentException("X-array not sorted, cannot interpolate");
            }
            if (x[ii] != x[ii - 1]) continue;
            throw new IllegalArgumentException("Two equal x-values, cannot interpolate");
        }
        if (x0 < x[0]) {
            return y[0];
        }
        if (x0 > x[l - 1]) {
            return y[l - 1];
        }
        for (ii = 1; ii < l; ++ii) {
            if (!(x0 <= x[ii])) continue;
            return y[ii - 1] + (y[ii] - y[ii - 1]) * (x0 - x[ii - 1]) / (x[ii] - x[ii - 1]);
        }
        return 0.0;
    }

    public static double randomNorm(double mean, double stdev) {
        double x2;
        double x1;
        while ((x1 = Math.random()) * x1 + (x2 = Math.random()) * x2 > 1.0 || x1 == 0.0 && x2 == 0.0) {
        }
        double z = Math.sqrt(-2.0 * Math.log(x1)) * Math.cos(Math.PI * 2 * x2);
        return mean + z * stdev;
    }

    public static double randomExp(double mean) {
        double x1;
        while ((x1 = Math.random()) == 0.0) {
        }
        double z = -Math.log(x1);
        return mean * z;
    }

    public static String formatDate(Date dt, String pattern) {
        return Util.formatDate(dt, pattern, TimeZone.getTimeZone("GMT+1"));
    }

    public static String formatDate(Date dt, String pattern, TimeZone tz) {
        if (dt == null) {
            return "null";
        }
        SimpleDateFormat frm = new SimpleDateFormat(pattern);
        frm.setTimeZone(tz);
        return frm.format(dt);
    }

    public static Date parseDate(String dt, String pattern) throws ParseException {
        return Util.parseDate(dt, pattern, TimeZone.getTimeZone("GMT+1"));
    }

    public static Date parseDate(String dt, String pattern, TimeZone tz) throws ParseException {
        SimpleDateFormat frm = new SimpleDateFormat(pattern);
        frm.setTimeZone(tz);
        return frm.parse(dt);
    }

    public static String recode(String codeFrom, String codeTo, String s) {
        Charset chsFrom = Charset.forName(codeFrom);
        Charset chsTo = Charset.forName(codeTo);
        ByteBuffer bb = chsFrom.encode(s);
        CharBuffer cb = chsTo.decode(bb);
        return cb.toString();
    }

    public static String toSqlString(boolean b) {
        if (b) {
            return "'t'";
        }
        return "'f'";
    }

    public static String toSqlString(String s) {
        if (s == null) {
            return "null";
        }
        return "'" + s.replaceAll("'", "''") + "'";
    }

    public static String toSqlString(Date dt, TimeZone tz) {
        if (dt == null) {
            return "null";
        }
        return "'" + Util.formatDate(dt, DATETIME_SQL, tz) + "'";
    }

    public static String toSqlString(Iterable lst) {
        return Util.toSqlString(lst, false);
    }

    public static String toSqlString(Iterable lst, boolean withQoutes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("(");
        for (Object o : lst) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            if (withQoutes) {
                sb.append("'");
            }
            sb.append(o.toString());
            if (!withQoutes) continue;
            sb.append("'");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toString(Iterable lst) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : lst) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public static String md5(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(s.getBytes(), 0, s.length());
            StringBuilder result = new StringBuilder(new BigInteger(1, m.digest()).toString(16));
            while (result.length() < 32) {
                result.insert(0, "0");
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return "error";
        }
    }

    public static void copy(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                Util.copy(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            Util.copy(in, out);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static void delete(File location) throws IOException {
        if (location.isDirectory()) {
            File[] children;
            for (File f : children = location.listFiles()) {
                Util.delete(f);
            }
            location.delete();
        } else {
            location.delete();
        }
    }

    public static String fileToString(File f) throws IOException {
        if (!f.exists() || f.isDirectory()) {
            return null;
        }
        byte[] buffer = new byte[(int)f.length()];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        bis.read(buffer);
        return new String(buffer);
    }

    public static void stringToFile(String s, File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        fw.write(s);
        fw.close();
    }

    public static void socketClient(String address, int port) {
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            echoSocket = new Socket(address, port);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: " + address);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: " + address);
            System.exit(1);
        }
        try {
            String teststring = "Teststring from socket client";
            System.out.println("Starting socket client");
            System.out.println("Client is sending '" + teststring + "'");
            out.println(teststring);
            System.out.println("Server is responding '" + in.readLine() + "'");
            out.close();
            in.close();
            echoSocket.close();
            System.out.println("Terminating socket client");
        }
        catch (IOException e) {
            System.out.println("R/W ERror");
        }
    }

    public static void socketServer(int port) {
        System.out.println("Starting socket server");
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: " + port);
            System.exit(1);
        }
        Socket clientSocket = null;
        try {
            clientSocket = serverSocket.accept();
        }
        catch (IOException e) {
            System.err.println("Accept failed.");
            System.exit(1);
        }
        try {
            String inputLine;
            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                System.out.println("Received: '" + inputLine + "'");
                String outputLine = "ECHO: " + inputLine;
                out.println(outputLine);
                System.out.println("Sent: " + outputLine);
                if (!outputLine.equals("Bye.")) continue;
                System.out.println("Terminating socket server");
                break;
            }
            out.close();
            in.close();
            clientSocket.close();
            serverSocket.close();
        }
        catch (IOException e) {
            System.out.println("R/W ERror");
        }
    }

    public static void log(Level SEVERE, String string) {
        Util.getLogger("grid").log(SEVERE, string);
    }

    public static BufferedImage resizeImage(BufferedImage img, int newW) {
        int w = img.getWidth();
        int h = img.getHeight();
        int newH = (int)((float)h * (float)newW / (float)w);
        int type = img.getType();
        BufferedImage resizedImage = new BufferedImage(newW, newH, 1);
        Graphics2D g = resizedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, newW, newH, 0, 0, w, h, null);
        g.dispose();
        return resizedImage;
    }

    public static Date julDayToDate(int julDay) {
        int ja;
        int julGreg = 2299161;
        if (julDay >= julGreg) {
            int jalpha = (int)(((double)(julDay - 1867216) - 0.25) / 36524.25);
            ja = julDay + 1 + jalpha - (int)(0.25 * (double)jalpha);
        } else {
            ja = julDay;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = (int)((double)(365 * jc) + 0.25 * (double)jc);
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
        return cal.getTime();
    }

    public static int dateToJulDay(Date dt) {
        int jm;
        int jy;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        int greg = 588829;
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        if (year < 0) {
            ++year;
        }
        if (month > 2) {
            jy = year;
            jm = month + 1;
        } else {
            jy = year - 1;
            jm = month + 13;
        }
        int jul = (int)(365.25 * (double)jy) + (int)(30.6001 * (double)jm) + day + 1720995;
        if (day + 31 * (month + 12 * year) >= greg) {
            int ja = (int)(0.01 * (double)jy);
            jul = jul + 2 - ja + (int)(0.25 * (double)ja);
        }
        return jul;
    }

    public static int countDays(Calendar cal, Date from, Date to) throws IllegalArgumentException {
        long deltaT = from.getTime() - to.getTime();
        int count = (int)(deltaT / 86400000L);
        cal.setTime(from);
        cal.add(5, count);
        if (cal.getTime().before(to)) {
            while (cal.getTime().before(to)) {
                cal.add(5, 1);
                ++count;
            }
        } else if (cal.getTime().after(to)) {
            while (cal.getTime().after(to)) {
                cal.add(5, -1);
                --count;
            }
        }
        if (!cal.getTime().equals(to)) {
            throw new IllegalArgumentException("Cannot count days, dates show different time of day");
        }
        return count;
    }

    public static void main(String[] args) {
    }
}

