/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class XML {
    public static Float getAttributeFloat(Element e, String att) {
        try {
            return Float.valueOf(e.getAttribute(att).getFloatValue());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Double getAttributeDouble(Element e, String att) {
        try {
            return e.getAttribute(att).getDoubleValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Integer getAttributeInt(Element e, String att) {
        try {
            return e.getAttribute(att).getIntValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Attribute getXPathAttribute(Element e, String xpath) throws JDOMException {
        String fullxpath = XML.getXPath(e, xpath);
        return (Attribute)XPath.selectSingleNode((Object)e, (String)fullxpath);
    }

    public static String getXPathAttributeValue(Element e, String xpath) throws JDOMException {
        Attribute att = XML.getXPathAttribute(e, xpath);
        if (att == null) {
            return null;
        }
        return att.getValue();
    }

    public static String getXPathAttributeValue(Element e, String xpath, String defaultvalue) throws JDOMException {
        String r = XML.getXPathAttributeValue(e, xpath);
        if (r == null) {
            return defaultvalue;
        }
        return r;
    }

    public static Element getXPathElement(Element e, String xpath) throws JDOMException {
        String fullxpath = XML.getXPath(e, xpath);
        return (Element)XPath.selectSingleNode((Object)e, (String)fullxpath);
    }

    public static String getXPathElementText(Element e, String xpath) throws JDOMException {
        Element ele = XML.getXPathElement(e, xpath);
        if (ele == null) {
            return null;
        }
        return ele.getText();
    }

    public static String getXPathElementText(Element e, String xpath, String defaultvalue) throws JDOMException {
        String r = XML.getXPathElementText(e, xpath);
        if (r == null) {
            return defaultvalue;
        }
        return r;
    }

    public static List<Element> getXPathElements(Element e, String xpath) throws JDOMException {
        String fullxpath = XML.getXPath(e, xpath);
        List selectNodes = XPath.selectNodes((Object)e, (String)fullxpath);
        return selectNodes;
    }

    public static String getXPath(Element e) {
        String xpath = "";
        while (e.getParentElement() != null) {
            e = e.getParentElement();
            xpath = "/" + e.getName() + xpath;
        }
        return xpath;
    }

    public static String getXPath(Element e, String xpath) {
        String fullxpath = XML.getXPath(e);
        if (!xpath.startsWith("/")) {
            xpath = "/" + xpath;
        }
        return fullxpath + xpath;
    }

    public static void main(String[] args) throws JDOMException, IOException {
        Document doc = new Document(new Element("root"));
        Element main = new Element("main");
        Element sub = new Element("sub");
        sub.setAttribute("att", "val");
        sub.setAttribute("att2", "2");
        main.addContent((Content)sub);
        doc.getRootElement().addContent((Content)main);
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        out.output(doc, (OutputStream)System.out);
        System.out.println("");
        System.out.println("-----");
        System.out.println(XML.getXPath(sub));
        System.out.println(XML.getXPathElement(doc.getRootElement(), "/root/main/sub"));
        System.out.println(XML.getXPathElement(doc.getRootElement(), "/main/sub"));
        System.out.println(XML.getXPathElement(doc.getRootElement(), "//sub"));
    }
}

