/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util.cli;

import at.grid.util.cli.Console;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Command {
    private String action;
    private Console source;
    private String text;
    private ArrayList<String> args;
    private HashMap<String, String> options;
    private String redirect;
    private boolean helprequest;
    private boolean exclusive;

    public Command(Console source, String text) throws InvalidParameterException {
        if (text.equals("")) {
            throw new InvalidParameterException("No action text provided");
        }
        this.source = source;
        this.text = text;
        this.parseText(text);
        this.exclusive = false;
    }

    private void parseText(String parseText) throws InvalidParameterException {
        if (parseText.startsWith(":")) {
            parseText = "runmacro " + parseText.substring(1);
        }
        if (parseText.startsWith("&")) {
            parseText = "runmacro " + parseText.substring(1);
        }
        StringTokenizer tok = new StringTokenizer(parseText, " ");
        this.args = new ArrayList();
        this.options = new HashMap();
        this.action = tok.nextToken().toLowerCase();
        String argument = "";
        boolean quotedArgument = false;
        while (tok.hasMoreTokens()) {
            argument = quotedArgument ? argument + " " + tok.nextToken() : tok.nextToken();
            if (!quotedArgument && argument.indexOf("=") > 0) {
                String[] option = argument.split("=");
                this.options.put(option[0], option[1]);
                continue;
            }
            if ("/?".equals(argument) || "-?".equals(argument)) {
                this.setHelprequest(true);
                continue;
            }
            if (argument.startsWith("/") || argument.startsWith("-")) {
                this.options.put(argument.substring(1), "");
                continue;
            }
            if (argument.startsWith("\"")) {
                quotedArgument = true;
                argument = argument.substring(1);
            }
            if (argument.endsWith("\"")) {
                quotedArgument = false;
                argument = argument.substring(0, argument.length() - 1);
            }
            if (quotedArgument) continue;
            this.args.add(argument);
        }
    }

    public int countArgs() {
        return this.args.size();
    }

    public int countOptions() {
        return this.options.size();
    }

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public String getAction() {
        return this.action;
    }

    public Console getSource() {
        return this.source;
    }

    public ArrayList<String> getArgs() {
        return this.args;
    }

    public HashMap<String, String> getOptions() {
        return this.options;
    }

    public String getArgument(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.countArgs()) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " exceeds number of arguments: " + this.countArgs());
        }
        return this.args.get(index);
    }

    public String getOption(String option) {
        return this.options.get(option);
    }

    public String getOption(String option, String defaultvalue) {
        String v = this.options.get(option);
        if (v == null) {
            return defaultvalue;
        }
        return v;
    }

    public boolean hasOption(String option) {
        return this.options.containsKey(option);
    }

    public boolean hasArgument(String arg) {
        return this.args.contains(arg);
    }

    private void setHelprequest(boolean flag) {
        this.helprequest = flag;
    }

    public boolean isHelprequest() {
        return this.helprequest;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean flag) {
        this.exclusive = flag;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasRedirect() {
        return this.redirect != null;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void display(String message) {
        this.getSource().display(message);
    }
}

