/*
 * Decompiled with CFR 0.152.
 */
package at.grid.util.cli;

import at.grid.util.cli.CLIApplication;
import at.grid.util.cli.Command;
import at.grid.util.cli.Terminal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Console
implements Terminal {
    protected CLIApplication app;
    protected String prompt;
    protected BufferedReader in;
    protected PrintStream out;

    public Console(CLIApplication app, String prompt) {
        this.app = app;
        this.prompt = prompt;
        this.in = new BufferedReader(new InputStreamReader(this.getInputStream()));
        this.out = new PrintStream(this.getOutputStream());
        this.start();
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public final void start() {
        while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = this.readCommand().trim()).equals("")) {
                        continue;
                    }
                    this.app.execute(new Command(this, line));
                }
            }
            catch (IOException except) {
                this.out.println("Error while reading from input stream: " + except.getLocalizedMessage());
                continue;
            }
            catch (Exception except) {
                this.out.println("Undefined error: " + except.toString());
                except.printStackTrace(this.out);
                continue;
            }
            break;
        }
    }

    public String readCommand() throws IOException {
        this.out.print(this.prompt);
        this.out.print("> ");
        String result = this.in.readLine();
        return result;
    }

    public PrintStream getOutputStream() {
        return System.out;
    }

    public InputStream getInputStream() {
        return System.in;
    }

    @Override
    public void display(String text) {
        this.out.println(text);
    }

    public void progressPrepare(int width, String prefix) {
        this.out.print(prefix);
        this.out.print(" ");
        for (int ii = 0; ii < width; ++ii) {
            this.out.print(" ");
        }
        this.out.print("|\r" + prefix + "|");
    }

    public void progressPrint() {
        this.out.print(".");
    }

    public void progressFinish() {
        this.out.println();
    }

    @Override
    public String getIdentification() {
        return "Local Console";
    }
}

