/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.ByteOrder;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.util.Debug;

public class JpegUtils
extends BinaryFileParser
implements JpegConstants {
    public JpegUtils() {
        this.setByteOrder(ByteOrder.NETWORK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverseJFIF(ByteSource byteSource, Visitor visitor) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            int marker;
            byte[] markerBytes;
            is = byteSource.getInputStream();
            this.readAndVerifyBytes(is, SOI, "Not a Valid JPEG File: doesn't begin with 0xffd8");
            int markerCount = 0;
            while (true) {
                byte[] segmentData;
                markerBytes = new byte[]{markerBytes[1], this.readByte("marker", is, "Could not read marker")};
                while ((0xFF & markerBytes[0]) != 255 || (0xFF & markerBytes[1]) == 255) {
                }
                marker = (0xFF & markerBytes[0]) << 8 | 0xFF & markerBytes[1];
                if (marker == 65497 || marker == 65498) {
                    if (!visitor.beginSOS()) {
                        return;
                    }
                    break;
                }
                byte[] segmentLengthBytes = this.readBytes("segmentLengthBytes", is, 2, "segmentLengthBytes");
                int segmentLength = this.toUInt16(segmentLengthBytes);
                if (!visitor.visitSegment(marker, markerBytes, segmentLength, segmentLengthBytes, segmentData = this.readBytes("Segment Data", is, segmentLength - 2, "Invalid Segment: insufficient data"))) {
                    return;
                }
                ++markerCount;
            }
            byte[] imageData = this.getStreamBytes(is);
            visitor.visitSOS(marker, markerBytes, imageData);
            Debug.debug("" + markerCount + " markers");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public static String getMarkerName(int marker) {
        switch (marker) {
            case 65498: {
                return "SOS_Marker";
            }
            case 65505: {
                return "JPEG_APP1_Marker";
            }
            case 65506: {
                return "JPEG_APP2_Marker";
            }
            case 65517: {
                return "JPEG_APP13_Marker";
            }
            case 65518: {
                return "JPEG_APP14_Marker";
            }
            case 65519: {
                return "JPEG_APP15_Marker";
            }
            case 65504: {
                return "JFIFMarker";
            }
            case 65472: {
                return "SOF0Marker";
            }
            case 65473: {
                return "SOF1Marker";
            }
            case 65474: {
                return "SOF2Marker";
            }
            case 65475: {
                return "SOF3Marker";
            }
            case 65476: {
                return "SOF4Marker";
            }
            case 65477: {
                return "SOF5Marker";
            }
            case 65478: {
                return "SOF6Marker";
            }
            case 65479: {
                return "SOF7Marker";
            }
            case 65480: {
                return "SOF8Marker";
            }
            case 65481: {
                return "SOF9Marker";
            }
            case 65482: {
                return "SOF10Marker";
            }
            case 65483: {
                return "SOF11Marker";
            }
            case 65484: {
                return "DACMarker";
            }
            case 65485: {
                return "SOF13Marker";
            }
            case 65486: {
                return "SOF14Marker";
            }
            case 65487: {
                return "SOF15Marker";
            }
            case 65499: {
                return "DQTMarker";
            }
        }
        return "Unknown";
    }

    public void dumpJFIF(ByteSource byteSource) throws ImageReadException, IOException {
        Visitor visitor = new Visitor(){

            public boolean beginSOS() {
                return true;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
                Debug.debug("SOS marker.  " + imageData.length + " bytes of image data.");
                Debug.debug("");
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int segmentLength, byte[] segmentLengthBytes, byte[] segmentData) {
                Debug.debug("Segment marker: " + Integer.toHexString(marker) + " (" + JpegUtils.getMarkerName(marker) + "), " + segmentData.length + " bytes of segment data.");
                return true;
            }
        };
        this.traverseJFIF(byteSource, visitor);
    }

    public static interface Visitor {
        public boolean beginSOS();

        public void visitSOS(int var1, byte[] var2, byte[] var3);

        public boolean visitSegment(int var1, byte[] var2, int var3, byte[] var4, byte[] var5) throws ImageReadException, IOException;
    }
}

